/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import java.lang.reflect.Method;
import org.directwebremoting.create.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonCreator
extends AbstractCreator
implements Creator {
    private String factoryMethod = "getInstance";
    private Class<?> clazz;

    public void setClass(String classname) {
        try {
            this.clazz = LocalUtil.classForName(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(Messages.getString("Creator.ClassNotFound", classname));
        }
    }

    @Override
    public Object getInstance() throws InstantiationException {
        try {
            Method method = this.clazz.getMethod(this.factoryMethod, new Class[0]);
            return method.invoke((Object)new SingletonCreator(), new Object[0]);
        }
        catch (Exception ex) {
            throw new InstantiationException(Messages.getString("Creator.IllegalAccess"));
        }
    }

    @Override
    public Class<?> getType() {
        return this.clazz;
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(String functionToCall) {
        this.factoryMethod = functionToCall;
    }
}

