/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreator
implements Creator {
    private boolean cacheable = false;
    private String javascript = null;
    private String scope = "page";
    private static final Log log = LogFactory.getLog(AbstractCreator.class);

    @Override
    public void setProperties(Map<String, String> params) throws IllegalArgumentException {
    }

    @Override
    public String getJavascript() {
        return this.javascript;
    }

    public void setJavascript(String javascript) {
        if (!LocalUtil.isJavaIdentifier(javascript)) {
            log.error((Object)("Illegal identifier: '" + javascript + "'"));
            throw new IllegalArgumentException("Illegal identifier");
        }
        this.javascript = javascript;
    }

    public void setScope(String scope) {
        AbstractCreator.checkScope(scope);
        this.scope = scope;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    protected static void checkScope(String cscope) {
        if (!(cscope.equals("script") || cscope.equals("page") || cscope.equals("request") || cscope.equals("session") || cscope.equals("application"))) {
            throw new IllegalArgumentException(Messages.getString("AbstractCreator.IllegalScope", cscope));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getJavascript() + "]";
    }
}

