/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.io.Reader;
import java.io.StringReader;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMConverter
extends BaseV20Converter
implements Converter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        String value = LocalUtil.decode(data.getValue());
        try {
            Builder builder = new Builder();
            Document doc = builder.build((Reader)new StringReader(value));
            if (paramType == Document.class) {
                return doc;
            }
            if (paramType == Element.class) {
                return doc.getRootElement();
            }
            throw new MarshallException(paramType);
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        try {
            if (!(data instanceof Node)) {
                throw new MarshallException(data.getClass());
            }
            Node node = (Node)data;
            String script = EnginePrivate.xmlStringToJavascriptDom(node.toXML());
            NonNestedOutboundVariable ov = new NonNestedOutboundVariable(script);
            outctx.put(data, ov);
            return ov;
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(data.getClass(), (Throwable)ex);
        }
    }
}

