/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.annotations;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.Container;
import org.directwebremoting.annotations.Auth;
import org.directwebremoting.annotations.DataTransferObject;
import org.directwebremoting.annotations.Filter;
import org.directwebremoting.annotations.Filters;
import org.directwebremoting.annotations.GlobalFilter;
import org.directwebremoting.annotations.Param;
import org.directwebremoting.annotations.RemoteMethod;
import org.directwebremoting.annotations.RemoteProperty;
import org.directwebremoting.annotations.RemoteProxy;
import org.directwebremoting.annotations.ScriptScope;
import org.directwebremoting.convert.BeanConverter;
import org.directwebremoting.create.NewCreator;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsConfigurator
implements Configurator {
    private static final String METHOD_PREFIX_IS = "is";
    private static final String METHOD_PREFIX_GET = "get";
    private static final Log log = LogFactory.getLog(AnnotationsConfigurator.class);

    @Override
    public void configure(Container container) {
        for (Class<?> clazz : this.getClasses(container)) {
            try {
                this.processClass(clazz, container);
            }
            catch (Exception ex) {
                log.error((Object)("Failed to process class: " + clazz.getName()), (Throwable)ex);
            }
        }
    }

    protected Set<Class<?>> getClasses(Container container) {
        HashSet classes;
        block7: {
            classes = new HashSet();
            Object data = container.getBean("classes");
            if (data == null) break block7;
            if (data instanceof String) {
                String classesStr = (String)data;
                for (String element : classesStr.split(",")) {
                    try {
                        Class<?> clazz = LocalUtil.classForName(element.trim());
                        classes.add(clazz);
                    }
                    catch (Exception ex) {
                        log.error((Object)("Failed to process class: " + element), (Throwable)ex);
                    }
                }
            } else {
                try {
                    classes.add(data.getClass());
                }
                catch (Exception ex) {
                    log.error((Object)("Failed to process class: " + data.getClass().getName()), (Throwable)ex);
                }
            }
        }
        return classes;
    }

    protected void processClass(Class<?> clazz, Container container) throws InstantiationException, IllegalAccessException {
        GlobalFilter globalFilterAnn;
        DataTransferObject convertAnn;
        RemoteProxy createAnn = clazz.getAnnotation(RemoteProxy.class);
        if (createAnn != null) {
            this.processCreate(clazz, createAnn, container);
        }
        if ((convertAnn = clazz.getAnnotation(DataTransferObject.class)) != null) {
            this.processConvert(clazz, convertAnn, container);
        }
        if ((globalFilterAnn = clazz.getAnnotation(GlobalFilter.class)) != null) {
            this.processGlobalFilter(clazz, globalFilterAnn, container);
        }
    }

    protected void processCreate(Class<?> clazz, RemoteProxy createAnn, Container container) {
        Class<? extends Creator> creator = createAnn.creator();
        String creatorClass = creator.getName();
        Map<String, String> creatorParams = this.getParamsMap(createAnn.creatorParams());
        ScriptScope scope = createAnn.scope();
        CreatorManager creatorManager = container.getBean(CreatorManager.class);
        String creatorName = creatorClass.replace(".", "_");
        creatorManager.addCreatorType(creatorName, creatorClass);
        HashMap<String, String> params = new HashMap<String, String>();
        if (NewCreator.class.isAssignableFrom(creator)) {
            params.put("class", clazz.getName());
        }
        params.putAll(creatorParams);
        params.put("scope", scope.getValue());
        String name = createAnn.name();
        if (name == null || name.length() == 0) {
            name = clazz.getSimpleName();
        }
        try {
            log.info((Object)("Adding class " + clazz.getName() + " as " + name));
            creatorManager.addCreator(name, creatorName, params);
        }
        catch (Exception ex) {
            log.error((Object)("Failed to add class as Creator: " + clazz.getName()), (Throwable)ex);
        }
        AccessControl accessControl = container.getBean(AccessControl.class);
        for (Method method : clazz.getMethods()) {
            if (method.getAnnotation(RemoteMethod.class) == null) continue;
            accessControl.addIncludeRule(name, method.getName());
            Auth authAnn = method.getAnnotation(Auth.class);
            if (authAnn == null) continue;
            for (String role : authAnn.role()) {
                accessControl.addRoleRestriction(name, method.getName(), role);
            }
        }
        Filters filtersAnn = clazz.getAnnotation(Filters.class);
        if (filtersAnn != null) {
            Filter[] fs;
            for (Filter filter : fs = filtersAnn.value()) {
                this.processFilter(filter, name, container);
            }
        } else {
            Filter filterAnn = clazz.getAnnotation(Filter.class);
            if (filterAnn != null) {
                this.processFilter(filterAnn, name, container);
            }
        }
    }

    protected void processFilter(Filter filterAnn, String name, Container container) {
        Map<String, String> filterParams = this.getParamsMap(filterAnn.params());
        AjaxFilter filter = LocalUtil.classNewInstance(name, filterAnn.type().getName(), AjaxFilter.class);
        if (filter != null) {
            LocalUtil.setParams(filter, filterParams, null);
            AjaxFilterManager filterManager = container.getBean(AjaxFilterManager.class);
            filterManager.addAjaxFilter(filter, name);
        }
    }

    protected void processConvert(Class<?> clazz, DataTransferObject convertAnn, Container container) throws InstantiationException, IllegalAccessException {
        Class<? extends Converter> converter = convertAnn.converter();
        String converterClass = converter.getName();
        Map<String, String> params = this.getParamsMap(convertAnn.params());
        ConverterManager converterManager = container.getBean(ConverterManager.class);
        String converterName = converterClass.replace(".", "_");
        converterManager.addConverterType(converterName, converterClass);
        if (BeanConverter.class.isAssignableFrom(converter)) {
            StringBuilder properties = new StringBuilder();
            HashSet<Field> fields = new HashSet<Field>();
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            fields.addAll(Arrays.asList(clazz.getFields()));
            for (Field field : fields) {
                if (field.getAnnotation(RemoteProperty.class) == null) continue;
                properties.append(',').append(field.getName());
            }
            for (Method method : clazz.getMethods()) {
                String name;
                if (method.getAnnotation(RemoteProperty.class) == null || !(name = method.getName()).startsWith(METHOD_PREFIX_GET) && !name.startsWith(METHOD_PREFIX_IS)) continue;
                name = name.startsWith(METHOD_PREFIX_GET) ? name.substring(3) : name.substring(2);
                name = Introspector.decapitalize(name);
                properties.append(',').append(name);
            }
            if (properties.length() > 0) {
                properties.deleteCharAt(0);
                params.put("include", properties.toString());
            }
        }
        converterManager.addConverter(clazz.getName(), converterName, params);
    }

    protected void processGlobalFilter(Class<?> clazz, GlobalFilter globalFilterAnn, Container container) throws InstantiationException, IllegalAccessException {
        if (!AjaxFilter.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not an AjaxFilter implementation");
        }
        Map<String, String> filterParams = this.getParamsMap(globalFilterAnn.params());
        AjaxFilter filter = (AjaxFilter)clazz.newInstance();
        if (filter != null) {
            LocalUtil.setParams(filter, filterParams, null);
            AjaxFilterManager filterManager = container.getBean(AjaxFilterManager.class);
            filterManager.addAjaxFilter(filter);
        }
    }

    protected Map<String, String> getParamsMap(Param[] params) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (params != null) {
            for (Param param : params) {
                result.put(param.name(), param.value());
            }
        }
        return result;
    }
}

