/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.util.Continuation;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;

public class DefaultRemoter
implements Remoter {
    private AjaxFilterManager ajaxFilterManager = null;
    protected CreatorManager creatorManager = null;
    protected ConverterManager converterManager = null;
    protected AccessControl accessControl = null;
    private String overridePath = null;
    private boolean allowImpossibleTests = false;
    private int maxCallCount = 20;
    private Map methodCache = Collections.synchronizedMap(new HashMap());
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultRemoter == null ? (class$org$directwebremoting$impl$DefaultRemoter = DefaultRemoter.class$("org.directwebremoting.impl.DefaultRemoter")) : class$org$directwebremoting$impl$DefaultRemoter);
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultRemoter;

    public String generateInterfaceScript(String scriptName, String path) throws SecurityException {
        String actualPath = path;
        if (this.overridePath != null) {
            actualPath = this.overridePath;
        }
        StringBuffer buffer = new StringBuffer();
        Collection converterMatches = this.converterManager.getConverterMatchStrings();
        Iterator it = converterMatches.iterator();
        while (it.hasNext()) {
            String match = (String)it.next();
            try {
                NamedConverter boConv;
                String jsClassName;
                StringBuffer paramBuffer = new StringBuffer();
                Converter conv = this.converterManager.getConverterByMatchString(match);
                if (conv instanceof NamedConverter && (jsClassName = (boConv = (NamedConverter)conv).getJavascript()) != null && !jsClassName.equals("") && match.indexOf("*") == -1) {
                    Class mappedType;
                    paramBuffer.append('\n');
                    paramBuffer.append("if (typeof " + jsClassName + " != \"function\") {\n");
                    paramBuffer.append("  function " + jsClassName + "() {\n");
                    try {
                        mappedType = LocalUtil.classForName(match);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IllegalArgumentException(ex.getMessage());
                    }
                    Map properties = boConv.getPropertyMapFromClass(mappedType, true, true);
                    Iterator pit = properties.entrySet().iterator();
                    while (pit.hasNext()) {
                        Map.Entry entry = pit.next();
                        String name = (String)entry.getKey();
                        Property property = (Property)entry.getValue();
                        Class propType = property.getPropertyType();
                        paramBuffer.append("    this." + name + " = ");
                        if (propType.isArray()) {
                            paramBuffer.append("[]");
                        } else if (propType == Boolean.TYPE) {
                            paramBuffer.append("false");
                        } else if (propType.isPrimitive()) {
                            paramBuffer.append("0");
                        } else {
                            paramBuffer.append("null");
                        }
                        paramBuffer.append(";\n");
                    }
                    paramBuffer.append("  }\n");
                    paramBuffer.append("}\n");
                }
                buffer.append(paramBuffer.toString());
            }
            catch (Exception ex) {
                log.warn("Failed to create parameter declaration for " + match, ex);
                buffer.append("// Missing parameter declaration for " + match + ". See the server logs for details.");
            }
        }
        Creator creator = this.creatorManager.getCreator(scriptName);
        buffer.append('\n');
        String init = EnginePrivate.getEngineInitScript();
        buffer.append(init);
        buffer.append("if (" + scriptName + " == null) var " + scriptName + " = {};\n");
        buffer.append(scriptName + "._path = '" + actualPath + "';\n");
        Method[] methods = creator.getType().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String script;
            Method method = methods[i];
            String methodName = method.getName();
            try {
                this.accessControl.assertIsDisplayable(creator, scriptName, method);
            }
            catch (SecurityException ex) {
                if (!this.allowImpossibleTests) continue;
            }
            if (JavascriptUtil.isReservedWord(methodName)) continue;
            if (!creator.isCacheable()) {
                script = this.getMethodJS(scriptName, method);
            } else {
                String key = scriptName + "." + method.getName();
                script = (String)this.methodCache.get(key);
                if (script == null) {
                    script = this.getMethodJS(scriptName, method);
                    this.methodCache.put(key, script);
                }
            }
            buffer.append(script);
        }
        return buffer.toString();
    }

    private String getMethodJS(String scriptName, Method method) {
        StringBuffer buffer = new StringBuffer();
        String methodName = method.getName();
        buffer.append(scriptName + '.' + methodName + " = function(");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int j = 0; j < paramTypes.length; ++j) {
            if (LocalUtil.isServletClass(paramTypes[j])) continue;
            buffer.append("p" + j + ", ");
        }
        buffer.append("callback) {\n");
        String executeFunctionName = EnginePrivate.getExecuteFunctionName();
        buffer.append("  " + executeFunctionName + "(" + scriptName + "._path, '" + scriptName + "', '" + methodName + "', ");
        for (int j = 0; j < paramTypes.length; ++j) {
            if (LocalUtil.isServletClass(paramTypes[j])) {
                buffer.append("false, ");
                continue;
            }
            buffer.append("p" + j + ", ");
        }
        buffer.append("callback);\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public Replies execute(Calls calls) {
        Replies replies = new Replies(calls.getBatchId());
        int callCount = calls.getCallCount();
        if (callCount > this.maxCallCount) {
            log.error("Call count for batch exceeds maxCallCount. Add an init-param of maxCallCount to increase this limit");
            throw new SecurityException("Call count for batch is too high");
        }
        for (int callNum = 0; callNum < callCount; ++callNum) {
            Call call = calls.getCall(callNum);
            Reply reply = this.execute(call);
            replies.addReply(reply);
        }
        return replies;
    }

    public Reply execute(Call call) {
        try {
            Method method = call.getMethod();
            if (method == null || call.getException() != null) {
                return new Reply(call.getCallId(), null, call.getException());
            }
            Creator creator = this.creatorManager.getCreator(call.getScriptName());
            this.accessControl.assertExecutionIsPossible(creator, call.getScriptName(), method);
            Object object = null;
            String scope = creator.getScope();
            boolean create = false;
            if (!Modifier.isStatic(method.getModifiers())) {
                WebContext webcx = WebContextFactory.get();
                if (scope.equals("application")) {
                    object = webcx.getServletContext().getAttribute(call.getScriptName());
                } else if (scope.equals("session")) {
                    object = webcx.getSession().getAttribute(call.getScriptName());
                } else if (scope.equals("script")) {
                    object = webcx.getScriptSession().getAttribute(call.getScriptName());
                } else if (scope.equals("request")) {
                    object = webcx.getHttpServletRequest().getAttribute(call.getScriptName());
                }
                if (object == null) {
                    create = true;
                    object = creator.getInstance();
                }
                if (create) {
                    if (scope.equals("application")) {
                        webcx.getServletContext().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("session")) {
                        webcx.getSession().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("script")) {
                        webcx.getScriptSession().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("request")) {
                        webcx.getHttpServletRequest().setAttribute(call.getScriptName(), object);
                    }
                }
            }
            log.info("Exec: " + call.getScriptName() + "." + call.getMethodName() + "()");
            if (log.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                if (create) {
                    buffer.append("--Object created, ");
                    if (!scope.equals("page")) {
                        buffer.append(" stored in ");
                        buffer.append(scope);
                    } else {
                        buffer.append(" not stored");
                    }
                } else {
                    buffer.append("--Object found in ");
                    buffer.append(scope);
                }
                buffer.append(". ");
                buffer.append("id=");
                buffer.append(call.getCallId());
                log.debug(buffer.toString());
            }
            final Iterator it = this.ajaxFilterManager.getAjaxFilters(call.getScriptName());
            AjaxFilterChain chain = new AjaxFilterChain(){

                public Object doFilter(Object obj, Method meth, Object[] p) throws Exception {
                    AjaxFilter next = (AjaxFilter)it.next();
                    return next.doFilter(obj, meth, p, this);
                }
            };
            Object reply = chain.doFilter(object, method, call.getParameters());
            return new Reply(call.getCallId(), reply);
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowIfContinuation(ex);
            log.warn("Method execution failed: ", ex.getTargetException());
            return new Reply(call.getCallId(), null, ex.getTargetException());
        }
        catch (Exception ex) {
            Continuation.rethrowIfContinuation(ex);
            log.warn("Method execution failed: ", ex);
            return new Reply(call.getCallId(), null, ex);
        }
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setAjaxFilterManager(AjaxFilterManager ajaxFilterManager) {
        this.ajaxFilterManager = ajaxFilterManager;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    public void setMaxCallCount(int maxCallCount) {
        this.maxCallCount = maxCallCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

