/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.directwebremoting.util.Logger;

public class IdGenerator {
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected String algorithm = "MD5";
    protected Random random = new SecureRandom();
    protected MessageDigest digest = null;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$util$IdGenerator == null ? (class$org$directwebremoting$util$IdGenerator = IdGenerator.class$("org.directwebremoting.util.IdGenerator")) : class$org$directwebremoting$util$IdGenerator);
    static /* synthetic */ Class class$org$directwebremoting$util$IdGenerator;

    public IdGenerator() {
        long seed = System.currentTimeMillis();
        char[] entropy = this.toString().toCharArray();
        for (int i = 0; i < entropy.length; ++i) {
            long update = (byte)entropy[i] << i % 8 * 8;
            seed ^= update;
        }
        this.random.setSeed(seed);
    }

    public synchronized String generateId(int length) {
        byte[] buffer = new byte[16];
        StringBuffer reply = new StringBuffer();
        int resultLenBytes = 0;
        while (resultLenBytes < length) {
            this.random.nextBytes(buffer);
            buffer = this.getDigest().digest(buffer);
            for (int j = 0; j < buffer.length && resultLenBytes < length; ++resultLenBytes, ++j) {
                byte b1 = (byte)((buffer[j] & 0xF0) >> 4);
                if (b1 < 10) {
                    reply.append((char)(48 + b1));
                } else {
                    reply.append((char)(65 + (b1 - 10)));
                }
                byte b2 = (byte)(buffer[j] & 0xF);
                if (b2 < 10) {
                    reply.append((char)(48 + b2));
                    continue;
                }
                reply.append((char)(65 + (b2 - 10)));
            }
        }
        return reply.toString();
    }

    public synchronized String getAlgorithm() {
        return this.algorithm;
    }

    public synchronized void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        this.digest = null;
    }

    private MessageDigest getDigest() {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException ex) {
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException ex2) {
                    this.digest = null;
                    throw new IllegalStateException("No algorithms for IdGenerator");
                }
            }
            log.debug("Using MessageDigest: " + this.digest.getAlgorithm());
        }
        return this.digest;
    }

    public String toString() {
        return super.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

