/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.core.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.common.util.ND4JFileUtils;
import org.deeplearning4j.core.util.ModelGuesserException;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.KerasModelImport;
import org.deeplearning4j.util.ModelSerializer;
import org.nd4j.linalg.dataset.api.preprocessor.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGuesser {
    private static final Logger log = LoggerFactory.getLogger(ModelGuesser.class);

    public static Normalizer<?> loadNormalizer(InputStream is) throws IOException {
        return ModelSerializer.restoreNormalizerFromInputStream((InputStream)is);
    }

    public static Normalizer<?> loadNormalizer(String path) {
        try {
            return ModelSerializer.restoreNormalizerFromFile((File)new File(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object loadConfigGuess(String path) throws Exception {
        String input = FileUtils.readFileToString((File)new File(path));
        try {
            return MultiLayerConfiguration.fromJson((String)input);
        }
        catch (Exception e) {
            log.warn("Tried multi layer config from json", (Throwable)e);
            try {
                return KerasModelImport.importKerasModelConfiguration((String)path);
            }
            catch (Exception e1) {
                log.warn("Tried keras model config", (Throwable)e);
                try {
                    return KerasModelImport.importKerasSequentialConfiguration((String)path);
                }
                catch (Exception e2) {
                    log.warn("Tried keras sequence config", (Throwable)e);
                    try {
                        return ComputationGraphConfiguration.fromJson((String)input);
                    }
                    catch (Exception e3) {
                        log.warn("Tried computation graph from json");
                        try {
                            return MultiLayerConfiguration.fromYaml((String)input);
                        }
                        catch (Exception e4) {
                            log.warn("Tried multi layer configuration from yaml");
                            try {
                                return ComputationGraphConfiguration.fromYaml((String)input);
                            }
                            catch (Exception e5) {
                                throw new ModelGuesserException("Unable to load configuration from path " + path + " (invalid config file or not a known config type)");
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadConfigGuess(InputStream stream) throws Exception {
        String p = System.getProperty("org.deeplearning4j.tempdir");
        File tmp = ND4JFileUtils.createTempFile((String)("model-" + UUID.randomUUID().toString()), (String)"bin");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(tmp));
        IOUtils.copy((InputStream)stream, (OutputStream)bufferedOutputStream);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        tmp.deleteOnExit();
        try {
            Object object = ModelGuesser.loadConfigGuess(tmp.getAbsolutePath());
            return object;
        }
        finally {
            tmp.delete();
        }
    }

    public static Model loadModelGuess(String path) throws Exception {
        try {
            return ModelSerializer.restoreMultiLayerNetwork((File)new File(path), (boolean)true);
        }
        catch (Exception e) {
            log.warn("Tried multi layer network");
            try {
                return ModelSerializer.restoreComputationGraph((File)new File(path), (boolean)true);
            }
            catch (Exception e1) {
                log.warn("Tried computation graph");
                try {
                    return ModelSerializer.restoreMultiLayerNetwork((File)new File(path), (boolean)false);
                }
                catch (Exception e4) {
                    try {
                        return ModelSerializer.restoreComputationGraph((File)new File(path), (boolean)false);
                    }
                    catch (Exception e5) {
                        try {
                            return KerasModelImport.importKerasModelAndWeights((String)path);
                        }
                        catch (Exception e2) {
                            log.warn("Tried multi layer network keras");
                            try {
                                return KerasModelImport.importKerasSequentialModelAndWeights((String)path);
                            }
                            catch (Exception e3) {
                                throw new ModelGuesserException("Unable to load model from path " + path + " (invalid model file or not a known model type)");
                            }
                        }
                    }
                }
            }
        }
    }

    public static Model loadModelGuess(InputStream stream) throws Exception {
        return ModelGuesser.loadModelGuess(stream, null);
    }

    public static Model loadModelGuess(InputStream stream, File tempDirectory) throws Exception {
        File f = tempDirectory == null ? ND4JFileUtils.createTempFile((String)"loadModelGuess", (String)".bin") : File.createTempFile("loadModelGuess", ".bin", tempDirectory);
        f.deleteOnExit();
        try {
            Model model;
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            try {
                IOUtils.copy((InputStream)stream, (OutputStream)os);
                ((OutputStream)os).flush();
                model = ModelGuesser.loadModelGuess(f.getAbsolutePath());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ModelGuesserException e) {
                    throw new ModelGuesserException("Unable to load model from input stream (invalid model file not a known model type)");
                }
            }
            ((OutputStream)os).close();
            return model;
        }
        finally {
            f.delete();
        }
    }
}

