/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.unittest;

import java.util.concurrent.atomic.AtomicBoolean;
import org.debux.webmotion.unittest.RequestBuilder;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;

public abstract class WebMotionTest {
    static AtomicBoolean isStarted = new AtomicBoolean(false);
    protected Server server;

    protected void startServer() throws Exception {
        this.server = new Server();
        int port = this.getPort();
        String contextPath = this.getContextPath();
        String war = this.getWar();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath(contextPath);
        webAppContext.setWar(war);
        this.server.setHandler((Handler)webAppContext);
        this.server.start();
    }

    protected void stopServer() throws Exception {
        this.server.stop();
    }

    public void runServer() throws Exception {
        boolean value = isStarted.getAndSet(true);
        if (!value) {
            this.startServer();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        WebMotionTest.this.stopServer();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    finally {
                        isStarted.set(false);
                    }
                }
            });
        }
    }

    protected int getPort() {
        return 9999;
    }

    protected String getContextPath() {
        return "/";
    }

    protected String getWar() {
        return "src/main/webapp";
    }

    public RequestBuilder createRequest(String url) {
        String contextPath = this.getContextPath();
        String path = contextPath.endsWith("/") && url.startsWith("/") ? this.getContextPath() + url.substring(1) : (contextPath.endsWith("/") ^ url.startsWith("/") ? this.getContextPath() + url : this.getContextPath() + "/" + url);
        RequestBuilder builder = new RequestBuilder().setScheme("http").setHost("localhost").setPort(this.getPort()).setPath(path);
        return builder;
    }
}

