/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.AggregateExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class QueryStatement
implements QueryExpression {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    protected final MappedStoreManager storeMgr;
    private final ClassLoaderResolver clr;
    protected Class candidateClass = null;
    protected String candidateAlias = "this";
    protected final DatastoreIdentifier mainTableAlias;
    protected final LogicSetExpression mainTableExpr;
    protected Map<DatastoreIdentifier, LogicSetExpression> tableExprsByAlias = new HashMap<DatastoreIdentifier, LogicSetExpression>();
    private QueryExpression parentQueryExpr;
    protected List<QueryStatement> union = new ArrayList<QueryStatement>();
    protected boolean isExistsSubQuery = false;
    protected boolean distinctResults = false;
    protected List<String> selected = new ArrayList<String>();
    protected boolean hasAggregateExpression = false;
    protected List<Join> joins = new ArrayList<Join>();
    protected List<DatastoreIdentifier> joinsToTableAliases = new ArrayList<DatastoreIdentifier>();
    protected List<LogicSetExpression> crossJoins = new ArrayList<LogicSetExpression>();
    protected BooleanExpression whereExpr = null;
    protected List<ScalarExpression> groupingExpressions = null;
    protected BooleanExpression havingExpr = null;
    protected ScalarExpression[] orderingExpressions = null;
    protected boolean[] orderingDirections = null;
    protected ScalarExpression[] updateExprs = null;
    protected long rangeOffset = -1L;
    protected long rangeCount = -1L;
    protected HashMap<String, Object> extensions;
    protected StatementText stmtText = null;
    private int[] orderingColumnIndexes;

    public QueryStatement(DatastoreContainerObject mainTable, DatastoreIdentifier alias, ClassLoaderResolver clr) {
        this.storeMgr = mainTable.getStoreManager();
        this.clr = clr;
        this.mainTableAlias = alias == null ? this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "this") : alias;
        this.mainTableExpr = this.newTableExpression(mainTable, this.mainTableAlias);
        this.tableExprsByAlias.put(this.mainTableAlias, this.mainTableExpr);
    }

    public void setCandidateInformation(Class cls, String alias) {
        this.candidateClass = cls;
        this.candidateAlias = alias;
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public String getCandidateAlias() {
        return this.candidateAlias;
    }

    public void reset() {
        if (this.stmtText == null) {
            return;
        }
        this.stmtText = null;
        for (int i = 0; i < this.union.size(); ++i) {
            this.union.get(i).reset();
        }
    }

    public void setParent(QueryExpression parentQueryExpr) {
        HashMap parentExts;
        this.parentQueryExpr = parentQueryExpr;
        if (parentQueryExpr != null && (parentExts = parentQueryExpr.getExtensions()) != null) {
            Set entries = parentExts.entrySet();
            for (Map.Entry entry : entries) {
                this.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public QueryExpression getParent() {
        return this.parentQueryExpr;
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    public MappedStoreManager getStoreManager() {
        return this.storeMgr;
    }

    public void setDistinctResults(boolean distinctResults) {
        this.assertNotFrozen();
        this.distinctResults = distinctResults;
    }

    public void setExistsSubQuery(boolean isExistsSubQuery) {
        this.isExistsSubQuery = isExistsSubQuery;
        if (isExistsSubQuery && !((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsOption("Exists_Syntax")) {
            throw new NucleusException(LOCALISER.msg("052504", (Object)"EXISTS")).setFatal();
        }
    }

    public void union(QueryExpression expr) {
        this.assertNotFrozen();
        this.union.add((QueryStatement)expr);
    }

    public void addExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap();
        }
        this.extensions.put(key, value);
    }

    public Object getValueForExtension(String key) {
        if (this.extensions == null) {
            return this.extensions;
        }
        return this.extensions.get(key);
    }

    public HashMap getExtensions() {
        return this.extensions;
    }

    public synchronized int[] selectDatastoreIdentity(String alias, boolean unionQueries) {
        int[] index = this.selectDatastoreIdentity(alias);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = this.union.get(i);
                qs.selectDatastoreIdentity(alias, unionQueries);
            }
        }
        return index;
    }

    private synchronized int[] selectDatastoreIdentity(String alias) {
        if (!(this.mainTableExpr.getMainTable() instanceof DatastoreClass)) {
            return null;
        }
        DatastoreClass mainTable = (DatastoreClass)this.mainTableExpr.getMainTable();
        if (mainTable.getDatastoreObjectIdMapping() == null) {
            return null;
        }
        return this.select(this.mainTableAlias, mainTable.getDatastoreObjectIdMapping(), alias);
    }

    public synchronized int[] selectVersion(String alias, boolean unionQueries) {
        int[] index = this.selectVersion(alias);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = this.union.get(i);
                qs.selectVersion(alias, unionQueries);
            }
        }
        return index;
    }

    private synchronized int[] selectVersion(String alias) {
        if (!(this.mainTableExpr.getMainTable() instanceof DatastoreClass)) {
            return null;
        }
        DatastoreClass mainTable = (DatastoreClass)this.mainTableExpr.getMainTable();
        if (mainTable.getVersionMapping(false) == null) {
            return null;
        }
        return this.select(this.mainTableAlias, mainTable.getVersionMapping(false), alias);
    }

    public synchronized int[] selectField(String fieldName, String alias, boolean unionQueries) {
        int[] index = this.selectField(fieldName, alias);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = this.union.get(i);
                qs.selectField(fieldName, alias, unionQueries);
            }
        }
        return index;
    }

    private synchronized int[] selectField(String fieldName, String alias) {
        if (!(this.mainTableExpr.getMainTable() instanceof DatastoreClass)) {
            return null;
        }
        DatastoreClass mainTable = (DatastoreClass)this.mainTableExpr.getMainTable();
        JavaTypeMapping fieldMapping = mainTable.getMemberMapping(fieldName);
        if (fieldMapping == null) {
            return null;
        }
        return this.select(this.mainTableAlias, fieldMapping, alias);
    }

    public synchronized int[] select(JavaTypeMapping mapping) {
        int[] index = new int[mapping.getNumberOfDatastoreMappings()];
        for (int i = 0; i < index.length; ++i) {
            FieldQueryExpression qe = this.getQueryExpression(this.mainTableAlias, mapping.getDatastoreMapping(i).getDatastoreField(), null);
            index[i] = this.selectQueryExpression(qe);
        }
        return index;
    }

    public synchronized int[] select(JavaTypeMapping mapping, boolean unionQueries) {
        int[] index = this.select(mapping);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = this.union.get(i);
                qs.select(mapping, unionQueries);
            }
        }
        return index;
    }

    public synchronized int[] select(DatastoreIdentifier tableAlias, JavaTypeMapping mapping) {
        return this.select(tableAlias, mapping, null);
    }

    private synchronized int[] select(DatastoreIdentifier tableAlias, JavaTypeMapping mapping, String columnAlias) {
        this.assertNotFrozen();
        int[] index = new int[mapping.getNumberOfDatastoreMappings()];
        for (int i = 0; i < index.length; ++i) {
            String colAlias = columnAlias;
            if (colAlias != null && index.length > 1) {
                colAlias = colAlias + "_" + i;
            }
            index[i] = this.selectQueryExpression(this.getQueryExpression(tableAlias, mapping.getDatastoreMapping(i).getDatastoreField(), colAlias));
        }
        return index;
    }

    public synchronized int[] select(DatastoreIdentifier tableAlias, JavaTypeMapping mapping, boolean unionQueries) {
        int[] index = this.select(tableAlias, mapping);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = this.union.get(i);
                qs.select(tableAlias, mapping, null);
            }
        }
        return index;
    }

    public int selectScalarExpression(ScalarExpression expr) {
        this.assertNotFrozen();
        if (expr instanceof AggregateExpression) {
            this.hasAggregateExpression = true;
        }
        String exprStr = expr.toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION);
        return this.selectItem(exprStr);
    }

    public int selectScalarExpression(ScalarExpression expr, boolean unionQueries) {
        this.assertNotFrozen();
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = this.union.get(i);
                qs.selectScalarExpression(expr);
            }
        }
        return this.selectScalarExpression(expr);
    }

    private synchronized int selectQueryExpression(FieldQueryExpression queryExpr) {
        this.assertNotFrozen();
        String exprStr = queryExpr.toString();
        return this.selectItem(exprStr);
    }

    private int selectItem(String item) {
        if (this.selected.contains(item)) {
            return this.selected.indexOf(item) + 1;
        }
        int numberSelected = this.selected.size();
        for (int i = 0; i < numberSelected; ++i) {
            String selectedItem = this.selected.get(i);
            if (selectedItem.startsWith(item + " ")) {
                return i + 1;
            }
            if (!item.startsWith(selectedItem + " ")) continue;
            this.selected.set(i, item);
            return i + 1;
        }
        this.selected.add(this.selected.size(), item);
        return this.selected.indexOf(item) + 1;
    }

    public int getNumberOfScalarExpressions() {
        return this.selected.size();
    }

    public boolean hasNucleusTypeExpression() {
        for (int i = 0; i < this.selected.size(); ++i) {
            if (!this.selected.get(i).toString().endsWith("NUCLEUS_TYPE")) continue;
            return true;
        }
        return false;
    }

    private FieldQueryExpression getQueryExpression(DatastoreIdentifier alias, DatastoreField col, String colAlias) {
        LogicSetExpression te = this.getTableExpression(alias);
        if (te == null) {
            throw new NucleusException(LOCALISER.msg("052501", (Object)alias)).setFatal();
        }
        return this.getQueryExpression(te, col, colAlias);
    }

    private FieldQueryExpression getQueryExpression(LogicSetExpression te, DatastoreField field, String alias) {
        return new FieldQueryExpression(te, field, alias);
    }

    public LogicSetExpression getMainTableExpression() {
        return this.mainTableExpr;
    }

    public DatastoreIdentifier getMainTableAlias() {
        return this.mainTableAlias;
    }

    public LogicSetExpression getTableExpression(DatastoreIdentifier alias) {
        return this.tableExprsByAlias.get(alias);
    }

    public LogicSetExpression newTableExpression(DatastoreContainerObject table, DatastoreIdentifier alias) {
        this.assertNotFrozen();
        LogicSetExpression te = this.tableExprsByAlias.get(alias);
        if (te == null) {
            te = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).newTableExpression(this, table, alias);
            this.tableExprsByAlias.put(alias, te);
        } else if (!te.getMainTable().equals(table)) {
            throw new NucleusException(LOCALISER.msg("052500", (Object)alias, (Object)this.toStatementText(false))).setFatal();
        }
        return te;
    }

    public LogicSetExpression[] newTableExpression(DatastoreContainerObject table, DatastoreIdentifier alias, boolean unionQueries) {
        LogicSetExpression[] expr = unionQueries ? new LogicSetExpression[this.union.size() + 1] : new LogicSetExpression[1];
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = this.union.get(i);
                expr[i + 1] = qs.newTableExpression(table, alias);
            }
        }
        expr[0] = this.newTableExpression(table, alias);
        return expr;
    }

    private synchronized void join(ScalarExpression expr1, ScalarExpression expr2, LogicSetExpression tblExpr, int joinType, boolean equals, boolean unionQueries) {
        if (unionQueries) {
            Iterator<QueryStatement> i = this.union.iterator();
            while (i.hasNext()) {
                i.next().join(expr1, expr2, tblExpr, joinType, equals, unionQueries);
            }
        }
        this.join(expr1, expr2, tblExpr, joinType, equals);
    }

    private void join(ScalarExpression expr1, ScalarExpression expr2, LogicSetExpression tblExpr, int joinType, boolean equals) {
        String value;
        this.assertNotFrozen();
        if (this.extensions != null && (value = (String)this.extensions.get("datanucleus.rdbms.jdoql.joinType")) != null) {
            joinType = value.equals("INNER") ? 1 : 2;
        }
        Join join = new Join(joinType, expr1, expr2, tblExpr);
        if (joinType == 1) {
            if (tblExpr.equals((Object)this.getMainTableExpression())) {
                if (equals) {
                    this.andCondition(expr1.eq(expr2));
                } else {
                    this.andCondition(expr1.noteq(expr2));
                }
                return;
            }
            if (this.crossJoins.contains(tblExpr)) {
                if (equals) {
                    this.andCondition(expr1.eq(expr2));
                } else {
                    this.andCondition(expr1.noteq(expr2));
                }
                return;
            }
        }
        if (this.crossJoins.contains(tblExpr)) {
            if (equals) {
                this.andCondition(expr1.eq(expr2));
            } else {
                this.andCondition(expr1.noteq(expr2));
            }
            return;
        }
        if (this.mainTableExpr.equals((Object)tblExpr)) {
            if (equals) {
                this.andCondition(expr1.eq(expr2));
            } else {
                this.andCondition(expr1.noteq(expr2));
            }
            return;
        }
        if (this.joinsToTableAliases.contains(tblExpr.getAlias())) {
            return;
        }
        this.joinsToTableAliases.add(tblExpr.getAlias());
        this.joins.add(join);
    }

    public synchronized void innerJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals, boolean unionQueries) {
        if (this.storeMgr.getDatastoreAdapter().supportsOption("ANSI_Join_Syntax")) {
            this.join(expr, expr2, tblExpr, 1, equals, unionQueries);
        } else {
            this.innerJoinNonAnsi(expr, expr2, tblExpr, unionQueries);
        }
    }

    public void innerJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals) {
        if (this.storeMgr.getDatastoreAdapter().supportsOption("ANSI_Join_Syntax")) {
            this.join(expr, expr2, tblExpr, 1, equals);
        } else {
            this.innerJoinNonAnsi(expr, expr2, tblExpr, false);
        }
    }

    private void innerJoinNonAnsi(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean unions) {
        this.assertNotFrozen();
        if (tblExpr.equals((Object)this.getMainTableExpression())) {
            this.andCondition(expr.eq(expr2));
            return;
        }
        if (this.crossJoins.contains(tblExpr)) {
            this.crossJoins.remove(tblExpr);
        }
        if (this.joinsToTableAliases.contains(tblExpr.getAlias())) {
            return;
        }
        this.joinsToTableAliases.add(tblExpr.getAlias());
        this.joins.add(new Join(expr, expr2, tblExpr));
        this.andCondition(expr.eq(expr2));
        if (unions) {
            Iterator<QueryStatement> i = this.union.iterator();
            while (i.hasNext()) {
                i.next().innerJoinNonAnsi(expr, expr2, tblExpr, false);
            }
        }
    }

    public synchronized void leftOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals, boolean unionQueries) {
        if (this.storeMgr.getDatastoreAdapter().supportsOption("ANSI_Join_Syntax")) {
            this.join(expr, expr2, tblExpr, 2, equals, unionQueries);
        } else {
            this.leftOuterJoinNonAnsi(expr, expr2, tblExpr, unionQueries);
        }
    }

    public void leftOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals) {
        if (this.storeMgr.getDatastoreAdapter().supportsOption("ANSI_Join_Syntax")) {
            this.join(expr, expr2, tblExpr, 2, equals);
        } else {
            this.leftOuterJoinNonAnsi(expr, expr2, tblExpr, false);
        }
    }

    private void leftOuterJoinNonAnsi(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean unions) {
        this.assertNotFrozen();
        if (this.joinsToTableAliases.contains(tblExpr.getAlias())) {
            return;
        }
        this.joinsToTableAliases.add(tblExpr.getAlias());
        this.joins.add(new Join(expr, expr2, tblExpr));
        if (expr2 instanceof ObjectExpression) {
            ((ObjectExpression)expr2).addOuterJoinSuffix("(+)");
        }
        this.andCondition(expr.eq(expr2));
        if (unions) {
            Iterator<QueryStatement> i = this.union.iterator();
            while (i.hasNext()) {
                i.next().leftOuterJoinNonAnsi(expr, expr2, tblExpr, false);
            }
        }
    }

    public synchronized void rightOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals, boolean unionQueries) {
        if (this.storeMgr.getDatastoreAdapter().supportsOption("ANSI_Join_Syntax")) {
            this.join(expr, expr2, tblExpr, 3, equals, unionQueries);
        } else {
            this.rightOuterJoinNonAnsi(expr, expr2, tblExpr, unionQueries);
        }
    }

    public void rightOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals) {
        if (this.storeMgr.getDatastoreAdapter().supportsOption("ANSI_Join_Syntax")) {
            this.join(expr, expr2, tblExpr, 3, equals);
        } else {
            this.rightOuterJoinNonAnsi(expr, expr2, tblExpr, false);
        }
    }

    private void rightOuterJoinNonAnsi(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean unions) {
        this.assertNotFrozen();
        if (this.joinsToTableAliases.contains(tblExpr.getAlias())) {
            return;
        }
        this.joinsToTableAliases.add(tblExpr.getAlias());
        this.joins.add(new Join(expr, expr2, tblExpr));
        if (expr instanceof ObjectExpression) {
            ((ObjectExpression)expr).addOuterJoinSuffix("(+)");
        }
        this.andCondition(expr.eq(expr2));
        if (unions) {
            Iterator<QueryStatement> i = this.union.iterator();
            while (i.hasNext()) {
                i.next().rightOuterJoinNonAnsi(expr, expr2, tblExpr, false);
            }
        }
    }

    public boolean hasCrossJoin(LogicSetExpression tableExpr) {
        if (this.crossJoins.contains(tableExpr)) {
            return true;
        }
        for (int i = 0; i < this.joins.size(); ++i) {
            if (!this.joins.get(i).tblExpr.equals((Object)tableExpr)) continue;
            return true;
        }
        if (this.parentQueryExpr != null) {
            return this.parentQueryExpr.hasCrossJoin(tableExpr);
        }
        return false;
    }

    public void crossJoin(LogicSetExpression tableExpr, boolean unionQueries) {
        if (unionQueries) {
            Iterator<QueryStatement> i = this.union.iterator();
            while (i.hasNext()) {
                i.next().crossJoin(tableExpr);
            }
        }
        this.crossJoin(tableExpr);
    }

    private void crossJoin(LogicSetExpression tableExpr) {
        this.assertNotFrozen();
        if (this.hasCrossJoin(tableExpr) || this.mainTableExpr.equals((Object)tableExpr)) {
            return;
        }
        this.crossJoins.add(tableExpr);
    }

    private List sortJoins(List toSort) {
        List temp = this.internalSortJoins(toSort);
        return this.internalSortJoins(temp);
    }

    private List internalSortJoins(List toSort) {
        List temp = toSort;
        for (int i = 0; i < temp.size(); ++i) {
            Join join0 = (Join)temp.get(i);
            int index = i;
            boolean changed = false;
            DatastoreIdentifier joinExpr1TableAlias = join0.expr1.getLogicSetExpression().getAlias();
            if (!this.getMainTableExpression().getAlias().equals(joinExpr1TableAlias)) {
                for (int j = 0; j < temp.size(); ++j) {
                    Join join1 = (Join)temp.get(j);
                    if (join1 == join0 || !join1.tblExpr.getAlias().equals(joinExpr1TableAlias) || changed) continue;
                    index = j;
                    changed = true;
                }
            }
            DatastoreIdentifier joinExpr2TableAlias = join0.expr2.getLogicSetExpression().getAlias();
            if (!this.getMainTableExpression().getAlias().equals(joinExpr2TableAlias)) {
                for (int j = 0; j < temp.size(); ++j) {
                    Join join1 = (Join)temp.get(j);
                    if (join1 == join0 || !join1.tblExpr.getAlias().equals(joinExpr2TableAlias) || changed && index >= j) continue;
                    index = j;
                    changed = true;
                }
            }
            if (index == i) continue;
            temp.remove(i);
            temp.add(i < index ? index : index + 1, join0);
        }
        return temp;
    }

    public void andCondition(BooleanExpression condition, boolean unionQueries) {
        this.assertNotFrozen();
        this.andCondition(condition);
        if (!unionQueries) {
            return;
        }
        Iterator<QueryStatement> i = this.union.iterator();
        while (i.hasNext()) {
            i.next().andCondition(condition);
        }
    }

    public void andCondition(BooleanExpression condition) {
        this.assertNotFrozen();
        if (condition instanceof BooleanLiteral) {
            if (((Boolean)((BooleanLiteral)condition).getValue()).booleanValue()) {
                return;
            }
            JavaTypeMapping m = this.storeMgr.getMappingManager().getMapping(Integer.class);
            condition = m.newLiteral((QueryExpression)this, (Object)Integer.valueOf("1")).eq(m.newLiteral((QueryExpression)this, (Object)Integer.valueOf("0")));
        }
        this.whereExpr = this.whereExpr == null ? condition : this.whereExpr.and((ScalarExpression)condition);
    }

    public void iorCondition(BooleanExpression condition, boolean unionQueries) {
        this.assertNotFrozen();
        this.iorCondition(condition);
        if (!unionQueries) {
            return;
        }
        Iterator<QueryStatement> i = this.union.iterator();
        while (i.hasNext()) {
            i.next().iorCondition(condition);
        }
    }

    public void iorCondition(BooleanExpression condition) {
        this.assertNotFrozen();
        if (condition instanceof BooleanLiteral) {
            if (condition.toStatementText(ScalarExpression.FILTER).toStatementString(ScalarExpression.FILTER).equals("TRUE")) {
                return;
            }
            JavaTypeMapping m = this.storeMgr.getMappingManager().getMapping(Integer.class);
            condition = m.newLiteral((QueryExpression)this, (Object)Integer.valueOf("1")).eq(m.newLiteral((QueryExpression)this, (Object)Integer.valueOf("0")));
        }
        this.whereExpr = this.whereExpr == null ? condition : this.whereExpr.ior((ScalarExpression)condition);
    }

    public void addGroupingExpression(ScalarExpression expr) {
        if (this.groupingExpressions == null) {
            this.groupingExpressions = new ArrayList<ScalarExpression>();
        }
        this.groupingExpressions.add(expr);
        this.hasAggregateExpression = true;
        Iterator<QueryStatement> i = this.union.iterator();
        while (i.hasNext()) {
            i.next().addGroupingExpression(expr);
        }
    }

    public void setHaving(BooleanExpression expr) {
        this.havingExpr = expr;
        this.hasAggregateExpression = true;
    }

    public void setOrdering(ScalarExpression[] exprs, boolean[] descending) {
        this.assertNotFrozen();
        if (exprs.length != descending.length) {
            throw new NucleusException(LOCALISER.msg("052503", (Object)("" + exprs.length), (Object)("" + descending.length))).setFatal();
        }
        this.orderingExpressions = exprs;
        this.orderingDirections = descending;
    }

    public void setRangeConstraint(long offset, long count) {
        this.rangeOffset = offset;
        this.rangeCount = count;
    }

    protected void addOrderingColumnsToSelect() {
        block6: {
            RDBMSAdapter dba;
            block7: {
                if (this.orderingExpressions == null) break block6;
                dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
                if (!dba.supportsOption("OrderByUsingSelectColumnIndex")) break block7;
                this.orderingColumnIndexes = new int[this.orderingExpressions.length];
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    this.selected.add(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toString());
                    this.orderingColumnIndexes[i] = this.selected.size();
                    for (QueryStatement qs : this.union) {
                        qs.selectScalarExpression(this.orderingExpressions[i]);
                    }
                }
                break block6;
            }
            if (!dba.supportsOption("IncludeOrderByColumnsInSelect")) break block6;
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                String orderExpr = "NUCORDER" + i;
                for (QueryStatement qs : this.union) {
                    if (this.hasAggregateExpression) {
                        qs.selectScalarExpression(this.orderingExpressions[i]);
                        continue;
                    }
                    qs.selectScalarExpression(this.orderingExpressions[i].as(orderExpr));
                }
                if (this.hasAggregateExpression) {
                    this.selectScalarExpression(this.orderingExpressions[i]);
                    continue;
                }
                this.selectScalarExpression(this.orderingExpressions[i].as(orderExpr));
            }
        }
    }

    protected StatementText generateOrderingStatement() {
        StatementText orderByStmt = null;
        if (this.orderingExpressions != null && this.orderingExpressions.length > 0) {
            RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
            orderByStmt = new StatementText();
            if (dba.supportsOption("OrderByUsingSelectColumnIndex")) {
                orderByStmt = new StatementText();
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    if (i > 0) {
                        orderByStmt.append(',');
                    }
                    orderByStmt.append(Integer.toString(this.orderingColumnIndexes[i]));
                    if (!this.orderingDirections[i]) continue;
                    orderByStmt.append(" DESC");
                }
            } else {
                boolean needsSelect = dba.supportsOption("IncludeOrderByColumnsInSelect");
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    if (i > 0) {
                        orderByStmt.append(',');
                    }
                    String orderingString = null;
                    orderingString = needsSelect && !this.hasAggregateExpression ? "NUCORDER" + i : this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION);
                    orderByStmt.append(orderingString);
                    if (!this.orderingDirections[i]) continue;
                    orderByStmt.append(" DESC");
                }
            }
        }
        if (orderByStmt != null) {
            orderByStmt.append(" ");
        }
        return orderByStmt;
    }

    public void setUpdates(ScalarExpression[] exprs) {
        this.assertNotFrozen();
        this.updateExprs = exprs;
    }

    public StatementText toDeleteStatementText() {
        StatementText stmtText = new StatementText("DELETE FROM ");
        stmtText.append(this.mainTableExpr.toString());
        if (this.whereExpr != null) {
            stmtText.append(" WHERE ").append(this.whereExpr.toStatementText(ScalarExpression.FILTER), ScalarExpression.FILTER);
        }
        return stmtText;
    }

    public StatementText toUpdateStatementText() {
        StatementText stmtText = new StatementText("UPDATE ");
        stmtText.append(this.mainTableExpr.toString());
        stmtText.append(" SET ");
        if (this.updateExprs != null && this.updateExprs.length > 0) {
            for (int i = 0; i < this.updateExprs.length; ++i) {
                if (i != 0) {
                    stmtText.append(",");
                }
                stmtText.append(this.updateExprs[i].toStatementText(ScalarExpression.PROJECTION), ScalarExpression.PROJECTION);
            }
        }
        if (this.whereExpr != null) {
            stmtText.append(" WHERE ").append(this.whereExpr.toStatementText(ScalarExpression.FILTER), ScalarExpression.FILTER);
        }
        return stmtText;
    }

    public StatementText toStatementText(boolean lock) {
        if (this.stmtText == null) {
            int i;
            this.addOrderingColumnsToSelect();
            RDBMSAdapter rdba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
            StatementText stmtText = null;
            stmtText = new StatementText("SELECT ");
            if (this.rangeOffset > -1L || this.rangeCount > -1L) {
                if (rdba.getRangeByRowNumberColumn().length() > 0) {
                    stmtText.append(rdba.getRangeByRowNumberColumn() + " rn, ");
                } else {
                    stmtText.append(rdba.getRangeByLimitSelectClause(this.rangeOffset, this.rangeCount));
                }
            }
            boolean usingDistinct = false;
            if (!this.isExistsSubQuery) {
                if (this.distinctResults) {
                    stmtText.append("DISTINCT ");
                    usingDistinct = true;
                }
                Iterator<String> iterator = this.selected.iterator();
                while (iterator.hasNext()) {
                    String selectExpr = iterator.next();
                    stmtText.append(selectExpr);
                    if (!iterator.hasNext()) continue;
                    stmtText.append(',');
                }
                if ((this.rangeOffset > -1L || this.rangeCount > -1L) && rdba.getRangeByRowNumberColumn().length() > 0) {
                    stmtText.append(',').append(rdba.getRangeByRowNumberColumn());
                }
            } else {
                JavaTypeMapping m = this.storeMgr.getMappingManager().getMapping(Integer.class);
                stmtText.append(m.newLiteral((QueryExpression)this, (Object)Integer.valueOf("1")).toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION));
            }
            List sorted = this.sortJoins(this.joins);
            Join[] sortedJoins = sorted.toArray(new Join[sorted.size()]);
            stmtText.append(" FROM ");
            ArrayList<LogicSetExpression> crossJoinExprs = new ArrayList<LogicSetExpression>();
            crossJoinExprs.add(this.mainTableExpr);
            crossJoinExprs.addAll(this.crossJoins);
            if (crossJoinExprs.size() == 1) {
                stmtText.append(((LogicSetExpression)crossJoinExprs.get(0)).toString());
                if (lock && rdba.getSelectWithLockOption() != null && rdba.supportsOption("LockOptionAfterFromClause")) {
                    stmtText.append(" WITH " + rdba.getSelectWithLockOption());
                }
                crossJoinExprs.remove(0);
            }
            for (i = 0; i < sortedJoins.length; ++i) {
                Join join = sortedJoins[i];
                for (int j = crossJoinExprs.size() - 1; j >= 0; --j) {
                    if (!sortedJoins[i].expr1.getLogicSetExpression().equals(crossJoinExprs.get(j)) && !sortedJoins[i].expr2.getLogicSetExpression().equals(crossJoinExprs.get(j))) continue;
                    if (i > 0) {
                        stmtText.append(rdba.cartersianProduct((LogicSetExpression)crossJoinExprs.get(j)));
                    } else {
                        stmtText.append(((LogicSetExpression)crossJoinExprs.get(j)).toString());
                    }
                    if (lock && rdba.getSelectWithLockOption() != null && rdba.supportsOption("LockOptionAfterFromClause")) {
                        stmtText.append(" WITH " + rdba.getSelectWithLockOption());
                    }
                    crossJoinExprs.remove(j);
                    break;
                }
                if (rdba.supportsOption("ANSI_Join_Syntax")) {
                    stmtText.append(" ");
                } else {
                    stmtText.append(",");
                }
                stmtText.append(join.getFromClause(rdba, lock));
            }
            crossJoinExprs.remove(null);
            for (i = 0; i < crossJoinExprs.size(); ++i) {
                if (sortedJoins.length > 0 || i > 0) {
                    stmtText.append(rdba.cartersianProduct((LogicSetExpression)crossJoinExprs.get(i)));
                } else {
                    stmtText.append(((LogicSetExpression)crossJoinExprs.get(i)).toString());
                }
                if (!lock || rdba.getSelectWithLockOption() == null || !rdba.supportsOption("LockOptionAfterFromClause")) continue;
                stmtText.append(" WITH " + rdba.getSelectWithLockOption());
            }
            if (this.whereExpr != null) {
                stmtText.append(" WHERE ").append(this.whereExpr.toStatementText(ScalarExpression.FILTER), ScalarExpression.FILTER);
            }
            if (this.groupingExpressions != null) {
                ArrayList<String> groupBy = new ArrayList<String>();
                for (int i2 = 0; i2 < this.groupingExpressions.size(); ++i2) {
                    String exprText = this.groupingExpressions.get(i2).toStatementText(ScalarExpression.PROJECTION).toString();
                    if (groupBy.contains(exprText)) continue;
                    groupBy.add(exprText);
                }
                if (groupBy.size() > 0 && this.hasAggregateExpression) {
                    stmtText.append(" GROUP BY ");
                    boolean first = true;
                    for (int i3 = 0; i3 < groupBy.size(); ++i3) {
                        if (!first) {
                            stmtText.append(',');
                        }
                        stmtText.append((String)groupBy.get(i3));
                        first = false;
                    }
                }
            }
            if (this.havingExpr != null) {
                stmtText.append(" HAVING ").append(this.havingExpr.toStatementText(ScalarExpression.FILTER), ScalarExpression.FILTER);
            }
            Iterator<QueryStatement> iterator = this.union.iterator();
            while (iterator.hasNext()) {
                if (!rdba.supportsOption("Union_Syntax")) {
                    throw new NucleusException(LOCALISER.msg("052504", (Object)"UNION")).setFatal();
                }
                if (rdba.supportsOption("UseUnionAll")) {
                    stmtText.append(" UNION ALL ");
                } else {
                    stmtText.append(" UNION ");
                }
                stmtText.append(iterator.next().toStatementText(false), ScalarExpression.FILTER);
            }
            if (!this.isExistsSubQuery && this.orderingExpressions != null && this.orderingExpressions.length > 0) {
                StatementText orderByStmt = this.generateOrderingStatement();
                stmtText.append(" ORDER BY ").append(orderByStmt, ScalarExpression.PROJECTION);
            }
            if (this.rangeOffset > -1L || this.rangeCount > -1L) {
                stmtText.append(" ");
                stmtText.append(rdba.getRangeByLimitWhereClause(this.rangeOffset, this.rangeCount));
            }
            if (lock && rdba.supportsOption("LockWithSelectForUpdate")) {
                if (usingDistinct && !rdba.supportsOption("DistinctWithSelectForUpdate")) {
                    NucleusLogger.QUERY.warn((Object)LOCALISER.msg("052502"));
                } else {
                    stmtText.append(" FOR UPDATE");
                }
            }
            if ((this.rangeOffset > -1L || this.rangeCount > -1L) && rdba.getRangeByRowNumberColumn().length() > 0) {
                StatementText innerQuery = stmtText;
                stmtText = new StatementText("SELECT ");
                Iterator<String> selectIter = this.selected.iterator();
                while (selectIter.hasNext()) {
                    String selectExpr = selectIter.next();
                    stmtText.append("subq.");
                    String selectedCol = selectExpr;
                    int dotIndex = selectedCol.indexOf(".");
                    if (dotIndex != -1) {
                        selectedCol = selectedCol.substring(dotIndex + 1);
                    }
                    stmtText.append(selectedCol);
                    if (!selectIter.hasNext()) continue;
                    stmtText.append(',');
                }
                stmtText.append(" FROM (");
                stmtText.append(innerQuery, ScalarExpression.FILTER);
                stmtText.append(") subq");
                stmtText.append(" WHERE ");
                if (this.rangeOffset > -1L) {
                    stmtText.append("subq.rn").append(">=").append("" + this.rangeOffset);
                }
                if (this.rangeCount > -1L) {
                    if (this.rangeOffset > -1L) {
                        stmtText.append(" AND ");
                    }
                    stmtText.append("subq.rn").append("<").append("" + (this.rangeCount + this.rangeOffset));
                }
            }
            this.stmtText = stmtText;
        }
        return this.stmtText;
    }

    protected void assertNotFrozen() {
        if (this.stmtText != null) {
            throw new NucleusException("A query statement cannot be modified after being output").setFatal();
        }
    }

    public static class Join {
        public static final int INNER_JOIN = 1;
        public static final int LEFT_OUTER_JOIN = 2;
        public static final int RIGHT_OUTER_JOIN = 3;
        private final int type;
        private final LogicSetExpression tblExpr;
        private final ScalarExpression expr1;
        private final ScalarExpression expr2;

        public Join(int type, ScalarExpression expr1, ScalarExpression expr2, LogicSetExpression tblExpr) {
            this.type = type;
            this.expr1 = expr1;
            this.expr2 = expr2;
            this.tblExpr = tblExpr;
        }

        public Join(ScalarExpression expr1, ScalarExpression expr2, LogicSetExpression tblExpr) {
            this.type = -1;
            this.expr1 = expr1;
            this.expr2 = expr2;
            this.tblExpr = tblExpr;
        }

        public String getFromClause(RDBMSAdapter rdbmsAdapter, boolean lock) {
            if (this.type > 0) {
                StringBuffer result = new StringBuffer();
                if (this.type == 1) {
                    result.append("INNER JOIN ");
                } else if (this.type == 2) {
                    result.append("LEFT OUTER JOIN ");
                } else if (this.type == 3) {
                    result.append("RIGHT OUTER JOIN ");
                }
                result.append(this.tblExpr);
                if (lock && rdbmsAdapter.supportsOption("LockOptionWithinJoinClause")) {
                    result.append(" WITH ").append(rdbmsAdapter.getSelectWithLockOption());
                }
                return result.append(" ON " + this.expr1.eq(this.expr2).toStatementText(ScalarExpression.FILTER)).toString();
            }
            return "" + this.tblExpr;
        }
    }

    private class FieldQueryExpression {
        private final LogicSetExpression te;
        private final DatastoreField datastoreField;
        private final String toString;
        private final int hashCode;

        protected FieldQueryExpression(LogicSetExpression te, DatastoreField datastoreField, String alias) {
            this.te = te;
            this.datastoreField = datastoreField;
            this.toString = alias != null ? te.referenceColumn(datastoreField) + " AS " + alias : te.referenceColumn(datastoreField);
            this.hashCode = this.toString.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldQueryExpression)) {
                return false;
            }
            FieldQueryExpression qsc = (FieldQueryExpression)o;
            return this.te.equals((Object)qsc.te) && this.datastoreField.equals(qsc.datastoreField);
        }

        public String toString() {
            return this.toString;
        }
    }
}

