/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.ByteLiteral;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.CharacterLiteral;
import org.datanucleus.store.mapped.expression.FloatingPointLiteral;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.LikeExpression;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SqlTemporalExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.RegularExpressionConverter;

public class StringExpression
extends ScalarExpression {
    protected StringExpression(QueryExpression qs) {
        super(qs);
    }

    public StringExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public StringExpression(String functionName, List args) {
        super(functionName, args);
    }

    public StringExpression(String functionName, List args, List types) {
        super(functionName, args, types);
    }

    public StringExpression(ScalarExpression operand1, ScalarExpression.DyadicOperator op, ScalarExpression operand2) {
        super(operand1, op, operand2);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, StringExpression.class);
        expr = this.getConsistentTypeForParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_EQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_EQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_EQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, StringExpression.class);
        expr = this.getConsistentTypeForParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.noteq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_NOTEQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_NOTEQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_NOTEQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.lt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LT, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LT, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LT, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.lteq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LTEQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LTEQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LTEQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.gt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GT, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GT, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GT, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.gteq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GTEQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GTEQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GTEQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new StringExpression(this, OP_CONCAT, new StringLiteral(this.qs, expr.mapping, (String)((StringLiteral)expr).getValue()));
        }
        if (expr instanceof StringExpression) {
            return new StringExpression(this, OP_CONCAT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new StringExpression(this, OP_CONCAT, expr);
        }
        if (expr instanceof NumericExpression) {
            return new StringExpression(this, OP_CONCAT, this.qs.getStoreManager().getDatastoreAdapter().toStringExpression((NumericExpression)expr));
        }
        if (expr instanceof NullLiteral) {
            return expr;
        }
        return new StringExpression(this, OP_CONCAT, expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, OP_IN, expr);
    }

    public BooleanExpression equalsMethod(ScalarExpression expr) {
        return this.eq(expr);
    }

    public StringExpression charAtMethod(ScalarExpression index) {
        if (!(index instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(index);
        }
        NumericExpression begin = (NumericExpression)index;
        NumericExpression end = (NumericExpression)begin.add(new IntegerLiteral(this.qs, this.mapping, BigInteger.ONE));
        return this.substringMethod(begin, end);
    }

    public BooleanExpression endsWithMethod(ScalarExpression str) {
        if (!(str instanceof StringExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(str);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().endsWithMethod(this, str);
    }

    public NumericExpression indexOfMethod(ScalarExpression str) {
        if (!(str instanceof StringExpression) && !(str instanceof CharacterLiteral)) {
            throw new ScalarExpression.IllegalArgumentTypeException(str);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().indexOfMethod(this, str, null);
    }

    public NumericExpression indexOfMethod(ScalarExpression str, ScalarExpression fromIndex) {
        if (!(str instanceof StringExpression) && !(str instanceof CharacterLiteral)) {
            throw new ScalarExpression.IllegalArgumentTypeException(str);
        }
        if (!(fromIndex instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(fromIndex);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().indexOfMethod(this, str, (NumericExpression)fromIndex);
    }

    public NumericExpression lengthMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("length", this);
    }

    public BooleanExpression startsWithMethod(ScalarExpression str) {
        if (!(str instanceof StringExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(str);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().startsWithMethod(this, str);
    }

    public BooleanExpression startsWithMethod(ScalarExpression str, ScalarExpression toffset) {
        return this.substringMethod(toffset).startsWithMethod(str);
    }

    public StringExpression substringMethod(ScalarExpression begin) {
        if (!(begin instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(begin);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().substringMethod(this, (NumericExpression)begin);
    }

    public StringExpression substringMethod(ScalarExpression begin, ScalarExpression end) {
        if (!(begin instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(begin);
        }
        if (!(end instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(end);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().substringMethod(this, (NumericExpression)begin, (NumericExpression)end);
    }

    public StringExpression translateMethod(ScalarExpression toExpr, ScalarExpression fromExpr) {
        return this.qs.getStoreManager().getDatastoreAdapter().translateMethod(this, toExpr, fromExpr);
    }

    public StringExpression toLowerCaseMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().lowerMethod(this);
    }

    public StringExpression toUpperCaseMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().upperMethod(this);
    }

    public BooleanExpression matchesMethod(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            String pattern = (String)((Literal)((Object)expr)).getValue();
            boolean caseSensitive = false;
            if (pattern.startsWith("(?i)")) {
                caseSensitive = true;
                pattern = pattern.substring(4);
            }
            DatastoreAdapter dba = this.qs.getStoreManager().getDatastoreAdapter();
            RegularExpressionConverter converter = new RegularExpressionConverter(dba.getPatternExpressionZeroMoreCharacters().charAt(0), dba.getPatternExpressionAnyCharacter().charAt(0), dba.getEscapeCharacter().charAt(0));
            if (caseSensitive) {
                StringLiteral patternExpr = new StringLiteral(this.qs, this.mapping, converter.convert(pattern).toLowerCase());
                return new LikeExpression(this.toLowerCaseMethod(), ScalarExpression.OP_LIKE, patternExpr);
            }
            StringLiteral patternExpr = new StringLiteral(this.qs, this.mapping, converter.convert(pattern));
            return new LikeExpression(this, ScalarExpression.OP_LIKE, patternExpr);
        }
        if (expr instanceof StringExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().matchesMethod(this, (StringExpression)expr);
        }
        throw new ScalarExpression.IllegalOperationException(this, "matches", expr);
    }

    public BooleanExpression likeMethod(ScalarExpression expr) {
        return new LikeExpression(this, OP_LIKE, expr);
    }

    public StringExpression trimMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().trimMethod(this, true, true);
    }

    public StringExpression trimLeftMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().trimMethod(this, true, false);
    }

    public StringExpression trimRightMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().trimMethod(this, false, true);
    }
}

