/**********************************************************************
Copyright (c) 2005 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

/**
 * Representation of the size of a container in a Query.
 *
 * @version $Revision: 1.4 $
 **/
class ContainerSizeExpression extends NumericExpression
{
    /**
     * Constructs a expression what will return true if the argument expression has elements 
     * @param qs the QueryExpression
     * @param argumentExpression the QueryExpression returning the size of the container 
     */    
    public ContainerSizeExpression(QueryExpression qs, QueryExpression argumentExpression)
    {
        super(qs);

        // Add parenthese around the subquery for clarity of SQL
        st.append("(");
        st.append(argumentExpression);
        st.append(")");
    }

    public BooleanExpression eq(ScalarExpression expr)
    {
        BooleanExpression eqExpr = super.eq(expr);
        eqExpr.encloseWithInParentheses();
        return eqExpr;
    }

    public BooleanExpression noteq(ScalarExpression expr)
    {
        BooleanExpression eqExpr = super.noteq(expr);
        eqExpr.encloseWithInParentheses();
        return eqExpr;
    }
    public BooleanExpression lt(ScalarExpression expr)
    {
        BooleanExpression eqExpr = super.lt(expr);
        eqExpr.encloseWithInParentheses();
        return eqExpr;
    }
    
    public BooleanExpression lteq(ScalarExpression expr)
    {
        BooleanExpression eqExpr = super.lteq(expr);
        eqExpr.encloseWithInParentheses();
        return eqExpr;
    }

    public BooleanExpression gt(ScalarExpression expr)
    {
        BooleanExpression eqExpr = super.gt(expr);
        eqExpr.encloseWithInParentheses();
        return eqExpr;
    }

    public BooleanExpression gteq(ScalarExpression expr)
    {
        BooleanExpression eqExpr = super.gteq(expr);
        eqExpr.encloseWithInParentheses();
        return eqExpr;
    }
}