/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.Iterator;
import java.util.List;
import org.cyclonedx.Version;
import org.cyclonedx.model.Bom;
import org.cyclonedx.util.serializer.PropertiesSerializer;

public class CustomSerializerModifier
extends BeanSerializerModifier {
    private final Version version;
    private final boolean isXml;

    public CustomSerializerModifier(boolean isXml, Version version) {
        this.version = version;
        this.isXml = isXml;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        if (Bom.class.isAssignableFrom(beanDesc.getBeanClass())) {
            Iterator<BeanPropertyWriter> iterator = beanProperties.iterator();
            while (iterator.hasNext()) {
                BeanPropertyWriter writer = iterator.next();
                if (!this.isValidAttribute(writer)) continue;
                if (this.shouldSerializeProperties(this.version)) {
                    PropertiesSerializer serializer = new PropertiesSerializer(this.isXml);
                    writer.assignSerializer((JsonSerializer)serializer);
                    continue;
                }
                iterator.remove();
            }
        }
        return beanProperties;
    }

    private boolean shouldSerializeProperties(Version version) {
        return this.isXml && version.getVersion() >= Version.VERSION_13.getVersion() || !this.isXml && version.getVersion() >= Version.VERSION_15.getVersion();
    }

    private boolean isValidAttribute(BeanPropertyWriter writer) {
        if (this.isXml) {
            return "properties".equals(writer.getWrapperName().getSimpleName());
        }
        return "properties".equals(writer.getName());
    }
}

