/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model.attestation.affirmation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Signature;
import org.cyclonedx.util.deserializer.SignatoryDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonTypeName(value="signatory")
@JsonDeserialize(using=SignatoryDeserializer.class)
public class Signatory {
    private String name;
    private String role;
    private Signature signature;
    private OrganizationalEntity organization;
    private ExternalReference externalReference;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
        this.organization = null;
        this.externalReference = null;
    }

    public OrganizationalEntity getOrganization() {
        return this.organization;
    }

    public void setOrganization(OrganizationalEntity organization) {
        this.organization = organization;
        this.signature = null;
    }

    public ExternalReference getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(ExternalReference externalReference) {
        this.externalReference = externalReference;
        this.signature = null;
    }

    public void setExternalReferenceAndOrganization(ExternalReference externalReference, OrganizationalEntity organization) {
        this.organization = organization;
        this.externalReference = externalReference;
        this.signature = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Signatory)) {
            return false;
        }
        Signatory signatory = (Signatory)object;
        return Objects.equals(this.name, signatory.name) && Objects.equals(this.role, signatory.role) && Objects.equals(this.signature, signatory.signature) && Objects.equals(this.organization, signatory.organization) && Objects.equals(this.externalReference, signatory.externalReference);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.role, this.signature, this.organization, this.externalReference);
    }
}

