/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.reflect.Field;
import org.cyclonedx.Format;
import org.cyclonedx.Version;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.generators.AbstractBomGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.BomReference;
import org.cyclonedx.util.introspector.VersionJsonAnnotationIntrospector;
import org.cyclonedx.util.mixin.MixInBomReference;
import org.cyclonedx.util.serializer.ComponentWrapperSerializer;
import org.cyclonedx.util.serializer.DependencySerializer;
import org.cyclonedx.util.serializer.TrimStringSerializer;

public class BomJsonGenerator
extends AbstractBomGenerator {
    private final DefaultPrettyPrinter prettyPrinter;

    public BomJsonGenerator(Bom bom, Version version) {
        super(version, bom, Format.JSON);
        Bom modifiedBom = null;
        try {
            modifiedBom = this.injectBomFormatAndSpecVersion(bom);
        }
        catch (GeneratorException generatorException) {
            // empty catch block
        }
        this.bom = modifiedBom != null ? modifiedBom : bom;
        this.prettyPrinter = new DefaultPrettyPrinter();
        this.setupPrettyPrinter(this.prettyPrinter);
        this.mapper = new ObjectMapper();
        this.setupObjectMapper();
    }

    private void setupObjectMapper() {
        this.mapper.setAnnotationIntrospector((AnnotationIntrospector)new VersionJsonAnnotationIntrospector(this.version));
        super.setupObjectMapper(false);
        SimpleModule depModule = new SimpleModule();
        SimpleModule componentWrapperModule = new SimpleModule();
        SimpleModule stringModule = new SimpleModule();
        stringModule.addSerializer((JsonSerializer)new TrimStringSerializer());
        this.mapper.registerModule((Module)stringModule);
        depModule.addSerializer((JsonSerializer)new DependencySerializer(false, null));
        this.mapper.registerModule((Module)depModule);
        componentWrapperModule.addSerializer((JsonSerializer)new ComponentWrapperSerializer(this.mapper));
        this.mapper.registerModule((Module)componentWrapperModule);
    }

    private void setupPrettyPrinter(DefaultPrettyPrinter prettyPrinter) {
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
    }

    private Bom injectBomFormatAndSpecVersion(Bom bom) throws GeneratorException {
        try {
            Field field = Bom.class.getDeclaredField("bomFormat");
            field.setAccessible(true);
            field.set(bom, "CycloneDX");
            field = Bom.class.getDeclaredField("specVersion");
            field.setAccessible(true);
            field.set(bom, this.getSchemaVersion().getVersionString());
            return bom;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new GeneratorException(e);
        }
    }

    public JsonNode toJsonNode() {
        try {
            return this.mapper.readTree(this.toJson(this.bom, false));
        }
        catch (JsonProcessingException | GeneratorException e) {
            return null;
        }
    }

    public String toJsonString() throws GeneratorException {
        return this.toJson(this.bom, true);
    }

    public String toString() {
        try {
            return this.toJson(this.bom, true);
        }
        catch (GeneratorException e) {
            return "";
        }
    }

    String toJson(Bom bom, boolean prettyPrint) throws GeneratorException {
        try {
            this.mapper.addMixIn(BomReference.class, MixInBomReference.class);
            if (prettyPrint) {
                return this.mapper.writer((PrettyPrinter)this.prettyPrinter).writeValueAsString((Object)bom);
            }
            return this.mapper.writeValueAsString((Object)bom);
        }
        catch (JsonProcessingException e) {
            throw new GeneratorException(e);
        }
    }
}

