/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.Version;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.JsonOnly;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.ReleaseNotes;
import org.cyclonedx.model.ServiceData;
import org.cyclonedx.model.Signature;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.model.component.Tags;
import org.cyclonedx.util.deserializer.ExternalReferencesDeserializer;
import org.cyclonedx.util.deserializer.LicenseDeserializer;
import org.cyclonedx.util.deserializer.StringListDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"bom-ref", "provider", "group", "name", "version", "description", "endpoints", "authenticated", "xTrustBoundary", "trustZone", "data", "licenses", "externalReferences", "properties", "tags", "services", "releaseNotes", "signature"})
public class Service
extends ExtensibleElement {
    @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
    @JsonProperty(value="bom-ref")
    private String bomRef;
    private OrganizationalEntity provider;
    private String group;
    private String name;
    private String version;
    private String description;
    private List<String> endpoints;
    private Boolean authenticated;
    @JacksonXmlProperty(localName="x-trust-boundary")
    @JsonProperty(value="x-trust-boundary")
    private Boolean xTrustBoundary;
    @VersionFilter(value=Version.VERSION_15)
    private String trustZone;
    private List<ServiceData> data;
    private LicenseChoice licenses;
    private List<ExternalReference> externalReferences;
    @VersionFilter(value=Version.VERSION_13)
    private List<Property> properties;
    @VersionFilter(value=Version.VERSION_16)
    @JsonUnwrapped
    private Tags tags;
    private List<Service> services;
    private ReleaseNotes releaseNotes;
    @JsonOnly
    @VersionFilter(value=Version.VERSION_14)
    private Signature signature;

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public OrganizationalEntity getProvider() {
        return this.provider;
    }

    public void setProvider(OrganizationalEntity provider) {
        this.provider = provider;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JacksonXmlElementWrapper(localName="endpoints")
    @JacksonXmlProperty(localName="endpoint")
    @JsonDeserialize(using=StringListDeserializer.class)
    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void addEndpoint(String endpoint) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(endpoint);
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public Boolean getxTrustBoundary() {
        return this.xTrustBoundary;
    }

    public void setxTrustBoundary(Boolean xTrustBoundary) {
        this.xTrustBoundary = xTrustBoundary;
    }

    @JacksonXmlElementWrapper(localName="data")
    @JacksonXmlProperty(localName="classification")
    public List<ServiceData> getData() {
        return this.data;
    }

    public void addServiceData(ServiceData data) {
        if (this.data == null) {
            this.data = new ArrayList<ServiceData>();
        }
        this.data.add(data);
    }

    public void setData(List<ServiceData> data) {
        this.data = data;
    }

    @Deprecated
    public LicenseChoice getLicense() {
        return this.getLicenses();
    }

    @Deprecated
    @JsonIgnore
    public void setLicense(LicenseChoice licenseChoice) {
        this.setLicenses(licenseChoice);
    }

    @JsonDeserialize(using=LicenseDeserializer.class)
    public LicenseChoice getLicenses() {
        return this.licenses;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    public void setLicenses(LicenseChoice licenses) {
        this.licenses = licenses;
    }

    @JacksonXmlElementWrapper(localName="externalReferences")
    @JacksonXmlProperty(localName="reference")
    @JsonDeserialize(using=ExternalReferencesDeserializer.class)
    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public void addExternalReference(ExternalReference externalReference) {
        if (this.externalReferences == null) {
            this.externalReferences = new ArrayList<ExternalReference>();
        }
        this.externalReferences.add(externalReference);
    }

    public void setExternalReferences(List<ExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(property);
    }

    @JacksonXmlElementWrapper(localName="services")
    @JacksonXmlProperty(localName="service")
    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public ReleaseNotes getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setReleaseNotes(ReleaseNotes releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public Tags getTags() {
        return this.tags;
    }

    public void setTags(Tags tags) {
        this.tags = tags;
    }

    public String getTrustZone() {
        return this.trustZone;
    }

    public void setTrustZone(String trustZone) {
        this.trustZone = trustZone;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Service)) {
            return false;
        }
        Service service = (Service)object;
        return Objects.equals(this.bomRef, service.bomRef) && Objects.equals(this.provider, service.provider) && Objects.equals(this.group, service.group) && Objects.equals(this.name, service.name) && Objects.equals(this.version, service.version) && Objects.equals(this.description, service.description) && Objects.equals(this.endpoints, service.endpoints) && Objects.equals(this.authenticated, service.authenticated) && Objects.equals(this.xTrustBoundary, service.xTrustBoundary) && Objects.equals(this.data, service.data) && Objects.equals(this.licenses, service.licenses) && Objects.equals(this.externalReferences, service.externalReferences) && Objects.equals(this.properties, service.properties) && Objects.equals(this.tags, service.tags) && Objects.equals(this.services, service.services) && Objects.equals(this.releaseNotes, service.releaseNotes) && Objects.equals(this.trustZone, service.trustZone) && Objects.equals(this.signature, service.signature);
    }

    public int hashCode() {
        return Objects.hash(this.bomRef, this.provider, this.group, this.name, this.version, this.description, this.endpoints, this.authenticated, this.signature, this.xTrustBoundary, this.trustZone, this.data, this.licenses, this.externalReferences, this.properties, this.tags, this.services, this.releaseNotes);
    }
}

