/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.checks;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.FieldUtils2;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

public final class AnnotationCheckFactory
extends CheckFactory {
    private static final String CAN_NOT_INSTANTIATE_THE_CHECK_RELATED_TO_THE_RULE = "Can not instantiate the check related to the rule ";
    private Map<String, Object> checksByKey = Maps.newHashMap();

    private AnnotationCheckFactory(RulesProfile profile, String repositoryKey, Collection checks) {
        super(profile, repositoryKey);
        this.groupByKey(checks);
    }

    public static AnnotationCheckFactory create(RulesProfile profile, String repositoryKey, Collection checkClasses) {
        AnnotationCheckFactory factory = new AnnotationCheckFactory(profile, repositoryKey, checkClasses);
        factory.init();
        return factory;
    }

    private void groupByKey(Collection checks) {
        for (Object check : checks) {
            String key = this.getRuleKey(check);
            if (key == null) continue;
            this.checksByKey.put(key, check);
        }
    }

    protected Object createCheck(ActiveRule activeRule) {
        Object object = this.checksByKey.get(activeRule.getConfigKey());
        if (object != null) {
            return this.instantiate(activeRule, object);
        }
        return null;
    }

    private Object instantiate(ActiveRule activeRule, Object checkClassOrInstance) {
        try {
            Object check = checkClassOrInstance;
            if (check instanceof Class) {
                check = ((Class)checkClassOrInstance).newInstance();
            }
            this.configureFields(activeRule, check);
            return check;
        }
        catch (InstantiationException e) {
            throw new SonarException(CAN_NOT_INSTANTIATE_THE_CHECK_RELATED_TO_THE_RULE + activeRule, e);
        }
        catch (IllegalAccessException e) {
            throw new SonarException(CAN_NOT_INSTANTIATE_THE_CHECK_RELATED_TO_THE_RULE + activeRule, e);
        }
    }

    private void configureFields(ActiveRule activeRule, Object check) {
        for (ActiveRuleParam param : activeRule.getActiveRuleParams()) {
            Field field = this.getField(check, param.getKey());
            if (field == null) {
                throw new SonarException("The field " + param.getKey() + " does not exist or is not annotated with @RuleProperty in the class " + check.getClass().getName());
            }
            if (!StringUtils.isNotBlank((String)param.getValue())) continue;
            this.configureField(check, field, param.getValue());
        }
    }

    private void configureField(Object check, Field field, String value) {
        block13: {
            try {
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(check, value);
                    break block13;
                }
                if ("int".equals(field.getType().getSimpleName())) {
                    field.setInt(check, Integer.parseInt(value));
                    break block13;
                }
                if ("short".equals(field.getType().getSimpleName())) {
                    field.setShort(check, Short.parseShort(value));
                    break block13;
                }
                if ("long".equals(field.getType().getSimpleName())) {
                    field.setLong(check, Long.parseLong(value));
                    break block13;
                }
                if ("double".equals(field.getType().getSimpleName())) {
                    field.setDouble(check, Double.parseDouble(value));
                    break block13;
                }
                if ("boolean".equals(field.getType().getSimpleName())) {
                    field.setBoolean(check, Boolean.parseBoolean(value));
                    break block13;
                }
                if ("byte".equals(field.getType().getSimpleName())) {
                    field.setByte(check, Byte.parseByte(value));
                    break block13;
                }
                if (field.getType().equals(Integer.class)) {
                    field.set(check, Integer.parseInt(value));
                    break block13;
                }
                if (field.getType().equals(Long.class)) {
                    field.set(check, Long.parseLong(value));
                    break block13;
                }
                if (field.getType().equals(Double.class)) {
                    field.set(check, Double.parseDouble(value));
                    break block13;
                }
                if (field.getType().equals(Boolean.class)) {
                    field.set(check, Boolean.parseBoolean(value));
                    break block13;
                }
                throw new SonarException("The type of the field " + field + " is not supported: " + field.getType());
            }
            catch (IllegalAccessException e) {
                throw new SonarException("Can not set the value of the field " + field + " in the class: " + check.getClass().getName(), e);
            }
        }
    }

    private Field getField(Object check, String key) {
        List<Field> fields = FieldUtils2.getFields(check.getClass(), true);
        for (Field field : fields) {
            RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
            if (propertyAnnotation == null || !StringUtils.equals((String)key, (String)field.getName()) && !StringUtils.equals((String)key, (String)propertyAnnotation.key())) continue;
            return field;
        }
        return null;
    }

    private String getRuleKey(Object annotatedClassOrObject) {
        String key = null;
        Rule ruleAnnotation = AnnotationUtils.getAnnotation(annotatedClassOrObject, Rule.class);
        if (ruleAnnotation != null) {
            key = ruleAnnotation.key();
        }
        Class clazz = annotatedClassOrObject.getClass();
        if (annotatedClassOrObject instanceof Class) {
            clazz = (Class)annotatedClassOrObject;
        }
        return StringUtils.defaultIfEmpty((String)key, (String)clazz.getCanonicalName());
    }
}

