/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.sonar.api.utils.SonarException;

public class StaxParser {
    private SMInputFactory inf;
    private XmlStreamHandler streamHandler;
    private boolean isoControlCharsAwareParser;

    public StaxParser(XmlStreamHandler streamHandler) {
        this(streamHandler, false);
    }

    public StaxParser(XmlStreamHandler streamHandler, boolean isoControlCharsAwareParser) {
        this.streamHandler = streamHandler;
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        if (xmlFactory instanceof WstxInputFactory) {
            WstxInputFactory wstxInputfactory = (WstxInputFactory)xmlFactory;
            wstxInputfactory.configureForLowMemUsage();
            wstxInputfactory.getConfig().setUndeclaredEntityResolver((XMLResolver)new UndeclaredEntitiesXMLResolver());
        }
        xmlFactory.setProperty("javax.xml.stream.isValidating", false);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
        this.isoControlCharsAwareParser = isoControlCharsAwareParser;
        this.inf = new SMInputFactory(xmlFactory);
    }

    public void parse(File xmlFile) throws XMLStreamException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(xmlFile);
            this.parse(input);
        }
        catch (FileNotFoundException e) {
            try {
                throw new XMLStreamException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    public void parse(InputStream xmlInput) throws XMLStreamException {
        xmlInput = this.isoControlCharsAwareParser ? new ISOControlCharAwareInputStream(xmlInput) : xmlInput;
        this.parse(this.inf.rootElementCursor(xmlInput));
    }

    public void parse(Reader xmlReader) throws XMLStreamException {
        if (this.isoControlCharsAwareParser) {
            throw new SonarException("Method call not supported when isoControlCharsAwareParser=true");
        }
        this.parse(this.inf.rootElementCursor(xmlReader));
    }

    public void parse(URL xmlUrl) throws XMLStreamException {
        try {
            this.parse(xmlUrl.openStream());
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(SMHierarchicCursor rootCursor) throws XMLStreamException {
        try {
            this.streamHandler.stream(rootCursor);
        }
        finally {
            rootCursor.getStreamReader().closeCompletely();
        }
    }

    private static class ISOControlCharAwareInputStream
    extends InputStream {
        private InputStream inputToCheck;

        public ISOControlCharAwareInputStream(InputStream inputToCheck) {
            this.inputToCheck = inputToCheck;
        }

        @Override
        public int read() throws IOException {
            return this.inputToCheck.read();
        }

        @Override
        public int available() throws IOException {
            return this.inputToCheck.available();
        }

        @Override
        public void close() throws IOException {
            this.inputToCheck.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.inputToCheck.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.inputToCheck.markSupported();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int readen = this.inputToCheck.read(b, off, len);
            this.checkBufferForISOControlChars(b, off, len);
            return readen;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int readen = this.inputToCheck.read(b);
            this.checkBufferForISOControlChars(b, 0, readen);
            return readen;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.inputToCheck.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputToCheck.skip(n);
        }

        private void checkBufferForISOControlChars(byte[] buffer, int off, int len) {
            for (int i = off; i < len; ++i) {
                char streamChar = (char)buffer[i];
                if (!Character.isISOControl(streamChar) || streamChar == '\n') continue;
                buffer[i] = 32;
            }
        }
    }

    public static interface XmlStreamHandler {
        public void stream(SMHierarchicCursor var1) throws XMLStreamException;
    }

    private static class UndeclaredEntitiesXMLResolver
    implements XMLResolver {
        private UndeclaredEntitiesXMLResolver() {
        }

        @Override
        public Object resolveEntity(String arg0, String arg1, String fileName, String undeclaredEntity) throws XMLStreamException {
            int unicodeCharHexValue;
            if (StringUtils.startsWithIgnoreCase((String)undeclaredEntity, (String)"u") && undeclaredEntity.length() == 5 && Character.isDefined(unicodeCharHexValue = Integer.parseInt(undeclaredEntity.substring(1), 16))) {
                undeclaredEntity = new String(new char[]{(char)unicodeCharHexValue});
            }
            return undeclaredEntity;
        }
    }
}

