/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ServerExtension;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.task.TaskExtension;

@Beta
@Immutable
public class ResourceTypeTree
implements TaskExtension,
ServerExtension {
    private List<ResourceType> types;
    private ListMultimap<String, String> relations;
    private ResourceType root;

    private ResourceTypeTree(Builder builder) {
        this.types = ImmutableList.copyOf((Collection)builder.types);
        this.relations = ImmutableListMultimap.copyOf((Multimap)builder.relations);
        this.root = builder.root;
    }

    public List<ResourceType> getTypes() {
        return this.types;
    }

    public List<String> getChildren(String qualifier) {
        return this.relations.get((Object)qualifier);
    }

    public ResourceType getRootType() {
        return this.root;
    }

    public List<String> getLeaves() {
        return ImmutableList.copyOf((Collection)Collections2.filter((Collection)this.relations.values(), (Predicate)new Predicate<String>(){

            public boolean apply(String qualifier) {
                return ResourceTypeTree.this.relations.get((Object)qualifier).isEmpty();
            }
        }));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ResourceType> types = Lists.newArrayList();
        private ListMultimap<String, String> relations = ArrayListMultimap.create();
        private ResourceType root;

        private Builder() {
        }

        public Builder addType(ResourceType type) {
            Preconditions.checkNotNull((Object)type);
            Preconditions.checkArgument((!this.types.contains(type) ? 1 : 0) != 0, (Object)String.format("%s is already registered", type.getQualifier()));
            this.types.add(type);
            return this;
        }

        public Builder addRelations(String parentQualifier, String ... childrenQualifiers) {
            Preconditions.checkNotNull((Object)parentQualifier);
            Preconditions.checkNotNull((Object)childrenQualifiers);
            Preconditions.checkArgument((childrenQualifiers.length > 0 ? 1 : 0) != 0, (Object)"childrenQualifiers can't be empty");
            this.relations.putAll((Object)parentQualifier, Arrays.asList(childrenQualifiers));
            return this;
        }

        public ResourceTypeTree build() {
            Collection children = this.relations.values();
            for (ResourceType type : this.types) {
                if (children.contains(type.getQualifier())) continue;
                this.root = type;
                break;
            }
            return new ResourceTypeTree(this);
        }
    }
}

