/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue.action;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.action.Function;
import org.sonar.api.issue.condition.Condition;

@Beta
public class Action {
    private final String key;
    private final List<Condition> conditions;
    private final List<Function> functions;

    Action(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Action key must be set");
        this.key = key;
        this.conditions = Lists.newArrayList();
        this.functions = Lists.newArrayList();
    }

    public String key() {
        return this.key;
    }

    public Action setConditions(Condition ... conditions) {
        this.conditions.addAll((Collection<Condition>)ImmutableList.copyOf((Object[])conditions));
        return this;
    }

    public List<Condition> conditions() {
        return this.conditions;
    }

    public Action setFunctions(Function ... functions) {
        this.functions.addAll((Collection<Function>)ImmutableList.copyOf((Object[])functions));
        return this;
    }

    public List<Function> functions() {
        return this.functions;
    }

    public boolean supports(Issue issue) {
        for (Condition condition : this.conditions) {
            if (condition.matches(issue)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action that = (Action)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }
}

