/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.block;

import com.google.common.annotations.Beta;
import org.sonar.duplications.CodeFragment;
import org.sonar.duplications.block.ByteArray;

public final class Block
implements CodeFragment {
    private final String resourceId;
    private final ByteArray blockHash;
    private final int indexInFile;
    private final int startLine;
    private final int endLine;
    private int startUnit;
    private int endUnit;
    private int hash;

    public static Builder builder() {
        return new Builder();
    }

    private Block(Builder builder) {
        this.resourceId = builder.resourceId;
        this.blockHash = builder.blockHash;
        this.indexInFile = builder.indexInFile;
        this.startLine = builder.startLine;
        this.endLine = builder.endLine;
        this.startUnit = builder.startUnit;
        this.endUnit = builder.endUnit;
    }

    public String getHashHex() {
        return this.getBlockHash().toString();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ByteArray getBlockHash() {
        return this.blockHash;
    }

    public int getIndexInFile() {
        return this.indexInFile;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    @Beta
    public int getStartUnit() {
        return this.startUnit;
    }

    @Beta
    public int getEndUnit() {
        return this.endUnit;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        return this.resourceId.equals(other.resourceId) && this.blockHash.equals(other.blockHash) && this.indexInFile == other.indexInFile && this.startLine == other.startLine && this.endLine == other.endLine;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.resourceId.hashCode();
            h = 31 * h + this.blockHash.hashCode();
            h = 31 * h + this.indexInFile;
            h = 31 * h + this.startLine;
            this.hash = h = 31 * h + this.endLine;
        }
        return h;
    }

    public String toString() {
        return "'" + this.resourceId + "'[" + this.indexInFile + "|" + this.startLine + "-" + this.endLine + "]:" + this.blockHash;
    }

    public static final class Builder {
        private String resourceId;
        private ByteArray blockHash;
        private int indexInFile;
        private int startLine;
        private int endLine;
        private int startUnit;
        private int endUnit;

        public Builder setResourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder setBlockHash(ByteArray blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public Builder setIndexInFile(int index) {
            this.indexInFile = index;
            return this;
        }

        public Builder setLines(int start, int end) {
            this.startLine = start;
            this.endLine = end;
            return this;
        }

        @Beta
        public Builder setUnit(int start, int end) {
            this.startUnit = start;
            this.endUnit = end;
            return this;
        }

        public Block build() {
            return new Block(this);
        }
    }
}

