/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.index.AbstractCloneIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCloneIndex2
extends AbstractCloneIndex {
    private Map<String, List<Block>> byResource = Maps.newHashMap();
    private Map<ByteArray, List<Block>> byHash = Maps.newHashMap();

    @Override
    public Collection<Block> getByResourceId(String resourceId) {
        return MemoryCloneIndex2.get(this.byResource, resourceId);
    }

    @Override
    public Collection<Block> getBySequenceHash(ByteArray sequenceHash) {
        return MemoryCloneIndex2.get(this.byHash, sequenceHash);
    }

    @Override
    public void insert(Block block) {
        MemoryCloneIndex2.put(this.byResource, block.getResourceId(), block);
        MemoryCloneIndex2.put(this.byHash, block.getBlockHash(), block);
    }

    private static <T> List<Block> get(Map<T, List<Block>> map, T key) {
        List blocks = map.get(key);
        return blocks != null ? blocks : Collections.EMPTY_LIST;
    }

    private static <T> void put(Map<T, List<Block>> map, T key, Block value) {
        LinkedList blocks = map.get(key);
        if (blocks == null) {
            blocks = Lists.newLinkedList();
            map.put(key, blocks);
        }
        blocks.add(value);
    }
}

