/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.channel;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.sonar.channel.ChannelException;

public class CodeBuffer
implements CharSequence {
    private final Reader code;
    private int lastChar = -1;
    private Cursor cursor;
    private static final int DEFAULT_BUFFER_CAPACITY = 8000;
    private int bufferCapacity;
    private char[] buffer;
    private int bufferPosition = 0;
    private int bufferSize = 0;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private boolean recordingMode = false;
    private StringBuilder recordedCharacters = new StringBuilder();

    public CodeBuffer(Reader code) {
        this(code, 8000);
    }

    private CodeBuffer(Reader code, int bufferCapacity) {
        this.code = code;
        this.lastChar = -1;
        this.cursor = new Cursor();
        this.bufferCapacity = bufferCapacity;
        this.buffer = new char[bufferCapacity];
        this.fillBuffer();
    }

    public CodeBuffer(String code) {
        this(new StringReader(code));
    }

    protected CodeBuffer(String code, int bufferCapacity) {
        this(new StringReader(code), bufferCapacity);
    }

    public final int pop() {
        int character;
        if (this.bufferPosition == this.bufferSize) {
            this.fillBuffer();
        }
        if (this.bufferSize == 0) {
            return -1;
        }
        if ((character = this.buffer[this.bufferPosition++]) == 10 || character == 13) {
            if (this.lastChar != 10 && this.lastChar != 13 || this.lastChar == character || this.lastChar == 10) {
                this.cursor.line++;
            }
            this.cursor.column = 0;
        } else {
            this.cursor.column++;
        }
        if (this.recordingMode) {
            this.recordedCharacters.append((char)character);
        }
        this.lastChar = character;
        return character;
    }

    private int fillBuffer() {
        try {
            int offset = this.bufferSize - this.bufferPosition;
            if (offset != 0) {
                System.arraycopy(this.buffer, this.bufferPosition, this.buffer, 0, this.bufferSize - this.bufferPosition);
            }
            this.bufferPosition = 0;
            int numberOfChars = this.code.read(this.buffer, offset, this.bufferCapacity - offset);
            if (numberOfChars == -1) {
                numberOfChars = 0;
            }
            this.bufferSize = numberOfChars + offset;
            return offset;
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage(), e);
        }
    }

    public final int lastChar() {
        return this.lastChar;
    }

    public final int peek() {
        return this.intAt(0);
    }

    public final void close() {
        IOUtils.closeQuietly((Reader)this.code);
    }

    public final int getLinePosition() {
        return this.cursor.line;
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    public final int getColumnPosition() {
        return this.cursor.column;
    }

    public final CodeBuffer setColumnPosition(int cp) {
        this.cursor.column = cp;
        return this;
    }

    public final void setLinePosition(int lp) {
        this.cursor.line = lp;
    }

    public final void startRecording() {
        this.recordingMode = true;
    }

    public final CharSequence stopRecording() {
        this.recordingMode = false;
        StringBuilder result = this.recordedCharacters;
        this.recordedCharacters = new StringBuilder();
        return result;
    }

    public final char charAt(int index) {
        return (char)this.intAt(index);
    }

    protected final int intAt(int index) {
        if (this.bufferPosition + index > this.bufferSize - 1) {
            this.fillBuffer();
        }
        if (this.bufferPosition + index > this.bufferSize - 1) {
            return -1;
        }
        return this.buffer[this.bufferPosition + index];
    }

    public final int length() {
        return this.bufferSize;
    }

    public final CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        StringBuilder result = new StringBuilder();
        result.append("CodeReader(");
        result.append("line:" + this.cursor.line);
        result.append("|column:" + this.cursor.column);
        result.append("|cursor value:'" + (char)this.peek() + "'");
        result.append(")");
        return result.toString();
    }

    public final class Cursor {
        private int line = 1;
        private int column = 0;

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public Cursor clone() {
            Cursor clone = new Cursor();
            clone.column = this.column;
            clone.line = this.line;
            return clone;
        }
    }
}

