/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.mojo;

import com.lowagie.text.DocumentException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.sonar.report.pdf.ExecutivePDFReporter;
import org.sonar.report.pdf.TeamWorkbookPDFReporter;
import org.sonar.report.pdf.entity.exception.ReportException;
import org.sonar.report.pdf.util.Credentials;
import org.sonar.report.pdf.util.Logger;

public class SonarPDFMojo
extends AbstractMojo {
    private File outputDirectory;
    private MavenProject project;
    private String sonarHostUrl;
    private String branch;
    private String sonarBranch;
    private String reportType;
    private String username;
    private String password;

    public void execute() throws MojoExecutionException {
        Logger.setLog(this.getLog());
        Properties config = new Properties();
        Properties configLang = new Properties();
        try {
            if (this.sonarHostUrl != null) {
                if (this.sonarHostUrl.endsWith("/")) {
                    this.sonarHostUrl = this.sonarHostUrl.substring(0, this.sonarHostUrl.length() - 1);
                }
                config.put("sonar.base.url", this.sonarHostUrl);
                config.put("front.page.logo", "sonar.png");
            } else {
                config.load(((Object)((Object)this)).getClass().getResourceAsStream("/report.properties"));
            }
            configLang.load(((Object)((Object)this)).getClass().getResourceAsStream("/report-texts-en.properties"));
            String sonarProjectId = this.project.getGroupId() + ":" + this.project.getArtifactId();
            if (this.branch != null) {
                sonarProjectId = sonarProjectId + ":" + this.branch;
                Logger.warn("Use of branch parameter is deprecated, use sonar.branch instead");
                Logger.info("Branch " + this.branch + " selected");
            } else if (this.sonarBranch != null) {
                sonarProjectId = sonarProjectId + ":" + this.sonarBranch;
                Logger.info("Branch " + this.sonarBranch + " selected");
            }
            ExecutivePDFReporter reporter = null;
            if (this.reportType != null) {
                if (this.reportType.equals("executive")) {
                    Logger.info("Executive report type selected");
                    reporter = new ExecutivePDFReporter(((Object)((Object)this)).getClass().getResource("/sonar.png"), sonarProjectId, config.getProperty("sonar.base.url"), config, configLang);
                } else if (this.reportType.equals("workbook")) {
                    Logger.info("Team workbook report type selected");
                    reporter = new TeamWorkbookPDFReporter(((Object)((Object)this)).getClass().getResource("/sonar.png"), sonarProjectId, config.getProperty("sonar.base.url"), config, configLang);
                }
            } else {
                Logger.info("No report type provided. Default report selected (Team workbook)");
                reporter = new TeamWorkbookPDFReporter(((Object)((Object)this)).getClass().getResource("/sonar.png"), sonarProjectId, config.getProperty("sonar.base.url"), config, configLang);
            }
            Credentials.setUsername(this.username);
            Credentials.setPassword(this.password);
            ByteArrayOutputStream baos = reporter.getReport();
            FileOutputStream fos = null;
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdirs();
            }
            File reportFile = new File(this.outputDirectory, this.project.getArtifactId() + ".pdf");
            fos = new FileOutputStream(reportFile);
            baos.writeTo(fos);
            fos.flush();
            fos.close();
            Logger.info("PDF report generated (see " + this.project.getArtifactId() + ".pdf on build output directory)");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            Logger.error("Problem generating PDF file.");
            e.printStackTrace();
        }
        catch (org.dom4j.DocumentException e) {
            Logger.error("Problem parsing response data.");
            e.printStackTrace();
        }
        catch (ReportException e) {
            Logger.error("Internal error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

