/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.entity;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.io.IOException;
import java.net.MalformedURLException;

public class ComplexityDistribution {
    String[] xValues;
    String[] yValues;
    String sonarBaseUrl;

    public ComplexityDistribution(String data, String sonarBaseUrl) {
        this.sonarBaseUrl = sonarBaseUrl;
        String[] unitData = data.split(";");
        this.xValues = new String[unitData.length];
        this.yValues = new String[unitData.length];
        if (!data.equals("N/A")) {
            for (int i = 0; i < unitData.length; ++i) {
                String[] values = unitData[i].split("=");
                this.xValues[i] = values[0];
                this.yValues[i] = values[1];
            }
        }
    }

    public Image getGraphic() {
        Image image = null;
        try {
            if (this.yValues.length != 0) {
                image = Image.getInstance((String)(this.sonarBaseUrl + "/chart?cht=cvb&chdi=300x200&chca=" + this.formatXValues() + "&chov=y&chrav=y&chv=" + this.formatYValues() + "&chorgv=y&chcaaml=0.05&chseamu=0.2&chins=5&chcaamu=0.05&chcav=y&chc=777777,777777,777777,777777,777777,777777,777777"));
                image.setAlignment(5);
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    private String formatYValues() {
        String formatValues = "";
        for (int i = 0; i < this.yValues.length; ++i) {
            formatValues = i != this.yValues.length - 1 ? formatValues + this.yValues[i] + "," : formatValues + this.yValues[i];
        }
        return formatValues;
    }

    private String formatXValues() {
        String formatValues = "";
        for (int i = 0; i < this.xValues.length; ++i) {
            formatValues = i != this.xValues.length - 1 ? formatValues + this.xValues[i] + "%2b," : formatValues + this.xValues[i] + "%2b";
        }
        return formatValues;
    }
}

