/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.httpclient.HttpException;
import org.sonar.report.pdf.Events;
import org.sonar.report.pdf.Header;
import org.sonar.report.pdf.Toc;
import org.sonar.report.pdf.entity.ComplexityDistribution;
import org.sonar.report.pdf.entity.Project;
import org.sonar.report.pdf.entity.exception.ReportException;
import org.sonar.report.pdf.util.Credentials;
import org.sonar.report.pdf.util.Logger;
import org.sonar.report.pdf.util.SonarAccess;

public abstract class PDFReporter {
    private Project project = null;
    public static String reportType = "workbook";

    public ByteArrayOutputStream getReport() throws DocumentException, IOException, org.dom4j.DocumentException, ReportException {
        int i;
        Document mainDocument = new Document(PageSize.A4, 50.0f, 50.0f, 110.0f, 50.0f);
        Toc tocDocument = new Toc();
        Document frontPageDocument = new Document(PageSize.A4, 50.0f, 50.0f, 110.0f, 50.0f);
        ByteArrayOutputStream mainDocumentBaos = new ByteArrayOutputStream();
        ByteArrayOutputStream frontPageDocumentBaos = new ByteArrayOutputStream();
        PdfWriter mainDocumentWriter = PdfWriter.getInstance((Document)mainDocument, (OutputStream)mainDocumentBaos);
        PdfWriter frontPageDocumentWriter = PdfWriter.getInstance((Document)frontPageDocument, (OutputStream)frontPageDocumentBaos);
        Events events = new Events(tocDocument, new Header(this.getLogo(), this.getProject()));
        mainDocumentWriter.setPageEvent((PdfPageEvent)events);
        mainDocument.open();
        tocDocument.getTocDocument().open();
        frontPageDocument.open();
        Logger.info("Generating PDF report...");
        this.printFrontPage(frontPageDocument, frontPageDocumentWriter);
        this.printTocTitle(tocDocument);
        this.printPdfBody(mainDocument);
        mainDocument.close();
        tocDocument.getTocDocument().close();
        frontPageDocument.close();
        PdfReader mainDocumentReader = new PdfReader(mainDocumentBaos.toByteArray());
        PdfReader tocDocumentReader = new PdfReader(tocDocument.getTocOutputStream().toByteArray());
        PdfReader frontPageDocumentReader = new PdfReader(frontPageDocumentBaos.toByteArray());
        Document documentWithToc = new Document(tocDocumentReader.getPageSizeWithRotation(1));
        ByteArrayOutputStream finalBaos = new ByteArrayOutputStream();
        PdfCopy copy = new PdfCopy(documentWithToc, (OutputStream)finalBaos);
        documentWithToc.open();
        copy.addPage(copy.getImportedPage(frontPageDocumentReader, 1));
        for (i = 1; i <= tocDocumentReader.getNumberOfPages(); ++i) {
            copy.addPage(copy.getImportedPage(tocDocumentReader, i));
        }
        for (i = 1; i <= mainDocumentReader.getNumberOfPages(); ++i) {
            copy.addPage(copy.getImportedPage(mainDocumentReader, i));
        }
        documentWithToc.close();
        return finalBaos;
    }

    public Project getProject() throws HttpException, IOException, org.dom4j.DocumentException, ReportException {
        if (this.project == null) {
            SonarAccess sonarAccess = new SonarAccess(this.getSonarUrl(), Credentials.getUsername(), Credentials.getPassword());
            this.project = new Project(this.getProjectKey());
            this.project.initializeProject(sonarAccess);
        }
        return this.project;
    }

    public Image getCCNDistribution(Project project) {
        String data = project.getMeasure("class_complexity_distribution").getTextValue() != null ? project.getMeasure("class_complexity_distribution").getTextValue() : "N/A";
        ComplexityDistribution ccnDist = new ComplexityDistribution(data, this.getSonarUrl());
        return ccnDist.getGraphic();
    }

    public String getTextProperty(String key) {
        return this.getLangProperties().getProperty(key);
    }

    public String getConfigProperty(String key) {
        return this.getReportProperties().getProperty(key);
    }

    public Image getTendencyImage(int tendencyQualitative, int tendencyCuantitative) {
        String iconName;
        if (tendencyQualitative == 0) {
            switch (tendencyCuantitative) {
                case -2: {
                    iconName = "-2-black.png";
                    break;
                }
                case -1: {
                    iconName = "-1-black.png";
                    break;
                }
                case 1: {
                    iconName = "1-black.png";
                    break;
                }
                case 2: {
                    iconName = "2-black.png";
                    break;
                }
                default: {
                    iconName = "none.png";
                    break;
                }
            }
        } else {
            switch (tendencyQualitative) {
                case -2: {
                    iconName = "-2-red.png";
                    break;
                }
                case -1: {
                    iconName = "-1-red.png";
                    break;
                }
                case 1: {
                    iconName = "1-green.png";
                    break;
                }
                case 2: {
                    iconName = "2-green.png";
                    break;
                }
                default: {
                    iconName = "none.png";
                }
            }
        }
        Image tendencyImage = null;
        try {
            tendencyImage = Image.getInstance((URL)this.getClass().getResource("/tendency/" + iconName));
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tendencyImage;
    }

    protected abstract String getSonarUrl();

    protected abstract void printPdfBody(Document var1) throws DocumentException, IOException, org.dom4j.DocumentException, ReportException;

    protected abstract void printTocTitle(Toc var1) throws DocumentException, IOException;

    protected abstract URL getLogo();

    protected abstract String getProjectKey();

    protected abstract void printFrontPage(Document var1, PdfWriter var2) throws org.dom4j.DocumentException, ReportException;

    protected abstract Properties getReportProperties();

    protected abstract Properties getLangProperties();
}

