/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;

public class FileResourceLoader
extends AbstractResourceLoader {
    public static final String ID = "file";

    public InputStream getResourceAsInputStream(String name) throws ResourceNotFoundException {
        Iterator it = this.paths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            File file = new File(path, name);
            if (!file.canRead()) continue;
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ResourceNotFoundException(name);
            }
        }
        throw new ResourceNotFoundException(name);
    }

    public static File getResourceAsFile(String name, String outputPath, File outputDirectory) throws FileResourceCreationException {
        File f = new File(name);
        if (f.exists()) {
            if (outputPath == null) {
                return f;
            }
            try {
                File outputFile = outputDirectory != null ? new File(outputDirectory, outputPath) : new File(outputPath);
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                FileUtils.copyFile((File)f, (File)outputFile);
                return outputFile;
            }
            catch (IOException e) {
                throw new FileResourceCreationException("Cannot create file-based resource.", e);
            }
        }
        return null;
    }
}

