/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.composition;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.composition.AbstractComponentComposer;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.CompositionUtils;
import org.codehaus.plexus.component.composition.Requirement;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.util.ReflectionUtils;

public class FieldComponentComposer
extends AbstractComponentComposer {
    static /* synthetic */ Class class$java$lang$Object;

    public void assignRequirement(Object component, ComponentDescriptor componentDescriptor, ComponentRequirement requirement, PlexusContainer container, Map compositionContext) throws CompositionException {
        Field field = this.findMatchingField(component, componentDescriptor, requirement, container);
        if (!field.isAccessible()) {
            ((AccessibleObject)field).setAccessible(true);
        }
        this.assignRequirementToField(component, field, container, requirement);
    }

    private List assignRequirementToField(Object component, Field field, PlexusContainer container, ComponentRequirement requirementDescriptor) throws CompositionException {
        Requirement requirement = CompositionUtils.findRequirement(component, field.getType(), container, requirementDescriptor);
        try {
            field.set(component, requirement.getAssignment());
            return requirement.getComponentDescriptors();
        }
        catch (IllegalArgumentException e) {
            throw new CompositionException("Composition failed for the field " + field.getName() + " " + "in object of type " + component.getClass().getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CompositionException("Composition failed for the field " + field.getName() + " " + "in object of type " + component.getClass().getName(), (Throwable)e);
        }
    }

    protected Field findMatchingField(Object component, ComponentDescriptor componentDescriptor, ComponentRequirement requirement, PlexusContainer container) throws CompositionException {
        String fieldName = requirement.getFieldName();
        Field field = null;
        if (fieldName != null) {
            field = this.getFieldByName(component, fieldName, componentDescriptor);
        } else {
            Class<?> fieldClass = null;
            try {
                fieldClass = container != null ? container.getContainerRealm().loadClass(requirement.getRole()) : Thread.currentThread().getContextClassLoader().loadClass(requirement.getRole());
            }
            catch (ClassNotFoundException e) {
                StringBuffer msg = new StringBuffer("Component Composition failed for component: ");
                msg.append(componentDescriptor.getHumanReadableKey());
                msg.append(": Requirement class: '");
                msg.append(requirement.getRole());
                msg.append("' not found.");
                throw new CompositionException(msg.toString(), (Throwable)e);
            }
            field = this.getFieldByType(component, fieldClass, componentDescriptor);
        }
        return field;
    }

    protected Field getFieldByName(Object component, String fieldName, ComponentDescriptor componentDescriptor) throws CompositionException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)fieldName, component.getClass());
        if (field == null) {
            StringBuffer msg = new StringBuffer("Component Composition failed. No field of name: '");
            msg.append(fieldName);
            msg.append("' exists in component: ");
            msg.append(componentDescriptor.getHumanReadableKey());
            throw new CompositionException(msg.toString());
        }
        return field;
    }

    protected Field getFieldByTypeIncludingSuperclasses(Class componentClass, Class type, ComponentDescriptor componentDescriptor) throws CompositionException {
        List fields = this.getFieldsByTypeIncludingSuperclasses(componentClass, type, componentDescriptor);
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() == 1) {
            return (Field)fields.get(0);
        }
        throw new CompositionException("There are several fields of type '" + type + "', " + "use 'field-name' to select the correct field.");
    }

    protected List getFieldsByTypeIncludingSuperclasses(Class componentClass, Class type, ComponentDescriptor componentDescriptor) throws CompositionException {
        Class<?> arrayType = Array.newInstance(type, 0).getClass();
        Field[] fields = componentClass.getDeclaredFields();
        ArrayList<Field> foundFields = new ArrayList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            Class<?> fieldType = fields[i].getType();
            if (!fieldType.isAssignableFrom(type) && !fieldType.isAssignableFrom(arrayType)) continue;
            foundFields.add(fields[i]);
        }
        if (componentClass.getSuperclass() != (class$java$lang$Object == null ? (class$java$lang$Object = FieldComponentComposer.class$("java.lang.Object")) : class$java$lang$Object)) {
            List superFields = this.getFieldsByTypeIncludingSuperclasses(componentClass.getSuperclass(), type, componentDescriptor);
            foundFields.addAll(superFields);
        }
        return foundFields;
    }

    protected Field getFieldByType(Object component, Class type, ComponentDescriptor componentDescriptor) throws CompositionException {
        Field field = this.getFieldByTypeIncludingSuperclasses(component.getClass(), type, componentDescriptor);
        if (field == null) {
            StringBuffer msg = new StringBuffer("Component composition failed. No field of type: '");
            msg.append(type);
            msg.append("' exists in class '");
            msg.append(component.getClass().getName());
            msg.append("'.");
            if (componentDescriptor != null) {
                msg.append(" Component: ");
                msg.append(componentDescriptor.getHumanReadableKey());
            }
            throw new CompositionException(msg.toString());
        }
        return field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

