/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompilerConfiguration {
    private String outputLocation;
    private List<String> classpathEntries = new LinkedList<String>();
    private List<String> modulepathEntries = new LinkedList<String>();
    private Set<File> sourceFiles = new HashSet<File>();
    private List<String> sourceLocations = new LinkedList<String>();
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private boolean debug;
    private String debugLevel;
    private boolean showWarnings = true;
    private String warnings;
    private boolean showLint;
    private boolean failOnWarning;
    private boolean showDeprecation;
    private String sourceVersion;
    private String targetVersion;
    private String releaseVersion;
    private String sourceEncoding;
    private String moduleVersion;
    private Collection<Map.Entry<String, String>> customCompilerArguments = new ArrayList<Map.Entry<String, String>>();
    private boolean fork;
    private boolean optimize;
    private String meminitial;
    private String maxmem;
    private String executable;
    private File workingDirectory;
    private String compilerVersion;
    private boolean verbose = false;
    private boolean parameters;
    private File buildDirectory;
    private String outputFileName;
    private File generatedSourcesDirectory;
    private String proc;
    private String[] annotationProcessors;
    private List<String> processorPathEntries;
    private List<String> processorModulePathEntries;
    private CompilerReuseStrategy compilerReuseStrategy = CompilerReuseStrategy.ReuseCreated;
    private boolean forceJavacCompilerUse = false;

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public void addClasspathEntry(String classpathEntry) {
        this.classpathEntries.add(classpathEntry);
    }

    public void setClasspathEntries(List<String> classpathEntries) {
        this.classpathEntries = classpathEntries == null ? Collections.emptyList() : new LinkedList<String>(classpathEntries);
    }

    public List<String> getClasspathEntries() {
        return Collections.unmodifiableList(this.classpathEntries);
    }

    public void addModulepathEntry(String modulepathEntry) {
        this.modulepathEntries.add(modulepathEntry);
    }

    public void setModulepathEntries(List<String> modulepathEntries) {
        this.modulepathEntries = modulepathEntries == null ? Collections.emptyList() : new LinkedList<String>(modulepathEntries);
    }

    public List<String> getModulepathEntries() {
        return Collections.unmodifiableList(this.modulepathEntries);
    }

    public void setSourceFiles(Set<File> sourceFiles) {
        this.sourceFiles = sourceFiles == null ? Collections.emptySet() : new HashSet<File>(sourceFiles);
    }

    public Set<File> getSourceFiles() {
        return this.sourceFiles;
    }

    public void addSourceLocation(String sourceLocation) {
        this.sourceLocations.add(sourceLocation);
    }

    public void setSourceLocations(List<String> sourceLocations) {
        this.sourceLocations = sourceLocations == null ? Collections.emptyList() : new LinkedList<String>(sourceLocations);
    }

    public List<String> getSourceLocations() {
        return Collections.unmodifiableList(this.sourceLocations);
    }

    public void addInclude(String include) {
        this.includes.add(include);
    }

    public void setIncludes(Set<String> includes) {
        this.includes = includes == null ? Collections.emptySet() : new HashSet<String>(includes);
    }

    public Set<String> getIncludes() {
        return Collections.unmodifiableSet(this.includes);
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes == null ? Collections.emptySet() : new HashSet<String>(excludes);
    }

    public Set<String> getExcludes() {
        return Collections.unmodifiableSet(this.excludes);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebugLevel(String debugLevel) {
        this.debugLevel = debugLevel;
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setWarnings(String warnings) {
        this.warnings = warnings;
    }

    public boolean isShowWarnings() {
        return this.showWarnings;
    }

    public void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
    }

    public boolean isShowDeprecation() {
        return this.showDeprecation;
    }

    public String getWarnings() {
        return this.warnings;
    }

    public void setShowLint(boolean showLint) {
        this.showLint = showLint;
    }

    public boolean isShowLint() {
        return this.showLint;
    }

    public void setShowDeprecation(boolean showDeprecation) {
        this.showDeprecation = showDeprecation;
    }

    public boolean isFailOnWarning() {
        return this.failOnWarning;
    }

    public void setFailOnWarning(boolean failOnWarnings) {
        this.failOnWarning = failOnWarnings;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(String releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(String moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public void addCompilerCustomArgument(String customArgument, String value) {
        this.customCompilerArguments.add(new AbstractMap.SimpleImmutableEntry<String, String>(customArgument, value));
    }

    @Deprecated
    public LinkedHashMap<String, String> getCustomCompilerArguments() {
        LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>(this.customCompilerArguments.size());
        for (Map.Entry<String, String> entry : this.customCompilerArguments) {
            arguments.put(entry.getKey(), entry.getValue());
        }
        return arguments;
    }

    @Deprecated
    public void setCustomCompilerArguments(LinkedHashMap<String, String> customCompilerArguments) {
        this.setCustomCompilerArgumentsAsMap(customCompilerArguments);
    }

    public Map<String, String> getCustomCompilerArgumentsAsMap() {
        LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>(this.customCompilerArguments.size());
        for (Map.Entry<String, String> entry : this.customCompilerArguments) {
            arguments.put(entry.getKey(), entry.getValue());
        }
        return arguments;
    }

    public void setCustomCompilerArgumentsAsMap(Map<String, String> customCompilerArguments) {
        this.customCompilerArguments = new ArrayList<Map.Entry<String, String>>();
        if (customCompilerArguments != null) {
            this.customCompilerArguments.addAll(customCompilerArguments.entrySet());
        }
    }

    public Collection<Map.Entry<String, String>> getCustomCompilerArgumentsEntries() {
        return this.customCompilerArguments;
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public String getMeminitial() {
        return this.meminitial;
    }

    public void setMeminitial(String meminitial) {
        this.meminitial = meminitial;
    }

    public String getMaxmem() {
        return this.maxmem;
    }

    public void setMaxmem(String maxmem) {
        this.maxmem = maxmem;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    public void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public String getCompilerVersion() {
        return this.compilerVersion;
    }

    public void setCompilerVersion(String compilerVersion) {
        this.compilerVersion = compilerVersion;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isParameters() {
        return this.parameters;
    }

    public void setParameters(boolean parameters) {
        this.parameters = parameters;
    }

    public void setProc(String proc) {
        this.proc = proc;
    }

    public void setGeneratedSourcesDirectory(File generatedSourcesDirectory) {
        this.generatedSourcesDirectory = generatedSourcesDirectory;
    }

    public File getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    public String getProc() {
        return this.proc;
    }

    public void setAnnotationProcessors(String[] annotationProcessors) {
        this.annotationProcessors = annotationProcessors;
    }

    public String[] getAnnotationProcessors() {
        return this.annotationProcessors;
    }

    public void addProcessorPathEntry(String entry) {
        if (this.processorPathEntries == null) {
            this.processorPathEntries = new LinkedList<String>();
        }
        this.processorPathEntries.add(entry);
    }

    public List<String> getProcessorPathEntries() {
        return this.processorPathEntries;
    }

    public void setProcessorPathEntries(List<String> processorPathEntries) {
        this.processorPathEntries = processorPathEntries;
    }

    public void addProcessorModulePathEntry(String entry) {
        if (this.processorModulePathEntries == null) {
            this.processorModulePathEntries = new LinkedList<String>();
        }
        this.processorModulePathEntries.add(entry);
    }

    public List<String> getProcessorModulePathEntries() {
        return this.processorModulePathEntries;
    }

    public void setProcessorModulePathEntries(List<String> processorModulePathEntries) {
        this.processorModulePathEntries = processorModulePathEntries;
    }

    public CompilerReuseStrategy getCompilerReuseStrategy() {
        return this.compilerReuseStrategy;
    }

    public void setCompilerReuseStrategy(CompilerReuseStrategy compilerReuseStrategy) {
        this.compilerReuseStrategy = compilerReuseStrategy;
    }

    public boolean isForceJavacCompilerUse() {
        return this.forceJavacCompilerUse;
    }

    public void setForceJavacCompilerUse(boolean forceJavacCompilerUse) {
        this.forceJavacCompilerUse = forceJavacCompilerUse;
    }

    public static enum CompilerReuseStrategy {
        ReuseSame("reuseSame"),
        AlwaysNew("alwaysNew"),
        ReuseCreated("reuseCreated");

        private String strategy;

        private CompilerReuseStrategy(String strategy) {
            this.strategy = strategy;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public String toString() {
            return "CompilerReuseStrategy:" + this.strategy;
        }
    }
}

