/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.components.io.attributes.SymlinkUtils;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnArchiver
implements UnArchiver,
FinalizerEnabled {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File destDirectory;
    private File destFile;
    private File sourceFile;
    private boolean overwrite = true;
    private FileMapper[] fileMappers;
    private List<ArchiveFinalizer> finalizers;
    private FileSelector[] fileSelectors;
    private boolean useJvmChmod = true;
    private boolean ignorePermissions = false;
    final AtomicInteger casingMessageEmitted = new AtomicInteger(0);

    protected Logger getLogger() {
        return this.logger;
    }

    public AbstractUnArchiver() {
    }

    public AbstractUnArchiver(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    public File getDestDirectory() {
        return this.destDirectory;
    }

    @Override
    public void setDestDirectory(File destDirectory) {
        this.destDirectory = destDirectory;
    }

    @Override
    public File getDestFile() {
        return this.destFile;
    }

    @Override
    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    @Override
    public File getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    @Override
    public FileMapper[] getFileMappers() {
        return this.fileMappers;
    }

    @Override
    public void setFileMappers(FileMapper[] fileMappers) {
        this.fileMappers = fileMappers;
    }

    @Override
    public final void extract() throws ArchiverException {
        this.validate();
        this.execute();
        this.runArchiveFinalizers();
    }

    @Override
    public final void extract(String path, File outputDirectory) throws ArchiverException {
        this.validate(path, outputDirectory);
        this.execute(path, outputDirectory);
        this.runArchiveFinalizers();
    }

    @Override
    public void addArchiveFinalizer(ArchiveFinalizer finalizer) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<ArchiveFinalizer>();
        }
        this.finalizers.add(finalizer);
    }

    @Override
    public void setArchiveFinalizers(List<ArchiveFinalizer> archiveFinalizers) {
        this.finalizers = archiveFinalizers;
    }

    private void runArchiveFinalizers() throws ArchiverException {
        if (this.finalizers != null) {
            for (ArchiveFinalizer finalizer : this.finalizers) {
                finalizer.finalizeArchiveExtraction(this);
            }
        }
    }

    protected void validate(String path, File outputDirectory) {
    }

    protected void validate() throws ArchiverException {
        if (this.sourceFile == null) {
            throw new ArchiverException("The source file isn't defined.");
        }
        if (this.sourceFile.isDirectory()) {
            throw new ArchiverException("The source must not be a directory.");
        }
        if (!this.sourceFile.exists()) {
            throw new ArchiverException("The source file " + this.sourceFile + " doesn't exist.");
        }
        if (this.destDirectory == null && this.destFile == null) {
            throw new ArchiverException("The destination isn't defined.");
        }
        if (this.destDirectory != null && this.destFile != null) {
            throw new ArchiverException("You must choose between a destination directory and a destination file.");
        }
        if (this.destDirectory != null && !this.destDirectory.isDirectory()) {
            this.destFile = this.destDirectory;
            this.destDirectory = null;
        }
        if (this.destFile != null && this.destFile.isDirectory()) {
            this.destDirectory = this.destFile;
            this.destFile = null;
        }
    }

    @Override
    public void setFileSelectors(FileSelector[] fileSelectors) {
        this.fileSelectors = fileSelectors;
    }

    @Override
    public FileSelector[] getFileSelectors() {
        return this.fileSelectors;
    }

    protected boolean isSelected(String fileName, PlexusIoResource fileInfo) throws ArchiverException {
        if (this.fileSelectors != null) {
            for (FileSelector fileSelector : this.fileSelectors) {
                try {
                    if (fileSelector.isSelected((FileInfo)fileInfo)) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new ArchiverException("Failed to check, whether " + fileInfo.getName() + " is selected: " + e.getMessage(), e);
                }
            }
        }
        return true;
    }

    protected abstract void execute() throws ArchiverException;

    protected abstract void execute(String var1, File var2) throws ArchiverException;

    @Override
    @Deprecated
    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    @Override
    @Deprecated
    public void setUseJvmChmod(boolean useJvmChmod) {
        this.useJvmChmod = useJvmChmod;
    }

    @Override
    public boolean isIgnorePermissions() {
        return this.ignorePermissions;
    }

    @Override
    public void setIgnorePermissions(boolean ignorePermissions) {
        this.ignorePermissions = ignorePermissions;
    }

    protected void extractFile(File srcF, File dir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory, Integer mode, String symlinkDestination, FileMapper[] fileMappers) throws IOException, ArchiverException {
        if (fileMappers != null) {
            for (FileMapper fileMapper : fileMappers) {
                entryName = fileMapper.getMappedFileName(entryName);
            }
        }
        File targetFileName = FileUtils.resolveFile((File)dir, (String)entryName);
        Path canonicalDirPath = dir.getCanonicalFile().toPath();
        Path canonicalDestPath = targetFileName.getCanonicalFile().toPath();
        if (!canonicalDestPath.startsWith(canonicalDirPath)) {
            throw new ArchiverException("Entry is outside of the target directory (" + entryName + ")");
        }
        if (StringUtils.isEmpty((String)symlinkDestination) && Files.isSymbolicLink(canonicalDestPath)) {
            throw new ArchiverException("Entry is outside of the target directory (" + entryName + ")");
        }
        try {
            if (!this.shouldExtractEntry(dir, targetFileName, entryName, entryDate)) {
                return;
            }
            File dirF = targetFileName.getParentFile();
            if (dirF != null) {
                dirF.mkdirs();
            }
            if (!StringUtils.isEmpty((String)symlinkDestination)) {
                SymlinkUtils.createSymbolicLink((File)targetFileName, (File)new File(symlinkDestination));
            } else if (isDirectory) {
                targetFileName.mkdirs();
            } else {
                Files.copy(compressedInputStream, targetFileName.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            targetFileName.setLastModified(entryDate.getTime());
            if (!this.isIgnorePermissions() && mode != null && !isDirectory) {
                ArchiveEntryUtils.chmod(targetFileName, mode);
            }
        }
        catch (FileNotFoundException ex) {
            this.getLogger().warn("Unable to expand to file " + targetFileName.getPath());
        }
    }

    protected boolean shouldExtractEntry(File targetDirectory, File targetFileName, String entryName, Date entryDate) throws IOException {
        boolean differentCasing;
        if (!targetFileName.exists()) {
            return true;
        }
        boolean entryIsDirectory = entryName.endsWith("/");
        String canonicalDestPath = targetFileName.getCanonicalPath();
        String suffix = entryIsDirectory ? "/" : "";
        String relativeCanonicalDestPath = canonicalDestPath.replace(targetDirectory.getCanonicalPath() + File.separatorChar, "") + suffix;
        boolean fileOnDiskIsOlderThanEntry = targetFileName.lastModified() < entryDate.getTime();
        boolean bl = differentCasing = !this.normalizedFileSeparator(entryName).equals(this.normalizedFileSeparator(relativeCanonicalDestPath));
        if (differentCasing) {
            String casingMessage = String.format(Locale.ENGLISH, "Archive entry '%s' and existing file '%s' names differ only by case. This may lead to an unexpected outcome on case-insensitive filesystems.", entryName, canonicalDestPath);
            this.getLogger().warn(casingMessage);
            this.casingMessageEmitted.incrementAndGet();
        }
        return this.isOverwrite() || fileOnDiskIsOlderThanEntry;
    }

    private String normalizedFileSeparator(String pathOrEntry) {
        return pathOrEntry.replace("/", File.separator);
    }
}

