/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.mojo.xml.LSInputImpl;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Resolver
implements EntityResolver,
URIResolver,
LSResourceResolver {
    private final CatalogResolver resolver;

    Resolver(File[] pFiles) throws MojoExecutionException {
        CatalogManager manager = new CatalogManager();
        manager.setIgnoreMissingProperties(true);
        this.resolver = new CatalogResolver(manager);
        for (int i = 0; i < pFiles.length; ++i) {
            try {
                this.resolver.getCatalog().parseCatalog(pFiles[i].toURI().toURL().toExternalForm());
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse catalog file: " + pFiles[i].getPath() + ": " + e.getMessage(), (Exception)e);
            }
        }
    }

    public InputSource resolveEntity(String pPublicId, String pSystemId) throws SAXException, IOException {
        return this.resolver.resolveEntity(pPublicId, pSystemId);
    }

    public Source resolve(String pHref, String pBase) throws TransformerException {
        Source source = this.resolver.resolve(pHref, pBase);
        if (source == null) {
            return source;
        }
        InputSource isource = SAXSource.sourceToInputSource(source);
        if (isource == null) {
            return source;
        }
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            spf.setNamespaceAware(true);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            xmlReader.setEntityResolver(this);
            return new SAXSource(xmlReader, isource);
        }
        catch (ParserConfigurationException e) {
            throw new TransformerException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public LSInput resolveResource(String pType, String pNamespaceURI, String pPublicId, String pSystemId, String pBaseURI) {
        InputSource isource = this.resolver.resolveEntity(pPublicId, pSystemId);
        if (isource == null) {
            return null;
        }
        LSInputImpl result = new LSInputImpl();
        result.setByteStream(isource.getByteStream());
        result.setCharacterStream(isource.getCharacterStream());
        result.setPublicId(isource.getPublicId());
        result.setSystemId(isource.getSystemId());
        result.setEncoding(isource.getEncoding());
        return result;
    }
}

