/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webstart.util.IOUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class DefaultIOUtil
extends AbstractLogEnabled
implements IOUtil {
    public void copyResources(File sourceDirectory, File targetDirectory) throws MojoExecutionException {
        if (!sourceDirectory.exists()) {
            this.getLogger().info("Directory does not exist " + sourceDirectory.getAbsolutePath());
        } else if (!sourceDirectory.isDirectory()) {
            this.getLogger().debug("Not a directory: " + sourceDirectory.getAbsolutePath());
        } else {
            this.getLogger().debug("Copying resources from " + sourceDirectory.getAbsolutePath());
            String excludes = this.concat(DirectoryScanner.DEFAULTEXCLUDES, ", ");
            this.copyDirectoryStructure(sourceDirectory, targetDirectory, "**", excludes);
        }
    }

    public void copyFile(File sourceFile, File targetFile) throws MojoExecutionException {
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy file " + sourceFile + " to " + targetFile, (Exception)e);
        }
    }

    public void copyDirectoryStructure(File sourceDirectory, File targetDirectory) throws MojoExecutionException {
        try {
            FileUtils.copyDirectoryStructure((File)sourceDirectory, (File)targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy directory structure from " + sourceDirectory + " to " + targetDirectory, (Exception)e);
        }
    }

    public boolean copyFileToDirectoryIfNecessary(File sourceFile, File targetDirectory) throws MojoExecutionException {
        boolean shouldCopy;
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile is null");
        }
        File targetFile = new File(targetDirectory, sourceFile.getName());
        boolean bl = shouldCopy = !targetFile.exists() || targetFile.lastModified() < sourceFile.lastModified();
        if (shouldCopy) {
            try {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)targetDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy file " + sourceFile + " to directory " + targetDirectory, (Exception)e);
            }
        } else {
            this.getLogger().debug("Source file hasn't changed. Do not overwrite " + targetFile + " with " + sourceFile + ".");
        }
        return shouldCopy;
    }

    public void removeDirectory(File dir) throws MojoExecutionException {
        if (dir != null && dir.exists() && dir.isDirectory()) {
            this.getLogger().debug("Deleting directory " + dir.getAbsolutePath());
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not delete directory: " + dir, (Exception)e);
            }
        }
    }

    public void makeDirectoryIfNecessary(File dir) throws MojoExecutionException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Failed to create directory: " + dir);
        }
    }

    public int deleteFiles(File directory, FileFilter fileFilter) throws MojoExecutionException {
        File[] files = directory.listFiles(fileFilter);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("deleteFiles in " + directory + " found " + files.length + " file(s) to delete");
        }
        if (files.length == 0) {
            return 0;
        }
        for (File file : files) {
            this.deleteFile(file);
        }
        return files.length;
    }

    public void deleteFile(File file) throws MojoExecutionException {
        if (file.exists() && !file.delete()) {
            throw new MojoExecutionException("Could not delete file: " + file);
        }
    }

    public void renameTo(File source, File target) throws MojoExecutionException {
        boolean result = source.renameTo(target);
        if (!result) {
            throw new MojoExecutionException("Could not rename " + source + " to " + target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResources(URI uri, ClassLoader classLoader, File target) throws MojoExecutionException {
        InputStream inputStream;
        URL url;
        String scheme = uri.getScheme();
        if ("classpath".equals(scheme)) {
            String path = uri.getPath();
            if (path == null) {
                path = uri.toString().substring(scheme.length() + 1);
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            url = classLoader.getResource(path);
        } else {
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Bad uri syntax " + uri, (Exception)e);
            }
        }
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not open resource " + url, (Exception)e);
        }
        if (inputStream == null) {
            throw new MojoExecutionException("Could not find resource " + url);
        }
        try {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(target);
                org.codehaus.plexus.util.IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                ((OutputStream)outputStream).close();
                inputStream.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy resource from " + url + " to " + target, (Exception)e);
            }
            finally {
                if (outputStream != null) {
                    org.codehaus.plexus.util.IOUtil.close((OutputStream)outputStream);
                }
            }
        }
        finally {
            org.codehaus.plexus.util.IOUtil.close((InputStream)inputStream);
        }
    }

    private void copyDirectoryStructure(File sourceDirectory, File destinationDirectory, String includes, String excludes) throws MojoExecutionException {
        if (!sourceDirectory.exists()) {
            return;
        }
        List files = null;
        try {
            files = FileUtils.getFiles((File)sourceDirectory, (String)includes, (String)excludes);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not obtain files from " + sourceDirectory, (Exception)e);
        }
        for (File file : files) {
            this.getLogger().debug("Copying " + file + " to " + destinationDirectory);
            String path = file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length() + 1);
            File destDir = new File(destinationDirectory, path);
            this.getLogger().debug("Copying " + file + " to " + destDir);
            if (file.isDirectory()) {
                this.makeDirectoryIfNecessary(destDir);
                continue;
            }
            try {
                FileUtils.copyFileToDirectory((File)file, (File)destDir.getParentFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy file " + file + " to directory" + destDir, (Exception)e);
            }
        }
    }

    private String concat(String[] array, String delim) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(delim);
            }
            String s = array[i];
            buffer.append(s).append(delim);
        }
        return buffer.toString();
    }
}

