/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.was6;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.was6.AbstractAppMojo;
import org.codehaus.mojo.was6.Role;
import org.dom4j.Document;

public class WsInstallAppMojo
extends AbstractAppMojo {
    private boolean updateExisting;
    private String targetCluster;
    private String targetCell;
    private String targetNode;
    private String targetServer;
    private File earFile;
    private List roles;

    protected String getTaskName() {
        return "wsInstallApp";
    }

    protected void configureBuildScript(Document document) throws MojoExecutionException {
        super.configureBuildScript(document);
        if (this.earFile == null) {
            throw new MojoExecutionException("Earfile not specified");
        }
        if (!this.earFile.canRead()) {
            throw new MojoExecutionException("Bad archive: " + this.earFile.getAbsolutePath());
        }
        this.configureTaskAttribute(document, "ear", this.earFile.getAbsolutePath());
        StringBuffer options = new StringBuffer();
        options.append("-appname ").append(this.applicationName);
        if (this.updateExisting) {
            options.append(" -update");
        }
        if (this.targetCluster != null) {
            options.append(" -cluster ").append(this.targetCluster);
        }
        if (this.targetCell != null) {
            options.append(" -cell ").append(this.targetCell);
        }
        if (this.targetNode != null) {
            options.append(" -node ").append(this.targetNode);
        }
        if (this.targetServer != null) {
            options.append(" -server ").append(this.targetServer);
        }
        if (this.roles != null) {
            options.append(" -MapRolesToUsers { ");
            Iterator iterator = this.roles.iterator();
            while (iterator.hasNext()) {
                Role role = (Role)iterator.next();
                options.append(role.getRoleMapping());
            }
            options.append(" } ");
        }
        this.configureTaskAttribute(document, "options", options);
    }
}

