/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.BuildFailureException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.MinimalMavenBuildVersionFinder;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.ordering.MavenVersionComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;

@Mojo(name="display-plugin-updates", requiresProject=true, requiresDirectInvocation=false, threadSafe=true)
public class DisplayPluginUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int WARN_PAD_SIZE = 65;
    private static final int INFO_PAD_SIZE = 68;
    private static final String FROM_SUPER_POM = "(from super-pom) ";
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Component
    private ModelInterpolator modelInterpolator;
    @Component
    private PluginManager pluginManager;
    @Component
    private RuntimeInformation runtimeInformation;

    private Map<String, String> getSuperPomPluginManagement() throws MojoExecutionException {
        HashMap<String, String> superPomPluginManagement;
        if (new DefaultArtifactVersion("3.0").compareTo(this.runtimeInformation.getApplicationVersion()) <= 0) {
            this.getLog().debug((CharSequence)"Using Maven 3.x strategy to determine superpom defined plugins");
            try {
                Method getPluginsBoundByDefaultToAllLifecycles = LifecycleExecutor.class.getMethod("getPluginsBoundByDefaultToAllLifecycles", String.class);
                Set plugins = (Set)getPluginsBoundByDefaultToAllLifecycles.invoke((Object)this.lifecycleExecutor, this.getProject().getPackaging());
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(plugins.size());
                for (Plugin plugin : plugins) {
                    result.put(plugin.getKey(), plugin.getVersion());
                }
                URL superPom = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/model/pom-4.0.0.xml");
                if (superPom != null) {
                    try (XmlStreamReader reader = ReaderFactory.newXmlReader((URL)superPom);){
                        StringBuilder buf = new StringBuilder(IOUtil.toString((Reader)reader));
                        ModifiedPomXMLEventReader pom = this.newModifiedPomXER(buf, superPom.toString());
                        Pattern pathRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
                        Stack<StackState> pathStack = new Stack<StackState>();
                        StackState curState = null;
                        while (pom.hasNext()) {
                            XMLEvent event = pom.nextEvent();
                            if (event.isStartDocument()) {
                                curState = new StackState("");
                                pathStack.clear();
                                continue;
                            }
                            if (event.isStartElement()) {
                                String elementName = event.asStartElement().getName().getLocalPart();
                                if (curState != null && pathRegex.matcher(curState.path).matches()) {
                                    if ("groupId".equals(elementName)) {
                                        curState.groupId = pom.getElementText().trim();
                                        continue;
                                    }
                                    if ("artifactId".equals(elementName)) {
                                        curState.artifactId = pom.getElementText().trim();
                                        continue;
                                    }
                                    if ("version".equals(elementName)) {
                                        curState.version = pom.getElementText().trim();
                                        continue;
                                    }
                                }
                                pathStack.push(curState);
                                curState = new StackState(curState.path + "/" + elementName);
                                continue;
                            }
                            if (!event.isEndElement()) continue;
                            if (curState != null && pathRegex.matcher(curState.path).matches() && curState.artifactId != null) {
                                Plugin plugin = new Plugin();
                                plugin.setArtifactId(curState.artifactId);
                                plugin.setGroupId(curState.groupId == null ? "org.apache.maven.plugins" : curState.groupId);
                                plugin.setVersion(curState.version);
                                if (!result.containsKey(plugin.getKey())) {
                                    result.put(plugin.getKey(), plugin.getVersion());
                                }
                            }
                            curState = (StackState)pathStack.pop();
                        }
                    }
                    catch (IOException | XMLStreamException exception) {
                        // empty catch block
                    }
                }
                return result;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException getPluginsBoundByDefaultToAllLifecycles) {
                // empty catch block
            }
        }
        this.getLog().debug((CharSequence)"Using Maven 2.x strategy to determine superpom defined plugins");
        try {
            MavenProject superProject = this.projectBuilder.buildStandaloneSuperProject((ProjectBuilderConfiguration)new DefaultProjectBuilderConfiguration());
            superPomPluginManagement = new HashMap<String, String>(this.getPluginManagement(superProject.getOriginalModel()));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not determine the super pom.xml", (Exception)((Object)e));
        }
        return superPomPluginManagement;
    }

    private Map<String, String> getPluginManagement(Model model) {
        HashMap<String, String> pluginManagement = new HashMap<String, String>();
        try {
            for (Plugin plugin : model.getBuild().getPluginManagement().getPlugins()) {
                String coord = plugin.getKey();
                String version = plugin.getVersion();
                if (version == null) continue;
                pluginManagement.put(coord, version);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (Profile profile : model.getProfiles()) {
                try {
                    for (Plugin plugin : profile.getBuild().getPluginManagement().getPlugins()) {
                        String coord = plugin.getKey();
                        String version = plugin.getVersion();
                        if (version == null) continue;
                        pluginManagement.put(coord, version);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return pluginManagement;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean noMavenMinVersion;
        Set<String> pluginsWithVersionsSpecified;
        this.logInit();
        try {
            pluginsWithVersionsSpecified = this.findPluginsWithVersionsSpecified(this.getProject());
        }
        catch (IOException | XMLStreamException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        Map<String, String> superPomPluginManagement = this.getSuperPomPluginManagement();
        this.getLog().debug((CharSequence)("superPom plugins = " + superPomPluginManagement));
        List<MavenProject> parents = this.getParentProjects(this.getProject());
        Map<String, String> parentPlugins = this.getParentsPlugins(parents);
        HashMap<String, String> parentBuildPlugins = new HashMap<String, String>();
        HashMap<String, String> parentReportPlugins = new HashMap<String, String>();
        Set<Plugin> plugins = this.getProjectPlugins(superPomPluginManagement, parentPlugins, parentBuildPlugins, parentReportPlugins, pluginsWithVersionsSpecified);
        ArrayList<String> pluginUpdates = new ArrayList<String>();
        ArrayList<String> pluginLockdowns = new ArrayList<String>();
        ArtifactVersion curMavenVersion = this.runtimeInformation.getApplicationVersion();
        ArtifactVersion specMavenVersion = MinimalMavenBuildVersionFinder.find(this.getProject(), "2.0", this.getLog());
        ArtifactVersion minMavenVersion = null;
        boolean superPomDrivingMinVersion = false;
        TreeMap<ArtifactVersion, Map> mavenUpgrades = new TreeMap<ArtifactVersion, Map>(new MavenVersionComparator());
        for (Plugin plugin : plugins) {
            String newVersion;
            Object artifactVersion;
            String effectiveVersion;
            String coords;
            String version;
            String artifactId;
            String groupId;
            block44: {
                Artifact artifactRange;
                groupId = plugin.getGroupId();
                artifactId = plugin.getArtifactId();
                version = plugin.getVersion();
                coords = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
                if (version == null) {
                    version = parentPlugins.get(coords);
                }
                this.getLog().debug((CharSequence)("Checking " + coords + " for updates newer than " + version));
                effectiveVersion = version;
                try {
                    boolean unspecified = version == null;
                    VersionRange versionRange = unspecified ? VersionRange.createFromVersionSpec((String)"[0,)") : VersionRange.createFromVersionSpec((String)version);
                    artifactRange = this.artifactFactory.createPluginArtifact(groupId, artifactId, versionRange);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new MojoExecutionException("Invalid version range specification: " + version, (Exception)((Object)e));
                }
                artifactVersion = null;
                try {
                    Artifact probe;
                    ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifactRange, true);
                    ArtifactVersion[] newerVersions = artifactVersions.getVersions(this.allowSnapshots);
                    ArtifactVersion minRequires = null;
                    for (int j = newerVersions.length - 1; j >= 0; --j) {
                        probe = this.artifactFactory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion((String)newerVersions[j].toString()), "pom", null, "runtime");
                        try {
                            String upgradePluginKey;
                            this.getHelper().resolveArtifact(probe, true);
                            MavenProject pluginMavenProject = this.projectBuilder.buildFromRepository(probe, this.remotePluginRepositories, this.localRepository);
                            ArtifactVersion pluginRequires = this.getPrerequisitesMavenVersion(pluginMavenProject);
                            if (artifactVersion == null && DisplayPluginUpdatesMojo.compare(specMavenVersion, pluginRequires) >= 0) {
                                artifactVersion = newerVersions[j];
                            }
                            if (effectiveVersion == null && DisplayPluginUpdatesMojo.compare(curMavenVersion, pluginRequires) >= 0) {
                                effectiveVersion = newerVersions[j].toString();
                            }
                            if (artifactVersion != null && effectiveVersion != null) break;
                            if (minRequires != null && DisplayPluginUpdatesMojo.compare(minRequires, pluginRequires) <= 0) continue;
                            Map upgradePlugins = mavenUpgrades.computeIfAbsent(pluginRequires, k -> new LinkedHashMap());
                            if (!upgradePlugins.containsKey(upgradePluginKey = this.compactKey(groupId, artifactId))) {
                                String newer = newerVersions[j].toString();
                                if (newer.equals(effectiveVersion)) {
                                    upgradePlugins.put(upgradePluginKey, DisplayPluginUpdatesMojo.pad(upgradePluginKey, 68, newer));
                                } else {
                                    upgradePlugins.put(upgradePluginKey, DisplayPluginUpdatesMojo.pad(upgradePluginKey, 68, effectiveVersion, " -> ", newer));
                                }
                            }
                            minRequires = pluginRequires;
                            continue;
                        }
                        catch (ArtifactNotFoundException | ArtifactResolutionException | ProjectBuildingException pluginMavenProject) {
                            // empty catch block
                        }
                    }
                    if (effectiveVersion == null) break block44;
                    VersionRange currentVersionRange = VersionRange.createFromVersion((String)effectiveVersion);
                    probe = this.artifactFactory.createDependencyArtifact(groupId, artifactId, currentVersionRange, "pom", null, "runtime");
                    try {
                        this.getHelper().resolveArtifact(probe, true);
                        MavenProject mavenProject = this.projectBuilder.buildFromRepository(probe, this.remotePluginRepositories, this.localRepository);
                        ArtifactVersion requires = this.getPrerequisitesMavenVersion(mavenProject);
                        if (minMavenVersion == null || DisplayPluginUpdatesMojo.compare(minMavenVersion, requires) < 0) {
                            minMavenVersion = requires;
                        }
                    }
                    catch (ArtifactNotFoundException | ArtifactResolutionException | ProjectBuildingException throwable) {}
                }
                catch (ArtifactMetadataRetrievalException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
            if (version == null && pluginsWithVersionsSpecified.contains(coords)) {
                version = artifactVersion != null ? artifactVersion.toString() : null;
            }
            this.getLog().debug((CharSequence)("[" + coords + "].version=" + version));
            this.getLog().debug((CharSequence)("[" + coords + "].artifactVersion=" + artifactVersion));
            this.getLog().debug((CharSequence)("[" + coords + "].effectiveVersion=" + effectiveVersion));
            this.getLog().debug((CharSequence)("[" + coords + "].specified=" + pluginsWithVersionsSpecified.contains(coords)));
            if (version == null || !pluginsWithVersionsSpecified.contains(coords)) {
                version = superPomPluginManagement.get(coords);
                this.getLog().debug((CharSequence)("[" + coords + "].superPom.version=" + version));
                String string = artifactVersion != null ? artifactVersion.toString() : (version != null ? version : (newVersion = effectiveVersion != null ? effectiveVersion : "(unknown)"));
                if (version != null) {
                    superPomDrivingMinVersion = true;
                }
                pluginLockdowns.add(DisplayPluginUpdatesMojo.pad(this.compactKey(groupId, artifactId), 65, superPomDrivingMinVersion ? FROM_SUPER_POM : "", newVersion));
            } else {
                newVersion = artifactVersion != null ? artifactVersion.toString() : null;
            }
            if (version == null || artifactVersion == null || newVersion == null || effectiveVersion == null || new DefaultArtifactVersion(effectiveVersion).compareTo((ArtifactVersion)new DefaultArtifactVersion(newVersion)) >= 0) continue;
            pluginUpdates.add(DisplayPluginUpdatesMojo.pad(this.compactKey(groupId, artifactId), 68, effectiveVersion, " -> ", newVersion));
        }
        this.logLine(false, "");
        if (pluginUpdates.isEmpty()) {
            this.logLine(false, "All plugins with a version specified are using the latest versions.");
        } else {
            this.logLine(false, "The following plugin updates are available:");
            for (String update : new TreeSet(pluginUpdates)) {
                this.logLine(false, update);
            }
        }
        this.logLine(false, "");
        if (pluginLockdowns.isEmpty()) {
            this.logLine(false, "All plugins have a version specified.");
        } else {
            this.getLog().warn((CharSequence)"The following plugins do not have their version specified:");
            for (String lockdown : new TreeSet(pluginLockdowns)) {
                this.getLog().warn((CharSequence)lockdown);
            }
        }
        this.logLine(false, "");
        boolean bl = noMavenMinVersion = MinimalMavenBuildVersionFinder.find(this.getProject(), null, this.getLog()) == null;
        if (noMavenMinVersion) {
            this.getLog().warn((CharSequence)"Project does not define minimum Maven version required for build, default is: 2.0");
        } else {
            this.logLine(false, "Project requires minimum Maven version for build of: " + specMavenVersion);
        }
        this.logLine(false, "Plugins require minimum Maven version of: " + minMavenVersion);
        if (superPomDrivingMinVersion) {
            this.logLine(false, "Note: the super-pom from Maven " + curMavenVersion + " defines some of the plugin");
            this.logLine(false, "      versions and may be influencing the plugins required minimum Maven");
            this.logLine(false, "      version.");
        }
        this.logLine(false, "");
        if (this.isMavenPluginProject()) {
            if (noMavenMinVersion) {
                this.getLog().warn((CharSequence)"Project (which is a Maven plugin) does not define required minimum version of Maven.");
                this.getLog().warn((CharSequence)"Update the pom.xml to contain");
                this.getLog().warn((CharSequence)"    <prerequisites>");
                this.getLog().warn((CharSequence)"      <maven><!-- minimum version of Maven that the plugin works with --></maven>");
                this.getLog().warn((CharSequence)"    </prerequisites>");
                this.getLog().warn((CharSequence)("To build this plugin you need at least Maven " + minMavenVersion));
                this.getLog().warn((CharSequence)"A Maven Enforcer rule can be used to enforce this if you have not already set one up");
                this.getLog().warn((CharSequence)"See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            } else if (minMavenVersion != null && DisplayPluginUpdatesMojo.compare(specMavenVersion, minMavenVersion) < 0) {
                this.getLog().warn((CharSequence)("Project (which is a Maven plugin) targets Maven " + specMavenVersion + " or newer"));
                this.getLog().warn((CharSequence)("but requires Maven " + minMavenVersion + " or newer to build."));
                this.getLog().warn((CharSequence)"This may or may not be a problem. A Maven Enforcer rule can help ");
                this.getLog().warn((CharSequence)"enforce that the correct version of Maven is used to build this plugin.");
                this.getLog().warn((CharSequence)"See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            } else {
                this.logLine(false, "No plugins require a newer version of Maven than specified by the pom.");
            }
        } else if (noMavenMinVersion) {
            this.logLine(true, "Project does not define required minimum version of Maven.");
            this.logLine(true, "Update the pom.xml to contain maven-enforcer-plugin to");
            this.logLine(true, "force the Maven version which is needed to build this project.");
            this.logLine(true, "See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            this.logLine(true, "Using the minimum version of Maven: " + minMavenVersion);
        } else if (minMavenVersion != null && DisplayPluginUpdatesMojo.compare(specMavenVersion, minMavenVersion) < 0) {
            this.logLine(true, "Project requires an incorrect minimum version of Maven.");
            this.logLine(true, "Update the pom.xml to contain maven-enforcer-plugin to");
            this.logLine(true, "force the Maven version which is needed to build this project.");
            this.logLine(true, "See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            this.logLine(true, "Using the minimum version of Maven: " + specMavenVersion);
        } else {
            this.logLine(false, "No plugins require a newer version of Maven than specified by the pom.");
        }
        for (Map.Entry mavenUpgrade : mavenUpgrades.entrySet()) {
            ArtifactVersion mavenUpgradeVersion = (ArtifactVersion)mavenUpgrade.getKey();
            Map upgradePlugins = (Map)mavenUpgrade.getValue();
            if (upgradePlugins.isEmpty() || DisplayPluginUpdatesMojo.compare(specMavenVersion, mavenUpgradeVersion) >= 0) continue;
            this.logLine(false, "");
            this.logLine(false, "Require Maven " + mavenUpgradeVersion + " to use the following plugin updates:");
            for (Map.Entry entry : upgradePlugins.entrySet()) {
                this.logLine(false, (String)entry.getValue());
            }
        }
        this.logLine(false, "");
    }

    private static String pad(String start, int len, String ... ends) {
        StringBuilder buf = new StringBuilder(len);
        buf.append("  ");
        buf.append(start);
        int padding = len;
        for (String end : ends) {
            padding -= end.length();
        }
        buf.append(' ');
        while (buf.length() < padding) {
            buf.append('.');
        }
        buf.append(' ');
        for (String end : ends) {
            buf.append(end);
        }
        return buf.toString();
    }

    private Map<String, String> getParentsPlugins(List<MavenProject> parents) throws MojoExecutionException {
        HashMap<String, String> parentPlugins = new HashMap<String, String>();
        for (MavenProject parentProject : parents) {
            Model interpolatedModel;
            this.getLog().debug((CharSequence)("Processing parent: " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " -> " + parentProject.getFile()));
            StringWriter writer = new StringWriter();
            boolean havePom = false;
            try {
                Model originalModel = parentProject.getOriginalModel();
                if (originalModel == null) {
                    this.getLog().warn((CharSequence)("project.getOriginalModel()==null for  " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " is null, substituting project.getModel()"));
                    originalModel = parentProject.getModel();
                }
                try {
                    new MavenXpp3Writer().write((Writer)writer, originalModel);
                    writer.close();
                    havePom = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                interpolatedModel = this.modelInterpolator.interpolate(originalModel, null, new DefaultProjectBuilderConfiguration().setExecutionProperties(this.getProject().getProperties()), false);
            }
            catch (ModelInterpolationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (havePom) {
                try {
                    Set<String> withVersionSpecified = this.findPluginsWithVersionsSpecified(new StringBuilder(writer.toString()), this.getSafeProjectPathInfo(parentProject));
                    Map<String, String> map = this.getPluginManagement(interpolatedModel);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPlugins.putAll(map);
                    map = this.getBuildPlugins(interpolatedModel, true);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPlugins.putAll(map);
                    map = this.getReportPlugins(interpolatedModel, true);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPlugins.putAll(map);
                    continue;
                }
                catch (IOException | XMLStreamException e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            parentPlugins.putAll(this.getPluginManagement(interpolatedModel));
            parentPlugins.putAll(this.getBuildPlugins(interpolatedModel, true));
            parentPlugins.putAll(this.getReportPlugins(interpolatedModel, true));
        }
        return parentPlugins;
    }

    private String getSafeProjectPathInfo(MavenProject project) {
        File file = project.getFile();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return project.toString();
    }

    private boolean isMavenPluginProject() {
        return "maven-plugin".equals(this.getProject().getPackaging());
    }

    private String compactKey(String groupId, String artifactId) {
        if ("org.apache.maven.plugins".equals(groupId)) {
            return artifactId;
        }
        return groupId + ":" + artifactId;
    }

    private Set<String> findPluginsWithVersionsSpecified(MavenProject project) throws IOException, XMLStreamException {
        return this.findPluginsWithVersionsSpecified(PomHelper.readXmlFile(project.getFile()), this.getSafeProjectPathInfo(project));
    }

    private Set<String> findPluginsWithVersionsSpecified(StringBuilder pomContents, String path) throws IOException, XMLStreamException {
        HashSet<String> result = new HashSet<String>();
        ModifiedPomXMLEventReader pom = this.newModifiedPomXER(pomContents, path);
        Pattern pathRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
        Stack<StackState> pathStack = new Stack<StackState>();
        StackState curState = null;
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartDocument()) {
                curState = new StackState("");
                pathStack.clear();
                continue;
            }
            if (event.isStartElement()) {
                String elementName = event.asStartElement().getName().getLocalPart();
                if (curState != null && pathRegex.matcher(curState.path).matches()) {
                    if ("groupId".equals(elementName)) {
                        curState.groupId = pom.getElementText().trim();
                        continue;
                    }
                    if ("artifactId".equals(elementName)) {
                        curState.artifactId = pom.getElementText().trim();
                        continue;
                    }
                    if ("version".equals(elementName)) {
                        curState.version = pom.getElementText().trim();
                        continue;
                    }
                }
                pathStack.push(curState);
                curState = new StackState(curState.path + "/" + elementName);
                continue;
            }
            if (!event.isEndElement()) continue;
            if (curState != null && pathRegex.matcher(curState.path).matches() && curState.artifactId != null && curState.version != null) {
                if (curState.groupId == null) {
                    curState.groupId = "org.apache.maven.plugins";
                }
                result.add(curState.groupId + ":" + curState.artifactId);
            }
            curState = (StackState)pathStack.pop();
        }
        return result;
    }

    private ArtifactVersion getPrerequisitesMavenVersion(MavenProject pluginProject) {
        Prerequisites prerequisites = pluginProject.getPrerequisites();
        if (null == prerequisites) {
            return new DefaultArtifactVersion("2.0");
        }
        String prerequisitesMavenValue = prerequisites.getMaven();
        if (null == prerequisitesMavenValue) {
            return new DefaultArtifactVersion("2.0");
        }
        return new DefaultArtifactVersion(prerequisitesMavenValue);
    }

    private Map<String, String> getBuildPlugins(Model model, boolean onlyIncludeInherited) {
        HashMap<String, String> buildPlugins = new HashMap<String, String>();
        try {
            for (Plugin plugin : model.getBuild().getPlugins()) {
                String coord = plugin.getKey();
                String version = plugin.getVersion();
                if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                buildPlugins.put(coord, version);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (Profile profile : model.getProfiles()) {
                try {
                    for (Plugin plugin : profile.getBuild().getPlugins()) {
                        String coord = plugin.getKey();
                        String version = plugin.getVersion();
                        if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                        buildPlugins.put(coord, version);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return buildPlugins;
    }

    private static boolean getPluginInherited(Object plugin) {
        return "true".equalsIgnoreCase(plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getInherited() : ((Plugin)plugin).getInherited());
    }

    private Map<String, Plugin> getLifecyclePlugins(MavenProject project) throws MojoExecutionException {
        HashMap<String, Plugin> lifecyclePlugins = new HashMap<String, Plugin>();
        try {
            Set<Plugin> plugins = this.getBoundPlugins(project, "clean,deploy,site");
            for (Plugin plugin : plugins) {
                lifecyclePlugins.put(plugin.getKey(), plugin);
            }
        }
        catch (PluginNotFoundException e) {
            throw new MojoExecutionException("Could not find plugin", (Exception)((Object)e));
        }
        catch (LifecycleExecutionException e) {
            throw new MojoExecutionException("Could not determine lifecycle", (Exception)((Object)e));
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Could not determine lifecycles", (Exception)e);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return lifecyclePlugins;
    }

    private Set<Plugin> getBoundPlugins(MavenProject project, String thePhases) throws PluginNotFoundException, LifecycleExecutionException, IllegalAccessException {
        if (new DefaultArtifactVersion("3.0").compareTo(this.runtimeInformation.getApplicationVersion()) <= 0) {
            this.getLog().debug((CharSequence)"Using Maven 3.0+ strategy to determine lifecycle defined plugins");
            try {
                Method getPluginsBoundByDefaultToAllLifecycles = LifecycleExecutor.class.getMethod("getPluginsBoundByDefaultToAllLifecycles", String.class);
                Set plugins = (Set)getPluginsBoundByDefaultToAllLifecycles.invoke((Object)this.lifecycleExecutor, project.getPackaging() == null ? "jar" : project.getPackaging());
                LinkedHashSet<Plugin> result = new LinkedHashSet<Plugin>(plugins.size());
                for (Plugin plugin : plugins) {
                    Plugin dup = new Plugin();
                    dup.setGroupId(plugin.getGroupId());
                    dup.setArtifactId(plugin.getArtifactId());
                    result.add(dup);
                }
                return result;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException getPluginsBoundByDefaultToAllLifecycles) {
                // empty catch block
            }
        }
        List lifecycles = null;
        this.getLog().debug((CharSequence)"Using Maven 2.0.10+ strategy to determine lifecycle defined plugins");
        try {
            Method getLifecycles = LifecycleExecutor.class.getMethod("getLifecycles", new Class[0]);
            lifecycles = (List)getLifecycles.invoke((Object)this.lifecycleExecutor, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException getLifecycles) {
            // empty catch block
        }
        HashSet<Plugin> allPlugins = new HashSet<Plugin>();
        for (String lifecyclePhase : thePhases.split(",")) {
            if (!StringUtils.isNotEmpty((String)lifecyclePhase)) continue;
            try {
                Lifecycle lifecycle = this.getLifecycleForPhase(lifecycles, lifecyclePhase);
                allPlugins.addAll(this.getAllPlugins(project, lifecycle));
            }
            catch (BuildFailureException buildFailureException) {
                // empty catch block
            }
        }
        return allPlugins;
    }

    private Lifecycle getLifecycleForPhase(List<Lifecycle> lifecycles, String phase) throws BuildFailureException, LifecycleExecutionException {
        Lifecycle lifecycle = this.getPhaseToLifecycleMap(lifecycles).get(phase);
        if (lifecycle == null) {
            throw new BuildFailureException("Unable to find lifecycle for phase '" + phase + "'");
        }
        return lifecycle;
    }

    private Set<Plugin> getAllPlugins(MavenProject project, Lifecycle lifecycle) throws PluginNotFoundException, LifecycleExecutionException {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        Map<?, ?> mappings = this.findMappingsForLifecycle(project, lifecycle);
        for (Map.Entry<?, ?> entry : mappings.entrySet()) {
            String value = (String)entry.getValue();
            String[] tokens = value.split(":");
            Plugin plugin = new Plugin();
            plugin.setGroupId(tokens[0]);
            plugin.setArtifactId(tokens[1]);
            plugins.add(plugin);
        }
        for (String value : this.findOptionalMojosForLifecycle(project, lifecycle)) {
            String[] tokens = value.split(":");
            Plugin plugin = new Plugin();
            plugin.setGroupId(tokens[0]);
            plugin.setArtifactId(tokens[1]);
            plugins.add(plugin);
        }
        plugins.addAll(project.getBuildPlugins());
        return plugins;
    }

    private Map<?, ?> findMappingsForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        Map defaultMappings;
        Map mappings;
        String packaging;
        block6: {
            packaging = project.getPackaging();
            mappings = null;
            LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
            if (m != null) {
                mappings = m.getPhases(lifecycle.getId());
            }
            defaultMappings = lifecycle.getDefaultPhases();
            if (mappings == null) {
                try {
                    m = (LifecycleMapping)this.session.lookup(LifecycleMapping.ROLE, packaging);
                    mappings = m.getPhases(lifecycle.getId());
                }
                catch (ComponentLookupException e) {
                    if (defaultMappings != null) break block6;
                    throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "'.", (Throwable)e);
                }
            }
        }
        if (mappings == null) {
            if (defaultMappings == null) {
                throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "', and there is no default");
            }
            mappings = defaultMappings;
        }
        return mappings;
    }

    private List<String> findOptionalMojosForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        String packaging = project.getPackaging();
        List optionalMojos = null;
        LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
        if (m != null) {
            optionalMojos = m.getOptionalMojos(lifecycle.getId());
        }
        if (optionalMojos == null) {
            try {
                m = (LifecycleMapping)this.session.lookup(LifecycleMapping.ROLE, packaging);
                optionalMojos = m.getOptionalMojos(lifecycle.getId());
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)("Error looking up lifecycle mapping to retrieve optional mojos. Lifecycle ID: " + lifecycle.getId() + ". Error: " + e.getMessage()), (Throwable)e);
            }
        }
        if (optionalMojos == null) {
            optionalMojos = Collections.emptyList();
        }
        return optionalMojos;
    }

    private Object findExtension(MavenProject project, String role, String roleHint, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        Object pluginComponent = null;
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext() && pluginComponent == null) {
            Plugin plugin = (Plugin)i.next();
            if (!plugin.isExtensions()) continue;
            this.loadPluginDescriptor(plugin, project, this.session);
            try {
                pluginComponent = this.pluginManager.getPluginComponent(plugin, role, roleHint);
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)"Unable to find the lifecycle component in the extension", (Throwable)e);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Error getting extensions from the plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return pluginComponent;
    }

    private PluginDescriptor loadPluginDescriptor(Plugin plugin, MavenProject project, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.loadPluginDescriptor(plugin, project, session);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException | InvalidVersionSpecificationException | InvalidPluginException | PluginVersionNotFoundException | PluginVersionResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        return pluginDescriptor;
    }

    private List<MavenProject> getParentProjects(MavenProject project) throws MojoExecutionException {
        ArrayList<MavenProject> parents = new ArrayList<MavenProject>();
        while (project.getParent() != null) {
            project = project.getParent();
            parents.add(0, project);
        }
        return parents;
    }

    public Map<String, Lifecycle> getPhaseToLifecycleMap(List<Lifecycle> lifecycles) throws LifecycleExecutionException {
        HashMap<String, Lifecycle> phaseToLifecycleMap = new HashMap<String, Lifecycle>();
        for (Lifecycle lifecycle : lifecycles) {
            for (String phase : lifecycle.getPhases()) {
                if (phaseToLifecycleMap.containsKey(phase)) {
                    Lifecycle prevLifecycle = (Lifecycle)phaseToLifecycleMap.get(phase);
                    throw new LifecycleExecutionException("Phase '" + phase + "' is defined in more than one lifecycle: '" + lifecycle.getId() + "' and '" + prevLifecycle.getId() + "'");
                }
                phaseToLifecycleMap.put(phase, lifecycle);
            }
        }
        return phaseToLifecycleMap;
    }

    private Set<Plugin> getProjectPlugins(Map<String, String> superPomPluginManagement, Map<String, String> parentPluginManagement, Map<String, String> parentBuildPlugins, Map<String, String> parentReportPlugins, Set<String> pluginsWithVersionsSpecified) throws MojoExecutionException {
        String parentVersion;
        Iterator i;
        Model originalModel;
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        this.getLog().debug((CharSequence)"Building list of project plugins...");
        if (this.getLog().isDebugEnabled()) {
            StringWriter origModel = new StringWriter();
            try {
                origModel.write("Original model:\n");
                this.getProject().writeOriginalModel((Writer)origModel);
                this.getLog().debug((CharSequence)origModel.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.debugVersionMap("super-pom version map", superPomPluginManagement);
        this.debugVersionMap("parent version map", parentPluginManagement);
        HashMap<String, String> excludePluginManagement = new HashMap<String, String>(superPomPluginManagement);
        excludePluginManagement.putAll(parentPluginManagement);
        this.debugVersionMap("aggregate version map", excludePluginManagement);
        excludePluginManagement.keySet().removeAll(pluginsWithVersionsSpecified);
        this.debugVersionMap("final aggregate version map", excludePluginManagement);
        try {
            originalModel = this.modelInterpolator.interpolate(this.getProject().getOriginalModel(), this.getProject().getBasedir(), new DefaultProjectBuilderConfiguration().setExecutionProperties(this.getProject().getProperties()), true);
        }
        catch (ModelInterpolationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        try {
            this.addProjectPlugins(plugins, originalModel.getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.debugPluginMap("after adding local pluginManagement", plugins);
        try {
            ArrayList<Plugin> lifecyclePlugins = new ArrayList<Plugin>(this.getLifecyclePlugins(this.getProject()).values());
            i = lifecyclePlugins.iterator();
            while (i.hasNext()) {
                Plugin lifecyclePlugin = (Plugin)i.next();
                if (lifecyclePlugin.getVersion() != null) {
                    i.remove();
                    continue;
                }
                parentVersion = parentPluginManagement.get(lifecyclePlugin.getKey());
                if (parentVersion == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, lifecyclePlugins, parentPluginManagement);
            this.debugPluginMap("after adding lifecycle plugins", plugins);
        }
        catch (NullPointerException lifecyclePlugins) {
            // empty catch block
        }
        try {
            ArrayList<Plugin> buildPlugins = new ArrayList<Plugin>(originalModel.getBuild().getPlugins());
            i = buildPlugins.iterator();
            while (i.hasNext()) {
                Plugin buildPlugin = (Plugin)i.next();
                if (buildPlugin.getVersion() != null || (parentVersion = parentPluginManagement.get(buildPlugin.getKey())) == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, buildPlugins, parentBuildPlugins);
        }
        catch (NullPointerException buildPlugins) {
            // empty catch block
        }
        this.debugPluginMap("after adding build plugins", plugins);
        try {
            ArrayList reportPlugins = new ArrayList(originalModel.getReporting().getPlugins());
            i = reportPlugins.iterator();
            while (i.hasNext()) {
                ReportPlugin reportPlugin = (ReportPlugin)i.next();
                if (reportPlugin.getVersion() != null || (parentVersion = parentPluginManagement.get(reportPlugin.getKey())) == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, DisplayPluginUpdatesMojo.toPlugins(reportPlugins), parentReportPlugins);
        }
        catch (NullPointerException reportPlugins) {
            // empty catch block
        }
        this.debugPluginMap("after adding reporting plugins", plugins);
        for (Profile profile : originalModel.getProfiles()) {
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.debugPluginMap("after adding build pluginManagement for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPlugins(), parentBuildPlugins);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.debugPluginMap("after adding build plugins for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, DisplayPluginUpdatesMojo.toPlugins(profile.getReporting().getPlugins()), parentReportPlugins);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.debugPluginMap("after adding reporting plugins for profile " + profile.getId(), plugins);
        }
        TreeSet<Object> result = new TreeSet<Object>(new PluginComparator());
        result.addAll(plugins.values());
        return result;
    }

    private void addProjectPlugins(Map<String, Plugin> plugins, Collection<Plugin> projectPlugins, Map<String, String> parentDefinitions) {
        for (Plugin plugin : projectPlugins) {
            String coord = plugin.getKey();
            String version = plugin.getVersion();
            String parentVersion = parentDefinitions.get(coord);
            if (!(version != null || plugins.containsKey(coord) && plugins.get(coord).getVersion() != null || parentVersion == null)) {
                Plugin parentPlugin = new Plugin();
                parentPlugin.setGroupId(plugin.getGroupId());
                parentPlugin.setArtifactId(plugin.getArtifactId());
                parentPlugin.setVersion(parentVersion);
                plugins.put(coord, parentPlugin);
            } else if (!(parentVersion != null && parentVersion.equals(version) || plugins.containsKey(coord) && plugins.get(coord).getVersion() != null)) {
                plugins.put(coord, plugin);
            }
            if (plugins.containsKey(coord)) continue;
            plugins.put(coord, plugin);
        }
    }

    private void debugPluginMap(String description, Map<String, Plugin> plugins) {
        if (this.getLog().isDebugEnabled()) {
            TreeSet<Object> sorted = new TreeSet<Object>(new PluginComparator());
            sorted.addAll(plugins.values());
            StringBuilder buf = new StringBuilder(description);
            for (Plugin plugin : sorted) {
                buf.append("\n    ");
                buf.append(plugin.getKey());
                buf.append(":");
                buf.append(plugin.getVersion());
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private void debugVersionMap(String description, Map<String, String> pluginVersions) {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(description);
            for (Map.Entry<String, String> pluginVersion : pluginVersions.entrySet()) {
                buf.append("\n    ");
                buf.append(pluginVersion.getKey());
                buf.append(":");
                buf.append(pluginVersion.getValue());
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private static Plugin toPlugin(ReportPlugin reportPlugin) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        plugin.setVersion(reportPlugin.getVersion());
        return plugin;
    }

    private static List<Plugin> toPlugins(List<ReportPlugin> reportPlugins) {
        ArrayList<Plugin> result = new ArrayList<Plugin>(reportPlugins.size());
        for (ReportPlugin reportPlugin : reportPlugins) {
            result.add(DisplayPluginUpdatesMojo.toPlugin(reportPlugin));
        }
        return result;
    }

    private Map<String, String> getReportPlugins(Model model, boolean onlyIncludeInherited) {
        HashMap<String, String> reportPlugins = new HashMap<String, String>();
        try {
            for (ReportPlugin plugin : model.getReporting().getPlugins()) {
                String coord = plugin.getKey();
                String version = plugin.getVersion();
                if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                reportPlugins.put(coord, version);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (Profile profile : model.getProfiles()) {
                try {
                    for (ReportPlugin plugin : profile.getReporting().getPlugins()) {
                        String coord = plugin.getKey();
                        String version = plugin.getVersion();
                        if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                        reportPlugins.put(coord, version);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return reportPlugins;
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
    }

    private static int compare(ArtifactVersion a, ArtifactVersion b) {
        return a.compareTo((Object)b);
    }

    private static final class StackState {
        private final String path;
        private String groupId;
        private String artifactId;
        private String version;

        public StackState(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path + "[groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
        }
    }
}

