/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.DefaultArtifactAssociation;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.ordering.VersionComparator;

class PropertyVersionsBuilder {
    private final String name;
    private final String profileId;
    private final Set associations;
    private final VersionsHelper helper;
    private final Map upperBounds = new LinkedHashMap();
    private final Map lowerBounds = new LinkedHashMap();
    static /* synthetic */ Class class$org$codehaus$mojo$versions$api$PropertyVersionsBuilder;

    public PropertyVersionsBuilder(String profileId, String name, VersionsHelper helper) {
        this.profileId = profileId;
        this.name = name;
        this.associations = new TreeSet();
        this.helper = helper;
    }

    public void addAssociation(Artifact artifact, boolean usePluginRepositories) {
        this.associations.add(new DefaultArtifactAssociation(artifact, usePluginRepositories));
    }

    public void removeAssociation(Artifact artifact, boolean usePluginRepositories) {
        this.associations.remove(new DefaultArtifactAssociation(artifact, usePluginRepositories));
    }

    public void clearAssociations() {
        this.associations.clear();
    }

    public boolean isAssociated() {
        return !this.associations.isEmpty();
    }

    public ArtifactAssociation[] getAssociations() {
        return this.associations.toArray(new ArtifactAssociation[this.associations.size()]);
    }

    public PropertyVersions newPropertyVersions() throws ArtifactMetadataRetrievalException {
        return new PropertyVersions(this.profileId, this.name, this.helper, this.associations);
    }

    public String getName() {
        return this.name;
    }

    public String getVersionRange() {
        PropertyVersionComparator comparator = new PropertyVersionComparator();
        if (this.lowerBounds.isEmpty() && this.upperBounds.isEmpty()) {
            return null;
        }
        ArtifactVersion lowerBound = null;
        boolean includeLower = true;
        Iterator i = this.lowerBounds.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ArtifactVersion candidate = this.helper.createArtifactVersion((String)entry.getKey());
            if (lowerBound == null) {
                lowerBound = candidate;
                includeLower = (Boolean)entry.getValue();
                continue;
            }
            int result = comparator.compare(lowerBound, candidate);
            if (result > 0) {
                lowerBound = candidate;
                includeLower = (Boolean)entry.getValue();
                continue;
            }
            if (result != 0) continue;
            includeLower = includeLower && (Boolean)entry.getValue() != false;
        }
        ArtifactVersion upperBound = null;
        boolean includeUpper = true;
        i = this.upperBounds.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ArtifactVersion candidate = this.helper.createArtifactVersion((String)entry.getKey());
            if (upperBound == null) {
                upperBound = candidate;
                includeUpper = (Boolean)entry.getValue();
                continue;
            }
            int result = comparator.compare(upperBound, candidate);
            if (result < 0) {
                upperBound = candidate;
                includeUpper = (Boolean)entry.getValue();
                continue;
            }
            if (result != 0) continue;
            includeUpper = includeUpper && (Boolean)entry.getValue() != false;
        }
        StringBuffer buf = new StringBuffer();
        if (includeLower) {
            buf.append('[');
        } else {
            buf.append('(');
        }
        if (lowerBound != null) {
            buf.append(lowerBound);
        }
        buf.append(',');
        if (upperBound != null) {
            buf.append(upperBound);
        }
        if (includeUpper) {
            buf.append(']');
        } else {
            buf.append(')');
        }
        return buf.toString();
    }

    public void addLowerBound(String lowerBound, boolean includeLower) {
        Boolean value = (Boolean)this.lowerBounds.get(lowerBound);
        value = value == null ? Boolean.valueOf(includeLower) : Boolean.valueOf(includeLower && value != false);
        this.lowerBounds.put(lowerBound, value);
    }

    public void addUpperBound(String upperBound, boolean includeUpper) {
        Boolean value = (Boolean)this.upperBounds.get(upperBound);
        value = value == null ? Boolean.valueOf(includeUpper) : Boolean.valueOf(includeUpper && value != false);
        this.upperBounds.put(upperBound, value);
    }

    private VersionComparator[] lookupComparators() {
        HashSet<VersionComparator> result = new HashSet<VersionComparator>();
        Iterator i = this.associations.iterator();
        while (i.hasNext()) {
            ArtifactAssociation association = (ArtifactAssociation)i.next();
            result.add(this.helper.getVersionComparator(association.getArtifact()));
        }
        return result.toArray(new VersionComparator[result.size()]);
    }

    private final class PropertyVersionComparator
    implements Comparator {
        static final /* synthetic */ boolean $assertionsDisabled;

        private PropertyVersionComparator() {
        }

        public int compare(ArtifactVersion v1, ArtifactVersion v2) {
            return this.innerCompare(v1, v2);
        }

        private int innerCompare(ArtifactVersion v1, ArtifactVersion v2) {
            if (!PropertyVersionsBuilder.this.isAssociated()) {
                throw new IllegalStateException("Cannot compare versions for a property with no associations");
            }
            VersionComparator[] comparators = PropertyVersionsBuilder.this.lookupComparators();
            if (!$assertionsDisabled && comparators.length < 1) {
                throw new AssertionError((Object)"we have at least one association => at least one comparator");
            }
            int result = comparators[0].compare(v1, v2);
            for (int i = 1; i < comparators.length; ++i) {
                int alt = comparators[i].compare(v1, v2);
                if ((result == alt || result < 0 || alt >= 0) && (result > 0 || alt <= 0)) continue;
                throw new IllegalStateException("Property " + PropertyVersionsBuilder.this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the two of versions being compared.\nFirst rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + result + "\nSecond rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + alt);
            }
            return result;
        }

        public int compare(Object o1, Object o2) {
            return this.innerCompare((ArtifactVersion)o1, (ArtifactVersion)o2);
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$mojo$versions$api$PropertyVersionsBuilder == null ? (class$org$codehaus$mojo$versions$api$PropertyVersionsBuilder = PropertyVersionsBuilder.class$("org.codehaus.mojo.versions.api.PropertyVersionsBuilder")) : class$org$codehaus$mojo$versions$api$PropertyVersionsBuilder).desiredAssertionStatus();
        }
    }
}

