/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.surefire;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.mojo.surefire.ReportTestCase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReportTestSuite
extends DefaultHandler {
    private List testCases;
    private int numberOfErrors;
    private int numberOfFailures;
    private int numberOfTests;
    private String name;
    private String packageName;
    private float timeElapsed;
    String currentElement;
    String currentName;
    ReportTestCase testCase;

    public ReportTestSuite() {
    }

    public ReportTestSuite(String xmlPath) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(xmlPath), (DefaultHandler)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("testsuite")) {
            this.numberOfErrors = Integer.parseInt(attrs.getValue("errors"));
            this.numberOfFailures = Integer.parseInt(attrs.getValue("failures"));
            this.numberOfTests = Integer.parseInt(attrs.getValue("tests"));
            this.timeElapsed = Float.parseFloat(attrs.getValue("time"));
            String fName = attrs.getValue("name");
            this.name = fName.substring(fName.lastIndexOf(".") + 1, fName.length());
            this.packageName = fName.substring(0, fName.lastIndexOf("."));
            this.testCases = new ArrayList();
        } else if (qName.equals("testcase")) {
            this.currentElement = "";
            this.testCase = new ReportTestCase();
            this.testCase.setName(attrs.getValue("name"));
            this.testCase.setTime(Float.parseFloat(attrs.getValue("time")));
            this.testCase.setFullName(this.packageName + "." + this.name + "." + this.testCase.getName());
        } else if (qName.equals("failure")) {
            HashMap<String, String> failure = new HashMap<String, String>();
            this.testCase.setFailure(failure);
            failure.put("message", attrs.getValue("message"));
            failure.put("type", attrs.getValue("type"));
        } else if (qName.equals("error")) {
            HashMap<String, String> error = new HashMap<String, String>();
            this.testCase.setFailure(error);
            error.put("message", attrs.getValue("message"));
            error.put("type", attrs.getValue("type"));
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("testcase")) {
            this.testCases.add(this.testCase);
        } else if (qName.equals("failure")) {
            HashMap failure = this.testCase.getFailure();
            failure.put("detail", this.parseCause(this.currentElement));
        } else if (qName.equals("error")) {
            HashMap error = this.testCase.getFailure();
            error.put("detail", this.parseCause(this.currentElement));
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (!s.trim().equals("")) {
            this.currentElement = this.currentElement + s.trim() + "\n";
        }
    }

    public List getTestCases() {
        return this.testCases;
    }

    public void setTestCases(List TestCases) {
        this.testCases = TestCases;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public void setNumberOfErrors(int numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public void setNumberOfFailures(int numberOfFailures) {
        this.numberOfFailures = numberOfFailures;
    }

    public int getNumberOfTests() {
        return this.numberOfTests;
    }

    public void setNumberOfTests(int numberOfTests) {
        this.numberOfTests = numberOfTests;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public float getTimeElapsed() {
        return this.timeElapsed;
    }

    public void setTimeElapsed(float timeElapsed) {
        this.timeElapsed = timeElapsed;
    }

    private String parseCause(String detail) {
        String lineString = "";
        BufferedReader buffReader = new BufferedReader(new StringReader(detail));
        try {
            while ((lineString = buffReader.readLine()) != null && !lineString.trim().startsWith("at " + this.testCase.getFullName())) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lineString;
    }
}

