/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sonar.bootstrap.MavenUtils;

public class MavenProjectConverter {
    private static final char SEPARATOR = ',';
    private static final String UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE = "Unable to determine structure of project. Probably you use Maven Advanced Reactor Options with a broken tree of modules.";
    private static final String MODULE_KEY = "sonar.moduleKey";
    private static final String PROPERTY_PROJECT_BUILDDIR = "sonar.projectBuildDir";
    private static final String JAVA_SOURCE_PROPERTY = "sonar.java.source";
    private static final String JAVA_TARGET_PROPERTY = "sonar.java.target";
    private static final String LINKS_HOME_PAGE = "sonar.links.homepage";
    private static final String LINKS_CI = "sonar.links.ci";
    private static final String LINKS_ISSUE_TRACKER = "sonar.links.issue";
    private static final String LINKS_SOURCES = "sonar.links.scm";
    private static final String LINKS_SOURCES_DEV = "sonar.links.scm_dev";

    public Properties configure(List<MavenProject> mavenProjects, MavenProject root) throws MojoExecutionException {
        HashMap<String, MavenProject> paths = new HashMap<String, MavenProject>();
        HashMap<MavenProject, Properties> propsByModule = new HashMap<MavenProject, Properties>();
        try {
            this.configureModules(mavenProjects, paths, propsByModule);
            Properties props = new Properties();
            props.setProperty("sonar.projectKey", MavenProjectConverter.getSonarKey(root));
            this.rebuildModuleHierarchy(props, paths, propsByModule, root, "");
            if (!propsByModule.isEmpty()) {
                throw new IllegalStateException("Unable to determine structure of project. Probably you use Maven Advanced Reactor Options with a broken tree of modules. \"" + ((MavenProject)propsByModule.keySet().iterator().next()).getName() + "\" is orphan");
            }
            return props;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot configure project", e);
        }
    }

    private void rebuildModuleHierarchy(Properties properties, Map<String, MavenProject> paths, Map<MavenProject, Properties> propsByModule, MavenProject current, String prefix) throws IOException {
        Properties currentProps = propsByModule.get(current);
        if (currentProps == null) {
            throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
        }
        for (Map.Entry<Object, Object> prop : currentProps.entrySet()) {
            properties.put(prefix + prop.getKey(), prop.getValue());
        }
        propsByModule.remove(current);
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (String modulePathStr : current.getModules()) {
            File modulePath = new File(current.getBasedir(), modulePathStr);
            MavenProject module = MavenProjectConverter.findMavenProject(modulePath, paths);
            if (module == null) continue;
            String moduleId = module.getGroupId() + ":" + module.getArtifactId();
            this.rebuildModuleHierarchy(properties, paths, propsByModule, module, prefix + moduleId + ".");
            moduleIds.add(moduleId);
        }
        if (!moduleIds.isEmpty()) {
            properties.put(prefix + "sonar.modules", StringUtils.join(moduleIds, (char)','));
        }
    }

    private void configureModules(List<MavenProject> mavenProjects, Map<String, MavenProject> paths, Map<MavenProject, Properties> propsByModule) throws IOException, MojoExecutionException {
        for (MavenProject pom : mavenProjects) {
            paths.put(pom.getFile().getCanonicalPath(), pom);
            Properties props = new Properties();
            this.merge(pom, props);
            propsByModule.put(pom, props);
        }
    }

    private static MavenProject findMavenProject(File modulePath, Map<String, MavenProject> paths) throws IOException {
        if (modulePath.exists() && modulePath.isDirectory()) {
            for (Map.Entry<String, MavenProject> entry : paths.entrySet()) {
                String pomFileParentDir = new File(entry.getKey()).getParent();
                if (!pomFileParentDir.equals(modulePath.getCanonicalPath())) continue;
                return entry.getValue();
            }
            return null;
        }
        return paths.get(modulePath.getCanonicalPath());
    }

    @VisibleForTesting
    void merge(MavenProject pom, Properties props) throws MojoExecutionException {
        String key = MavenProjectConverter.getSonarKey(pom);
        props.putAll((Map<?, ?>)pom.getModel().getProperties());
        props.setProperty(MODULE_KEY, key);
        props.setProperty("sonar.projectVersion", pom.getVersion());
        props.setProperty("sonar.projectName", pom.getName());
        String description = pom.getDescription();
        if (description != null) {
            props.setProperty("sonar.projectDescription", description);
        }
        MavenProjectConverter.guessJavaVersion(pom, props);
        MavenProjectConverter.guessEncoding(pom, props);
        MavenProjectConverter.convertMavenLinksToProperties(props, pom);
        this.synchronizeFileSystem(pom, props);
    }

    private static String getSonarKey(MavenProject pom) {
        return pom.getGroupId() + ":" + pom.getArtifactId();
    }

    private static void guessEncoding(MavenProject pom, Properties props) {
        String encoding = MavenUtils.getSourceEncoding(pom);
        if (encoding != null) {
            props.setProperty("sonar.sourceEncoding", encoding);
        }
    }

    private static void guessJavaVersion(MavenProject pom, Properties props) {
        String version = MavenUtils.getJavaSourceVersion(pom);
        if (version != null) {
            props.setProperty(JAVA_SOURCE_PROPERTY, version);
        }
        if ((version = MavenUtils.getJavaVersion(pom)) != null) {
            props.setProperty(JAVA_TARGET_PROPERTY, version);
        }
    }

    private static void convertMavenLinksToProperties(Properties props, MavenProject pom) {
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_HOME_PAGE, pom.getUrl());
        Scm scm = pom.getScm();
        if (scm == null) {
            scm = new Scm();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_SOURCES, scm.getUrl());
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_SOURCES_DEV, scm.getDeveloperConnection());
        CiManagement ci = pom.getCiManagement();
        if (ci == null) {
            ci = new CiManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_CI, ci.getUrl());
        IssueManagement issues = pom.getIssueManagement();
        if (issues == null) {
            issues = new IssueManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_ISSUE_TRACKER, issues.getUrl());
    }

    private static void setPropertyIfNotAlreadyExists(Properties props, String propertyKey, String propertyValue) {
        if (StringUtils.isBlank((String)props.getProperty(propertyKey))) {
            props.setProperty(propertyKey, StringUtils.defaultString((String)propertyValue));
        }
    }

    private void synchronizeFileSystem(MavenProject pom, Properties props) throws MojoExecutionException {
        File binaryDir;
        props.setProperty("sonar.projectBaseDir", pom.getBasedir().getAbsolutePath());
        File buildDir = MavenProjectConverter.getBuildDir(pom);
        if (buildDir != null) {
            props.setProperty(PROPERTY_PROJECT_BUILDDIR, buildDir.getAbsolutePath());
            props.setProperty("sonar.working.directory", MavenProjectConverter.getSonarWorkDir(pom).getAbsolutePath());
        }
        List<File> mainDirs = this.mainDirs(pom);
        props.setProperty("sonar.sources", StringUtils.join((Object[])MavenProjectConverter.toPaths(mainDirs), (char)','));
        List<File> testDirs = this.testDirs(pom);
        if (!testDirs.isEmpty()) {
            props.setProperty("sonar.tests", StringUtils.join((Object[])MavenProjectConverter.toPaths(testDirs), (char)','));
        }
        if ((binaryDir = MavenProjectConverter.resolvePath(pom.getBuild().getOutputDirectory(), pom.getBasedir())) != null && binaryDir.exists()) {
            props.setProperty("sonar.binaries", binaryDir.getAbsolutePath());
        }
    }

    public static File getSonarWorkDir(MavenProject pom) {
        return new File(MavenProjectConverter.getBuildDir(pom), "sonar");
    }

    private static File getBuildDir(MavenProject pom) {
        return MavenProjectConverter.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir());
    }

    static File resolvePath(@Nullable String path, File basedir) {
        if (path != null) {
            File file = new File(StringUtils.trim((String)path));
            if (!file.isAbsolute()) {
                try {
                    file = new File(basedir, path).getCanonicalFile();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to resolve path '" + path + "'", e);
                }
            }
            return file;
        }
        return null;
    }

    static List<File> resolvePaths(List<String> paths, File basedir) {
        ArrayList result = Lists.newArrayList();
        for (String path : paths) {
            File dir = MavenProjectConverter.resolvePath(path, basedir);
            if (dir == null) continue;
            result.add(dir);
        }
        return result;
    }

    private List<File> mainDirs(MavenProject pom) throws MojoExecutionException {
        return this.sourceDirs(pom, "sonar.sources", pom.getCompileSourceRoots());
    }

    private List<File> testDirs(MavenProject pom) throws MojoExecutionException {
        return this.sourceDirs(pom, "sonar.tests", pom.getTestCompileSourceRoots());
    }

    private List<File> sourceDirs(MavenProject pom, String propertyKey, List<String> mavenDirs) throws MojoExecutionException {
        String prop = pom.getProperties().getProperty(propertyKey);
        if (prop != null) {
            List<String> paths = Arrays.asList(StringUtils.split((String)prop, (String)","));
            return this.existingDirsOrFail(MavenProjectConverter.resolvePaths(paths, pom.getBasedir()), pom, propertyKey);
        }
        List<File> dirs = MavenProjectConverter.resolvePaths(mavenDirs, pom.getBasedir());
        return MavenProjectConverter.keepExistingDirs(dirs);
    }

    private List<File> existingDirsOrFail(List<File> dirs, MavenProject pom, String propertyKey) throws MojoExecutionException {
        for (File dir : dirs) {
            if (dir.isDirectory() && dir.exists()) continue;
            throw new MojoExecutionException(String.format("The directory '%s' does not exist for Maven module %s. Please check the property %s", dir.getAbsolutePath(), pom.getId(), propertyKey));
        }
        return dirs;
    }

    private static List<File> keepExistingDirs(List<File> files) {
        return Lists.newArrayList((Iterable)Collections2.filter(files, (Predicate)new Predicate<File>(){

            public boolean apply(File dir) {
                return dir != null && dir.exists() && dir.isDirectory();
            }
        }));
    }

    private static String[] toPaths(Collection<File> dirs) {
        Collection paths = Collections2.transform(dirs, (Function)new Function<File, String>(){

            public String apply(File dir) {
                if (dir == null) {
                    throw new NullPointerException("Directory is null");
                }
                return dir.getAbsolutePath();
            }
        });
        return paths.toArray(new String[paths.size()]);
    }
}

