/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ServerMetadata {
    public static final int CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int READ_TIMEOUT_MILLISECONDS = 60000;
    public static final String MAVEN_PATH = "/deploy/maven";
    private String url;
    private String version;
    private String key;

    public ServerMetadata(String url) {
        this.url = StringUtils.chomp((String)url, (String)"/");
    }

    public void connect() throws MojoExecutionException {
        try {
            this.version = this.remoteContent("/api/server/version");
            this.key = this.remoteContent("/api/server/key");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Sonar server can not be reached. Please check the parameter 'sonar.host.url': " + this.url);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getKey() {
        return this.key;
    }

    public String getMavenRepositoryUrl() {
        return this.url + MAVEN_PATH;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean needsSonarInternalRepository() {
        return ServerMetadata.isVersionPriorTo2Dot2(this.version);
    }

    static boolean isVersionPriorTo2Dot2(String version) {
        return version.startsWith("1.") || version.startsWith("2.0") || "2.1".equals(version) || version.startsWith("2.1.");
    }

    public void logSettings(Log log) {
        log.info((CharSequence)("Sonar host: " + this.getUrl()));
        log.info((CharSequence)("Sonar version: " + this.getVersion()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String remoteContent(String path) throws IOException {
        String fullUrl = this.url + path;
        HttpURLConnection conn = this.getConnection(fullUrl + path, "GET");
        InputStreamReader reader = new InputStreamReader((InputStream)conn.getContent());
        try {
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                throw new IOException("Status returned by url : '" + fullUrl + "' is invalid : " + statusCode);
            }
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            conn.disconnect();
        }
    }

    protected HttpURLConnection getConnection(String url, String method) throws IOException {
        URL page = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)page.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(60000);
        conn.setRequestMethod(method);
        conn.connect();
        return conn;
    }
}

