/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:ounce-maven-plugin:1.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Ounce Maven Plugin", 0);
        this.append(sb, "The Codehaus is a collaborative environment for building open source projects with a strong emphasis on modern languages, focussed on quality components that meet real world needs.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "application".equals(this.goal)) {
            this.append(sb, "ounce:application", 0);
            this.append(sb, "This mojo generates an Ounce application file. It will automatically include all child modules as projects. This list make be modified using the includes and excludes patterns. Projects that are external to this build may be included directly using the externalProjects list. External Applications may also be included. All of their modules will be inherted as part of this application file. Those projects may also be filtered upon import.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "coreHint (Default: ouncexml)", 2);
                this.append(sb, "This hint provides a way to switch the core implementation. Consult Ounce support for details, most users should leave this set to the default. Use -Dounce.core=console to have have the output displayed instead of written to the file for debugging purposes.", 3);
                this.append(sb, "Expression: ${ounce.core}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "An array of directories containing the pom file of any projects to exclude. Excludes can contain standard Ant-style wildcards.\nExcludes only apply to inherited modules, not external projects. The current project is not filtered.", 3);
                this.append(sb, "", 0);
                this.append(sb, "externalApplications", 2);
                this.append(sb, "Allows you to include projects from multiple applications. The external application properties are not inherited, and the external application must already exist.\nexternalApplications is a list of directories containing top-level pom files.\nThe format for externalApplications is: pathname,[includes|includes],[excludes|excludes]\nWhere:\n\n-\tpathname, includes, and excludes are comma delimited; if you have excludes, but no includes, use two commas.\n-\tMultiple includes or excludes are separated by pipes (\\x7c).\n-\tExcludes can contain standard Ant style wildcards.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "externalProjects", 2);
                this.append(sb, "List of external projects to include. These projects are included after any other projects have been included or excluded.\nThe format is: name,path\nWhere:\n\n-\tname is the artifact ID of the project to include.\n-\tpath is the pathname to the project.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "An array of directories containing the pom file of any projects to include. If an include pattern is specified, projects not specifed by include patterns are excluded.\nInclude only applies to inherited modules, not external projects. The current project is not filtered.\nThe include pattern may contain the following wildcard characters:\n*: Zero or more characters\n**: Any folders\n?: One and only one character\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "pathVariableMap", 2);
                this.append(sb, "Map of Ounce variable names and paths.\npathVariableMap variables are automatically registered with Ounce by the Ounce/Maven plugin if the Ounce Automation Server is installed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipPoms (Default: true)", 2);
                this.append(sb, "If pom packaging projects should be skipped. Typically these will not have source code and should be excluded. This is true by default because typically the application or projects will be created at a pom level and the poms have no source to be analyzed Only set this if you have source in your 'pom' packaging projects that needs to be scanned.", 3);
                this.append(sb, "Expression: ${ounce.skipPoms}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "ounce:help", 0);
            this.append(sb, "Display help information on ounce-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0ounce:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "project".equals(this.goal)) {
            this.append(sb, "ounce:project", 0);
            this.append(sb, "This mojo generates an Ounce project file. It forks the build and executes the process-sources phase so that any plugins that may generate sources and attach new source folders to the project will execute and those source folders will be automatically included in the generated project. This mojo is intended to be executed from the command line. If you would rather have the project built automatically during your build, use the project-only goal instead.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "analyzeStrutsFramework (Default: false)", 2);
                this.append(sb, "Whether to analyze the framework for a Struts application", 3);
                this.append(sb, "Expression: ${ounce.analyzeStrutsFramework}", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathScope (Default: compile)", 2);
                this.append(sb, "The scope of the classpath used to analyze this project.\nValid choices are: compile, test, runtime, or system. If includeTestSources is true, then the classpathScope reverts to test. Otherwise, the default is compile.", 3);
                this.append(sb, "Expression: ${ounce.classpathScope}", 3);
                this.append(sb, "", 0);
                this.append(sb, "coreHint (Default: ouncexml)", 2);
                this.append(sb, "This hint provides a way to switch the core implementation. Consult Ounce support for details, most users should leave this set to the default. Use -Dounce.core=console to have have the output displayed instead of written to the file for debugging purposes.", 3);
                this.append(sb, "Expression: ${ounce.core}", 3);
                this.append(sb, "", 0);
                this.append(sb, "createVariables (Default: true)", 2);
                this.append(sb, "Whether the plugin should use the Ounce Automation Server to create any necessary variables (such as M2_REPO). Requires that the Ounce Automation Server be installed.", 3);
                this.append(sb, "Expression: ${ounce.createVariables}", 3);
                this.append(sb, "", 0);
                this.append(sb, "importStrutsValidation (Default: false)", 2);
                this.append(sb, "Whether to import Struts validation routines", 3);
                this.append(sb, "Expression: ${ounce.importStrutsValidation}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTestSources (Default: false)", 2);
                this.append(sb, "If TestSources should be included in the compilable sources. If set, adds project.getTestSourceRoot() to the path and defaults the classpathScope to test.", 3);
                this.append(sb, "Expression: ${ounce.includeTestSources}", 3);
                this.append(sb, "", 0);
                this.append(sb, "installDir", 2);
                this.append(sb, "The location of the Ounce client installation directory. Required if ounceauto is not on the path.", 3);
                this.append(sb, "Expression: ${ounce.installDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaCompilerOptions", 2);
                this.append(sb, "Options to pass to the javac compiler.", 3);
                this.append(sb, "Expression: ${ounce.javaCompilerOptions}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdkName", 2);
                this.append(sb, "JDK configuration known to Ounce Core.", 3);
                this.append(sb, "Expression: ${ounce.jdkName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pathVariableMap", 2);
                this.append(sb, "Map of Ounce variable names and paths.\npathVariableMap variables are automatically registered with Ounce by the Ounce/Maven plugin if the Ounce Automation Server is installed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipPoms (Default: true)", 2);
                this.append(sb, "If pom packaging projects should be skipped. Typically these will not have source code and should be excluded. This is true by default because typically the application or projects will be created at a pom level and the poms have no source to be analyzed Only set this if you have source in your 'pom' packaging projects that needs to be scanned.", 3);
                this.append(sb, "Expression: ${ounce.skipPoms}", 3);
                this.append(sb, "", 0);
                this.append(sb, "webappDirectory", 2);
                this.append(sb, "The location of the web context root, if needed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "project-only".equals(this.goal)) {
            this.append(sb, "ounce:project-only", 0);
            this.append(sb, "This mojo generates an Ounce project file. It does not fork the build like the 'project' mojo and is instead intended to be bound in a pom for automatic execution. If you would rather have the project generated on demand via the command line, use the project goal instead.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "analyzeStrutsFramework (Default: false)", 2);
                this.append(sb, "Whether to analyze the framework for a Struts application", 3);
                this.append(sb, "Expression: ${ounce.analyzeStrutsFramework}", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathScope (Default: compile)", 2);
                this.append(sb, "The scope of the classpath used to analyze this project.\nValid choices are: compile, test, runtime, or system. If includeTestSources is true, then the classpathScope reverts to test. Otherwise, the default is compile.", 3);
                this.append(sb, "Expression: ${ounce.classpathScope}", 3);
                this.append(sb, "", 0);
                this.append(sb, "coreHint (Default: ouncexml)", 2);
                this.append(sb, "This hint provides a way to switch the core implementation. Consult Ounce support for details, most users should leave this set to the default. Use -Dounce.core=console to have have the output displayed instead of written to the file for debugging purposes.", 3);
                this.append(sb, "Expression: ${ounce.core}", 3);
                this.append(sb, "", 0);
                this.append(sb, "createVariables (Default: true)", 2);
                this.append(sb, "Whether the plugin should use the Ounce Automation Server to create any necessary variables (such as M2_REPO). Requires that the Ounce Automation Server be installed.", 3);
                this.append(sb, "Expression: ${ounce.createVariables}", 3);
                this.append(sb, "", 0);
                this.append(sb, "importStrutsValidation (Default: false)", 2);
                this.append(sb, "Whether to import Struts validation routines", 3);
                this.append(sb, "Expression: ${ounce.importStrutsValidation}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTestSources (Default: false)", 2);
                this.append(sb, "If TestSources should be included in the compilable sources. If set, adds project.getTestSourceRoot() to the path and defaults the classpathScope to test.", 3);
                this.append(sb, "Expression: ${ounce.includeTestSources}", 3);
                this.append(sb, "", 0);
                this.append(sb, "installDir", 2);
                this.append(sb, "The location of the Ounce client installation directory. Required if ounceauto is not on the path.", 3);
                this.append(sb, "Expression: ${ounce.installDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaCompilerOptions", 2);
                this.append(sb, "Options to pass to the javac compiler.", 3);
                this.append(sb, "Expression: ${ounce.javaCompilerOptions}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdkName", 2);
                this.append(sb, "JDK configuration known to Ounce Core.", 3);
                this.append(sb, "Expression: ${ounce.jdkName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pathVariableMap", 2);
                this.append(sb, "Map of Ounce variable names and paths.\npathVariableMap variables are automatically registered with Ounce by the Ounce/Maven plugin if the Ounce Automation Server is installed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipPoms (Default: true)", 2);
                this.append(sb, "If pom packaging projects should be skipped. Typically these will not have source code and should be excluded. This is true by default because typically the application or projects will be created at a pom level and the poms have no source to be analyzed Only set this if you have source in your 'pom' packaging projects that needs to be scanned.", 3);
                this.append(sb, "Expression: ${ounce.skipPoms}", 3);
                this.append(sb, "", 0);
                this.append(sb, "webappDirectory", 2);
                this.append(sb, "The location of the web context root, if needed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "ounce:report", 0);
            this.append(sb, "Generate the scan results as part of the site.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationFile (Default: ${basedir}/${project.artifactId}.paf)", 2);
                this.append(sb, "The location of the application file (.paf) to scan.", 3);
                this.append(sb, "Expression: ${ounce.applicationFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "assessmentName", 2);
                this.append(sb, "A name to help identify the assessment.", 3);
                this.append(sb, "Expression: ${project.name}-${project.version}", 3);
                this.append(sb, "", 0);
                this.append(sb, "assessmentOutput", 2);
                this.append(sb, "A filename to which to save the assessment.\nIf filename is not specified, Ounce/Maven generates a name based on the application name and timestamp and saves it to the applications working directory.", 3);
                this.append(sb, "Expression: ${ounce.assessmentOutput}", 3);
                this.append(sb, "", 0);
                this.append(sb, "caller", 2);
                this.append(sb, "A short string to help identify the corresponding entries in the ounceauto log file.", 3);
                this.append(sb, "Expression: ${ounce.caller}", 3);
                this.append(sb, "", 0);
                this.append(sb, "coreHint (Default: ouncexml)", 2);
                this.append(sb, "This hint provides a way to switch the core implementation. Consult Ounce support for details, most users should leave this set to the default. Use -Dounce.core=console to have have the output displayed instead of written to the file for debugging purposes.", 3);
                this.append(sb, "Expression: ${ounce.core}", 3);
                this.append(sb, "", 0);
                this.append(sb, "existingAssessmentFile", 2);
                this.append(sb, "Specify the name of an existing assessment for which to generate a report. If not specified, Ounce/Maven scans the application and generates the report from that assessment.", 3);
                this.append(sb, "Expression: ${ounce.existingAssessmentFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeSrcAfter", 2);
                this.append(sb, "Number of lines of source code to include in the report after each finding.", 3);
                this.append(sb, "Expression: ${ounce.includeSrcAfter}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeSrcBefore", 2);
                this.append(sb, "Number of lines of source code to include in the report before each finding.", 3);
                this.append(sb, "Expression: ${ounce.includeSrcBefore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "installDir", 2);
                this.append(sb, "The location of the Ounce client installation directory if the Ounce client is not on the path.", 3);
                this.append(sb, "Expression: ${ounce.installDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pathVariableMap", 2);
                this.append(sb, "Map of Ounce variable names and paths.\npathVariableMap variables are automatically registered with Ounce by the Ounce/Maven plugin if the Ounce Automation Server is installed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "publish (Default: false)", 2);
                this.append(sb, "Automatically publish the assessment following the completion of the scan.", 3);
                this.append(sb, "Expression: ${ounce.publish}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportOutputPath", 2);
                this.append(sb, "The path to which to write the report specified in reportType. Required with reportType.", 3);
                this.append(sb, "Expression: ${ounce.reportOutputPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportOutputType", 2);
                this.append(sb, "The output to generate for the report specified in reportType. Required with reportType. Output type may be html, zip, pdf-summary, pdf-detailed, pdf-comprehensive, or pdf-annotated.", 3);
                this.append(sb, "Expression: ${ounce.reportOutputType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportType", 2);
                this.append(sb, "Generates an Ounce report of the specified type, including findings reports, SmartAudit Reports, and, if available, custom reports. Ounce/Maven generates a report for this assessment after the scan completes.\nThe following report types are included: Findings, Findings By CWE, Findings By API, Findings By Classification, Findings By File, Findings By Type, Findings By Bundle, OWASP Top Ten, PCI Data Security Standard, Ounce Software Security Profile, or OWASP Top Ten 2007\nIf you specify reportType, then reportOutputType and reportOutputPath are required.", 3);
                this.append(sb, "Expression: ${ounce.reportType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipPoms (Default: true)", 2);
                this.append(sb, "If pom packaging projects should be skipped. Typically these will not have source code and should be excluded. This is true by default because typically the application or projects will be created at a pom level and the poms have no source to be analyzed Only set this if you have source in your 'pom' packaging projects that needs to be scanned.", 3);
                this.append(sb, "Expression: ${ounce.skipPoms}", 3);
                this.append(sb, "", 0);
                this.append(sb, "waitForScan (Default: false)", 2);
                this.append(sb, "Forces the goal to wait until the scan finishes, thus blocking the Maven build. This is useful if the scan is being performed from the report mojo as part of integration with the site target and the site is getting deployed.", 3);
                this.append(sb, "Expression: ${ounce.wait}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "scan".equals(this.goal)) {
            this.append(sb, "ounce:scan", 0);
            this.append(sb, "This mojo allows an on demand scan of an application and the optional publishing of the results.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationFile (Default: ${basedir}/${project.artifactId}.paf)", 2);
                this.append(sb, "The location of the application file (.paf) to scan.", 3);
                this.append(sb, "Expression: ${ounce.applicationFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "assessmentName", 2);
                this.append(sb, "A name to help identify the assessment.", 3);
                this.append(sb, "Expression: ${project.name}-${project.version}", 3);
                this.append(sb, "", 0);
                this.append(sb, "assessmentOutput", 2);
                this.append(sb, "A filename to which to save the assessment.\nIf filename is not specified, Ounce/Maven generates a name based on the application name and timestamp and saves it to the applications working directory.", 3);
                this.append(sb, "Expression: ${ounce.assessmentOutput}", 3);
                this.append(sb, "", 0);
                this.append(sb, "caller", 2);
                this.append(sb, "A short string to help identify the corresponding entries in the ounceauto log file.", 3);
                this.append(sb, "Expression: ${ounce.caller}", 3);
                this.append(sb, "", 0);
                this.append(sb, "coreHint (Default: ouncexml)", 2);
                this.append(sb, "This hint provides a way to switch the core implementation. Consult Ounce support for details, most users should leave this set to the default. Use -Dounce.core=console to have have the output displayed instead of written to the file for debugging purposes.", 3);
                this.append(sb, "Expression: ${ounce.core}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeSrcAfter", 2);
                this.append(sb, "Number of lines of source code to include in the report after each finding.", 3);
                this.append(sb, "Expression: ${ounce.includeSrcAfter}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeSrcBefore", 2);
                this.append(sb, "Number of lines of source code to include in the report before each finding.", 3);
                this.append(sb, "Expression: ${ounce.includeSrcBefore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "installDir", 2);
                this.append(sb, "The location of the Ounce client installation directory if the Ounce client is not on the path.", 3);
                this.append(sb, "Expression: ${ounce.installDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pathVariableMap", 2);
                this.append(sb, "Map of Ounce variable names and paths.\npathVariableMap variables are automatically registered with Ounce by the Ounce/Maven plugin if the Ounce Automation Server is installed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "publish (Default: false)", 2);
                this.append(sb, "Automatically publish the assessment following the completion of the scan.", 3);
                this.append(sb, "Expression: ${ounce.publish}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportOutputPath", 2);
                this.append(sb, "The path to which to write the report specified in reportType. Required with reportType.", 3);
                this.append(sb, "Expression: ${ounce.reportOutputPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportOutputType", 2);
                this.append(sb, "The output to generate for the report specified in reportType. Required with reportType. Output type may be html, zip, pdf-summary, pdf-detailed, pdf-comprehensive, or pdf-annotated.", 3);
                this.append(sb, "Expression: ${ounce.reportOutputType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportType", 2);
                this.append(sb, "Generates an Ounce report of the specified type, including findings reports, SmartAudit Reports, and, if available, custom reports. Ounce/Maven generates a report for this assessment after the scan completes.\nThe following report types are included: Findings, Findings By CWE, Findings By API, Findings By Classification, Findings By File, Findings By Type, Findings By Bundle, OWASP Top Ten, PCI Data Security Standard, Ounce Software Security Profile, or OWASP Top Ten 2007\nIf you specify reportType, then reportOutputType and reportOutputPath are required.", 3);
                this.append(sb, "Expression: ${ounce.reportType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipPoms (Default: true)", 2);
                this.append(sb, "If pom packaging projects should be skipped. Typically these will not have source code and should be excluded. This is true by default because typically the application or projects will be created at a pom level and the poms have no source to be analyzed Only set this if you have source in your 'pom' packaging projects that needs to be scanned.", 3);
                this.append(sb, "Expression: ${ounce.skipPoms}", 3);
                this.append(sb, "", 0);
                this.append(sb, "waitForScan (Default: false)", 2);
                this.append(sb, "Forces the goal to wait until the scan finishes, thus blocking the Maven build. This is useful if the scan is being performed from the report mojo as part of integration with the site target and the site is getting deployed.", 3);
                this.append(sb, "Expression: ${ounce.wait}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

