/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class NativeUnZipIncMojo
extends AbstractNativeMojo {
    private File dependencyIncZipMarkerDirectory;
    private ArchiverManager archiverManager;

    public void execute() throws MojoExecutionException {
        if (this.unpackIncZipDepenedencies()) {
            this.getPluginContext().put("IncZipFound", new Boolean("true"));
        }
    }

    private boolean unpackIncZipDepenedencies() throws MojoExecutionException {
        List files = this.getIncZipDependencies();
        Iterator iter = files.iterator();
        for (int i = 0; i < files.size(); ++i) {
            Artifact artifact = (Artifact)iter.next();
            File incZipFile = artifact.getFile();
            File marker = new File(this.dependencyIncZipMarkerDirectory, artifact.getGroupId() + "." + artifact.getArtifactId());
            if (marker.exists() && marker.lastModified() >= incZipFile.lastModified()) continue;
            try {
                this.unpackZipFile(incZipFile);
                marker.delete();
                if (!this.dependencyIncZipMarkerDirectory.exists()) {
                    this.dependencyIncZipMarkerDirectory.mkdirs();
                }
                marker.createNewFile();
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        return files.size() != 0;
    }

    protected void unpackZipFile(File zipFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Unpacking: " + zipFile));
        try {
            if (!this.dependencyIncludeDirectory.exists()) {
                this.dependencyIncludeDirectory.mkdirs();
            }
            UnArchiver archiver = this.archiverManager.getUnArchiver("zip");
            archiver.setOverwrite(true);
            archiver.setDestDirectory(this.dependencyIncludeDirectory);
            archiver.setSourceFile(zipFile);
            archiver.extract();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private List getIncZipDependencies() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        Set artifacts = this.project.getDependencyArtifacts();
        if (artifacts != null) {
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if (!"inczip".equals(artifact.getType())) continue;
                list.add(artifact);
            }
        }
        return list;
    }
}

