/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.jxr.JXR;
import org.apache.maven.jxr.log.Log;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.jxr.PluginLogAdapter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.FileUtils;

public class JxrReport
extends AbstractMavenReport {
    private MavenProject project;
    private SiteRenderer siteRenderer;
    private List sourceDirs;
    private List testSourceDirs;
    private String outputDirectory;
    private String destDir;
    private String inputEncoding;
    private String outputEncoding;
    private String javadocDir;
    private String windowTitle;
    private String docTitle;
    private String bottom;
    private String templateDir;
    private String stylesheet;
    private boolean javadocReportGenerated;

    protected void executeReport(Locale locale) throws MavenReportException {
        this.init();
        Sink sink = this.getSink();
        this.startSink(sink, locale);
        this.generateXrefForSources(locale, sink);
        this.generateXrefForTests(locale, sink);
        this.endSink(sink);
    }

    private void generateXrefForSources(Locale locale, Sink sink) throws MavenReportException {
        sink.section2();
        sink.sectionTitle2();
        sink.text(this.getBundle(locale).getString("report.xref.projectSources.title"));
        sink.sectionTitle2_();
        sink.paragraph();
        if (this.hasSources(this.sourceDirs)) {
            try {
                this.createXref(locale, this.destDir, this.sourceDirs);
                sink.text(this.getBundle(locale).getString("report.xref.projectSources.link"));
                File out = new File(this.outputDirectory);
                File des = new File(this.destDir);
                String relativPath = des.getAbsolutePath().substring(out.getAbsolutePath().length() + 1);
                sink.link(relativPath + "/index.html");
                sink.text(relativPath + "/index.html");
                sink.link_();
            }
            catch (Exception e) {
                throw new MavenReportException("Error while generating the HTML source code of the projet.", e);
            }
        } else {
            sink.text(this.getBundle(locale).getString("report.xref.projectSources.noSources"));
        }
        sink.paragraph_();
        sink.section2_();
    }

    private boolean hasSources(List sourceDirs) {
        boolean found = false;
        Iterator i = sourceDirs.iterator();
        while (i.hasNext() && !found) {
            String dir = (String)i.next();
            if (!this.hasSources(new File(dir))) continue;
            found = true;
        }
        return found;
    }

    private void generateXrefForTests(Locale locale, Sink sink) throws MavenReportException {
        sink.section2();
        sink.sectionTitle2();
        sink.text(this.getBundle(locale).getString("report.xref.testSources.title"));
        sink.sectionTitle2_();
        sink.paragraph();
        if (this.hasSources(this.testSourceDirs)) {
            try {
                String testDestDir = this.destDir + "-test";
                this.createXref(locale, testDestDir, this.testSourceDirs);
                sink.text(this.getBundle(locale).getString("report.xref.testSources.link"));
                File out = new File(this.outputDirectory);
                File des = new File(testDestDir);
                String relativPath = des.getAbsolutePath().substring(out.getAbsolutePath().length() + 1);
                sink.link(relativPath + "/index.html");
                sink.text(relativPath + "/index.html");
                sink.link_();
            }
            catch (Exception e) {
                throw new MavenReportException("Error while generating the HTML source code of the projet.", e);
            }
        } else {
            sink.text(this.getBundle(locale).getString("report.xref.testSources.noSources"));
        }
        sink.paragraph_();
        sink.section2_();
    }

    private void init() {
        List plugin = this.getProject().getReportPlugins();
        if (plugin != null) {
            Iterator iter = plugin.iterator();
            while (iter.hasNext()) {
                ReportPlugin reportPlugin = (ReportPlugin)iter.next();
                if (!"maven-javadoc-plugin".equals(reportPlugin.getArtifactId())) continue;
                this.javadocReportGenerated = true;
                break;
            }
        }
    }

    private void startSink(Sink sink, Locale locale) {
        sink.head();
        sink.title();
        sink.text(this.getBundle(locale).getString("report.xref.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.getBundle(locale).getString("report.xref.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.getBundle(locale).getString("report.xref.summary"));
        sink.paragraph_();
    }

    private void endSink(Sink sink) {
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private boolean hasSources(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            boolean hasSources;
            File currentFile = files[i];
            if (currentFile.isFile() && currentFile.getName().endsWith(".java")) {
                return true;
            }
            if (!currentFile.isDirectory() || !(hasSources = this.hasSources(currentFile))) continue;
            return true;
        }
        return false;
    }

    private void createXref(Locale locale, String destinationDirectory, List sourceDirs) throws IOException, Exception {
        JXR jxr = new JXR();
        jxr.setDest(destinationDirectory);
        jxr.setInputEncoding(this.inputEncoding);
        jxr.setJavadocLinkDir(this.javadocDir);
        jxr.setLocale(locale);
        jxr.setLog((Log)new PluginLogAdapter(this.getLog()));
        jxr.setOutputEncoding(this.outputEncoding);
        jxr.setRevision("HEAD");
        jxr.xref(sourceDirs, this.templateDir, this.windowTitle, this.docTitle, this.bottom);
        this.copyRequiredResources(destinationDirectory);
    }

    private void copyRequiredResources(String dir) {
        File stylesheetFile = new File(this.stylesheet);
        File destStylesheetFile = new File(dir, "stylesheet.css");
        try {
            if (stylesheetFile.isAbsolute()) {
                FileUtils.copyFile((File)stylesheetFile, (File)destStylesheetFile);
            } else {
                URL stylesheetUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.stylesheet);
                FileUtils.copyURLToFile((URL)stylesheetUrl, (File)destStylesheetFile);
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"An error occured while copying the stylesheet to the target directory", (Throwable)e);
        }
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.xref.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.xref.name");
    }

    public String getOutputName() {
        return "jxr";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jxr-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

