/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.extraenforcer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Named(value="requirePropertyDiverges")
public class RequirePropertyDiverges
extends AbstractEnforcerRule {
    private String message;
    static final String MAVEN_ENFORCER_PLUGIN = "org.apache.maven.plugins:maven-enforcer-plugin";
    private String property = null;
    private String regex = null;
    private static final String RULE_NAME = StringUtils.lowercaseFirstLetter((String)RequirePropertyDiverges.class.getSimpleName());
    private final MavenProject project;
    private final ExpressionEvaluator evaluator;

    @Inject
    public RequirePropertyDiverges(MavenProject project, ExpressionEvaluator evaluator) {
        this.project = project;
        this.evaluator = evaluator;
    }

    public void execute() throws EnforcerRuleException {
        Object propValue = this.getPropertyValue();
        this.checkPropValueNotBlank(propValue);
        this.getLog().debug(() -> RequirePropertyDiverges.getRuleName() + ": checking property '" + this.property + "' for project " + this.project);
        MavenProject parent = this.findDefiningParent(this.project);
        if (parent == null) {
            throw new IllegalStateException("Failed to find parent POM which defines the current rule");
        }
        if (this.project.equals((Object)parent)) {
            this.getLog().debug(() -> RequirePropertyDiverges.getRuleName() + ": skip for property '" + this.property + "' as " + this.project + " defines rule.");
        } else {
            this.getLog().debug(() -> "Check configuration defined in " + parent);
            if (this.regex == null) {
                this.checkAgainstParentValue(this.project, parent, propValue);
            } else {
                this.checkAgainstRegex(propValue);
            }
        }
    }

    void checkAgainstParentValue(MavenProject project, MavenProject parent, Object propValue) throws EnforcerRuleException {
        StringBuilder parentHierarchy = new StringBuilder("project.");
        MavenProject needle = project;
        while (!needle.equals((Object)parent)) {
            parentHierarchy.append("parent.");
            needle = needle.getParent();
        }
        String propertyNameInParent = this.property.replace("project.", parentHierarchy.toString());
        Object parentValue = this.getPropertyValue(propertyNameInParent);
        if (propValue.equals(parentValue)) {
            String errorMessage = this.createResultingErrorMessage(String.format("Property '%s' evaluates to '%s'. This does match '%s' from parent %s", this.property, propValue, parentValue, parent));
            throw new EnforcerRuleException(errorMessage);
        }
    }

    void checkAgainstRegex(Object propValue) throws EnforcerRuleException {
        if (propValue.toString().matches(this.regex)) {
            String errorMessage = this.createResultingErrorMessage(String.format("Property '%s' evaluates to '%s'. This does match the regular expression '%s'", this.property, propValue, this.regex));
            throw new EnforcerRuleException(errorMessage);
        }
    }

    final MavenProject findDefiningParent(MavenProject project) {
        List<Xpp3Dom> rules;
        Model model;
        Build build;
        MavenProject parent;
        Xpp3Dom invokingRule = this.createInvokingRuleDom();
        for (parent = project; !(parent == null || (build = (model = parent.getOriginalModel()).getBuild()) != null && this.isDefiningProject(rules = this.getRuleConfigurations(build), invokingRule)); parent = parent.getParent()) {
        }
        return parent;
    }

    Xpp3Dom createInvokingRuleDom() {
        return new CreateInvokingRuleDom(this).getRuleDom();
    }

    final boolean isDefiningProject(List<Xpp3Dom> rulesFromModel, Xpp3Dom invokingRule) {
        for (Xpp3Dom rule : rulesFromModel) {
            if (!rule.equals((Object)invokingRule)) continue;
            return true;
        }
        return false;
    }

    static final String getRuleName() {
        return RULE_NAME;
    }

    final List<Xpp3Dom> getRuleConfigurations(Build build) {
        Map plugins = build.getPluginsAsMap();
        List<Xpp3Dom> ruleConfigurationsForPlugins = this.getRuleConfigurations(plugins);
        PluginManagement pluginManagement = build.getPluginManagement();
        if (pluginManagement != null) {
            Map pluginsFromManagementAsMap = pluginManagement.getPluginsAsMap();
            List<Xpp3Dom> ruleConfigurationsFromManagement = this.getRuleConfigurations(pluginsFromManagementAsMap);
            ruleConfigurationsForPlugins.addAll(ruleConfigurationsFromManagement);
        }
        return ruleConfigurationsForPlugins;
    }

    List<Xpp3Dom> getRuleConfigurations(Map<String, Plugin> plugins) {
        if (plugins.containsKey(MAVEN_ENFORCER_PLUGIN)) {
            ArrayList<Xpp3Dom> ruleConfigurations = new ArrayList<Xpp3Dom>();
            Plugin enforcer = plugins.get(MAVEN_ENFORCER_PLUGIN);
            Xpp3Dom configuration = (Xpp3Dom)enforcer.getConfiguration();
            this.addRules(configuration, ruleConfigurations);
            for (PluginExecution execution : enforcer.getExecutions()) {
                this.addRules((Xpp3Dom)execution.getConfiguration(), ruleConfigurations);
            }
            return ruleConfigurations;
        }
        return new ArrayList<Xpp3Dom>();
    }

    private void addRules(Xpp3Dom configuration, List<Xpp3Dom> ruleConfigurations) {
        Xpp3Dom rules;
        if (configuration != null && (rules = configuration.getChild("rules")) != null) {
            List<Xpp3Dom> originalListFromPom = Arrays.asList(rules.getChildren(RequirePropertyDiverges.getRuleName()));
            ruleConfigurations.addAll(this.createRuleListWithNameSortedChildren(originalListFromPom));
        }
    }

    private List<Xpp3Dom> createRuleListWithNameSortedChildren(List<Xpp3Dom> originalListFromPom) {
        ArrayList<Xpp3Dom> listWithSortedEntries = new ArrayList<Xpp3Dom>(originalListFromPom.size());
        for (Xpp3Dom unsortedXpp3Dom : originalListFromPom) {
            Xpp3Dom sortedXpp3Dom = new Xpp3Dom(RequirePropertyDiverges.getRuleName());
            TreeMap<String, Xpp3Dom> childrenMap = new TreeMap<String, Xpp3Dom>();
            Xpp3Dom[] children = unsortedXpp3Dom.getChildren();
            for (Xpp3Dom child : children) {
                childrenMap.put(child.getName(), child);
            }
            for (Xpp3Dom entry : childrenMap.values()) {
                sortedXpp3Dom.addChild(entry);
            }
            listWithSortedEntries.add(sortedXpp3Dom);
        }
        return listWithSortedEntries;
    }

    Object getPropertyValue() throws EnforcerRuleException {
        return this.getPropertyValue(this.property);
    }

    Object getPropertyValue(String propertyName) throws EnforcerRuleException {
        try {
            return this.evaluator.evaluate("${" + propertyName + "}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleError("Unable to evaluate property: " + propertyName, (Throwable)eee);
        }
    }

    void checkPropValueNotBlank(Object propValue) throws EnforcerRuleException {
        if (propValue == null || StringUtils.isBlank((String)propValue.toString())) {
            throw new EnforcerRuleException(String.format("Property '%s' is required for this build and not defined in hierarchy at all.", this.property));
        }
    }

    String createResultingErrorMessage(String errorMessage) {
        if (StringUtils.isNotEmpty((String)this.message)) {
            return "Property '" + this.property + "' must be overridden:\n" + this.message;
        }
        return errorMessage;
    }

    void setProperty(String property) {
        this.property = property;
    }

    void setRegex(String regex) {
        this.regex = regex;
    }

    void setMessage(String message) {
        this.message = message;
    }

    private static class CreateInvokingRuleDom {
        private final Xpp3Dom ruleDom;
        private final SortedMap<String, Xpp3Dom> map = new TreeMap<String, Xpp3Dom>();

        CreateInvokingRuleDom(RequirePropertyDiverges rule) {
            this.ruleDom = new Xpp3Dom(RequirePropertyDiverges.getRuleName());
            this.addToMapWhenNotNull(rule.property, "property");
            this.addToMapWhenNotNull(rule.message, "message");
            this.addToMapWhenNotNull(rule.regex, "regex");
            this.addChildrenToRuleDom();
        }

        public Xpp3Dom getRuleDom() {
            return this.ruleDom;
        }

        private void addToMapWhenNotNull(String member, String memberName) {
            if (member != null) {
                Xpp3Dom memberDom = new Xpp3Dom(memberName);
                memberDom.setValue(member);
                this.map.put(memberName, memberDom);
            }
        }

        private void addChildrenToRuleDom() {
            for (Xpp3Dom entry : this.map.values()) {
                this.ruleDom.addChild(entry);
            }
        }
    }
}

