/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractMojoHausEnforcerRule;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class BanCircularDependencies
extends AbstractMojoHausEnforcerRule {
    private transient DependencyGraphBuilder graphBuilder;
    private String message;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            this.graphBuilder = (DependencyGraphBuilder)helper.getComponent(DependencyGraphBuilder.class);
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup DependencyGraphBuilder: ", (Exception)((Object)e));
        }
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            MavenSession session = (MavenSession)helper.evaluate("${session}");
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
            buildingRequest.setProject(project);
            Set<Artifact> artifacts = this.getDependenciesToCheck((ProjectBuildingRequest)buildingRequest);
            if (artifacts != null) {
                for (Artifact artifact : artifacts) {
                    log.debug((CharSequence)("groupId: " + artifact.getGroupId() + project.getGroupId()));
                    if (!artifact.getGroupId().equals(project.getGroupId())) continue;
                    log.debug((CharSequence)("artifactId: " + artifact.getArtifactId() + " " + project.getArtifactId()));
                    if (!artifact.getArtifactId().equals(project.getArtifactId())) continue;
                    throw new EnforcerRuleException(this.getErrorMessage() + "\n  " + artifact.getGroupId() + ":" + artifact.getArtifactId() + "\n ");
                }
            }
        }
        catch (ExpressionEvaluationException e) {
            log.error((CharSequence)"Error checking for circular dependencies", (Throwable)e);
            e.printStackTrace();
        }
    }

    protected Set<Artifact> getDependenciesToCheck(ProjectBuildingRequest buildingRequest) {
        Set<Artifact> dependencies;
        try {
            DependencyNode node = this.graphBuilder.buildDependencyGraph(buildingRequest, null);
            dependencies = this.getAllDescendants(node);
        }
        catch (DependencyGraphBuilderException e) {
            throw new RuntimeException(e);
        }
        return dependencies;
    }

    private Set<Artifact> getAllDescendants(DependencyNode node) {
        HashSet<Artifact> children = null;
        if (node.getChildren() != null) {
            children = new HashSet<Artifact>();
            for (DependencyNode depNode : node.getChildren()) {
                children.add(depNode.getArtifact());
                Set<Artifact> subNodes = this.getAllDescendants(depNode);
                if (subNodes == null) continue;
                children.addAll(subNodes);
            }
        }
        return children;
    }

    private String getErrorMessage() {
        if (this.message == null) {
            return "Circular Dependency found. Your project's groupId:artifactId combination must not exist in the list of direct or transitive dependencies.";
        }
        return this.message;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "Does not matter as not cacheable";
    }
}

