/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.download;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.logging.Log;

public class DownloadHelper {
    private static final int BUFFER = 2048;
    private String remoteLocation;
    private String destination;
    private final Log log;

    public DownloadHelper(String remoteLocation, String destination, Log log) {
        this.remoteLocation = remoteLocation;
        this.destination = destination;
        this.log = log;
    }

    public final void downloadZipFile() throws IOException {
        ZipEntry entry;
        this.log.info((CharSequence)("Downloading " + this.remoteLocation + " storing it inside " + this.destination));
        URL u = new URL(this.remoteLocation);
        URLConnection uc = u.openConnection();
        byte[] inData = this.getRemoteZipfile(uc);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(inData)));
        while ((entry = zis.getNextEntry()) != null) {
            this.writeOutputFile(zis, entry);
        }
        zis.close();
    }

    private byte[] getRemoteZipfile(URLConnection uc) throws IOException {
        int offset;
        int bytesRead;
        int contentLength = uc.getContentLength();
        BufferedInputStream is = new BufferedInputStream(uc.getInputStream());
        byte[] inData = new byte[contentLength];
        for (offset = 0; offset < contentLength && (bytesRead = ((InputStream)is).read(inData, offset, inData.length - offset)) != -1; offset += bytesRead) {
        }
        ((InputStream)is).close();
        if (offset != contentLength) {
            throw new IOException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
        }
        return inData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutputFile(ZipInputStream zis, ZipEntry entry) throws IOException {
        String destinationFileName = this.extractDestination(entry.getName());
        File outputFile = new File(this.destination, destinationFileName);
        if (entry.isDirectory()) {
            outputFile.mkdir();
        } else {
            this.log.debug((CharSequence)("Saving file " + outputFile));
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(outputFile), 2048);
            try {
                int length;
                byte[] outData = new byte[2048];
                while ((length = zis.read(outData, 0, 2048)) != -1) {
                    ((OutputStream)fos).write(outData, 0, length);
                }
                ((OutputStream)fos).flush();
            }
            finally {
                ((OutputStream)fos).close();
            }
        }
    }

    private String extractDestination(String fileName) {
        int firstSeparatorBackslash;
        int firstSeparatorSlash = fileName.indexOf(47);
        int index = Math.max(firstSeparatorSlash, firstSeparatorBackslash = fileName.indexOf(92));
        String tmp = fileName.substring(0, index);
        if (tmp.contains(new File(this.destination).getName())) {
            fileName = fileName.substring(index);
        }
        return fileName;
    }
}

