/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.common.model;

import org.jdom.Element;

public final class GCSample {
    private final double timestamp;
    private final int heapBefore;
    private final int heapAfter;
    private final int heapTotal;
    private final double processingTime;

    public GCSample(double timestamp, int heapBefore, int heapAfter, int heapTotal, double processingTime) {
        this.timestamp = timestamp;
        this.heapAfter = heapAfter;
        this.heapBefore = heapBefore;
        this.heapTotal = heapTotal;
        this.processingTime = processingTime;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public int getHeapBefore() {
        return this.heapBefore;
    }

    public int getHeapAfter() {
        return this.heapAfter;
    }

    public int getHeapTotal() {
        return this.heapTotal;
    }

    public double getProcessingTime() {
        return this.processingTime;
    }

    public static GCSample fromXML(Element gcXML) {
        double timestamp = Double.parseDouble(gcXML.getAttributeValue("timestamp"));
        int heapBefore = Integer.parseInt(gcXML.getAttributeValue("heapBefore"));
        int heapAfter = Integer.parseInt(gcXML.getAttributeValue("heapAfter"));
        int heapTotal = Integer.parseInt(gcXML.getAttributeValue("heapTotal"));
        double processingTime = Double.parseDouble(gcXML.getAttributeValue("processingTime"));
        return new GCSample(timestamp, heapBefore, heapAfter, heapTotal, processingTime);
    }
}

