/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.common.IOUtil;
import org.codehaus.mojo.chronos.common.ProjectBaseDir;
import org.codehaus.mojo.chronos.common.ServerLogParser;
import org.codehaus.mojo.chronos.common.TestDataDirectory;
import org.codehaus.mojo.chronos.jmeter.GCLogParser;
import org.codehaus.mojo.chronos.jmeter.JMeterLogParser;
import org.xml.sax.SAXException;

public class JMeterOutputMojo
extends AbstractMojo {
    public MavenProject project;
    private File jmeterOutput;
    private String dataid;
    private File gclogfile;

    public void execute() throws MojoExecutionException {
        if (!this.jmeterOutput.exists()) {
            throw new MojoExecutionException("Invalid argument 'input', " + this.jmeterOutput.getPath() + " does not exist.");
        }
        TestDataDirectory testDataDirectory = new ProjectBaseDir(this.project, this.getLog()).getDataDirectory(this.dataid);
        if (this.jmeterOutput.isDirectory()) {
            File[] inputFiles;
            for (File outputJtlFile : inputFiles = IOUtil.listFilesWithExtension((File)this.jmeterOutput, (String)"jtl")) {
                JMeterOutputMojo.convertJMeterOutput(testDataDirectory, outputJtlFile, this.getLog());
            }
        } else if (this.isJtlFile(this.jmeterOutput)) {
            JMeterOutputMojo.convertJMeterOutput(testDataDirectory, this.jmeterOutput, this.getLog());
        } else {
            throw new MojoExecutionException("Executing jmeter tests is not supported. We suggest using the jmeter-maven-plugin ");
        }
        JMeterOutputMojo.convertGCLog(testDataDirectory, this.getGcLogFile(), this.getLog());
    }

    public static void convertGCLog(TestDataDirectory testDataDirectory, File gcLogFile, Log log) throws MojoExecutionException {
        if (gcLogFile != null && gcLogFile.exists()) {
            try {
                log.debug((CharSequence)("Parsing GC log file " + gcLogFile));
                new GCLogParser(log).convertToGCXml(gcLogFile, testDataDirectory.getGCLogFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to parseJtl20 garbage collection log", (Exception)e);
            }
            catch (SAXException e) {
                throw new MojoExecutionException("Unable to parseJtl20 garbage collection log", (Exception)e);
            }
            catch (XMLStreamException e) {
                throw new MojoExecutionException("Unable to parseJtl20 garbage collection log", (Exception)e);
            }
        }
    }

    public static void convertJMeterOutput(TestDataDirectory testDataDirectory, File jtlFile, Log log) throws MojoExecutionException {
        try {
            String jtlName = IOUtil.removeExtension((String)jtlFile.getName());
            new JMeterLogParser(log).convertToChronosXml(jtlFile, testDataDirectory.getResponsetimeSamplesFile(jtlName));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not parse jmeter log", e);
        }
    }

    public static void convertServerLog(TestDataDirectory testDataDirectory, File serverLogInput, Log log) throws MojoExecutionException {
        File serverLogOutput = new File(testDataDirectory.getDirectory(), "serverlog.xml");
        File serverStructureOutput = new File(testDataDirectory.getDirectory(), "serverstructure.xml");
        log.info((CharSequence)("converting serverlog: " + serverLogInput));
        ServerLogParser serverLogParser = new ServerLogParser(serverLogInput, serverLogOutput, serverStructureOutput);
        try {
            serverLogParser.parse();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to parse serverlog", e);
        }
    }

    private boolean isJtlFile(File input) {
        return input.getName().endsWith(".jtl");
    }

    private File getGcLogFile() {
        if (this.gclogfile != null) {
            return this.gclogfile;
        }
        File chronosDir = new ProjectBaseDir(this.getProject().getBasedir(), this.getLog()).getChronosDir();
        return new File(chronosDir, "gclog-" + this.dataid + ".txt");
    }

    protected final MavenProject getProject() {
        return this.project;
    }
}

