/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.chronos.common.IOUtil;
import org.codehaus.mojo.chronos.common.model.GCSample;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.xml.sax.SAXException;

public final class GCLogParser {
    private final Log log;
    private static final String CHRONOS_GC_DTD = "chronos-gc.dtd";
    private final XMLOutputFactory xmlOutputFactory;

    public GCLogParser(Log log) {
        this.log = log;
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GCSamples readGCSampleFile(File gcLogFile) throws IOException {
        FileReader fileReader = new FileReader(gcLogFile);
        LineNumberReader reader = new LineNumberReader(fileReader);
        GCSamples samples = new GCSamples();
        StringBuilder concatLines = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                concatLines.append(line);
                if (line.indexOf("]") <= -1) continue;
                GCSample sample = this.parseGCLogItem(concatLines.toString());
                samples.add(sample);
                concatLines = new StringBuilder();
            }
        }
        finally {
            reader.close();
        }
        return samples;
    }

    private GCSample parseGCLogItem(String source) {
        String timeinstant = null;
        String heapbeforeStr = null;
        String heapafterStr = null;
        String totalheap = null;
        String processingtimeStr = null;
        Pattern pattern = Pattern.compile("[0-9]*\\.[0-9]*:|[0-9]*K|[0-9]*\\.[0-9]*");
        Matcher matcher = pattern.matcher(source);
        int index = 0;
        while (matcher.find()) {
            if (matcher.group().length() <= 0) continue;
            switch (index) {
                case 0: {
                    timeinstant = matcher.group();
                    timeinstant = timeinstant.substring(0, timeinstant.length() - 1);
                    break;
                }
                case 1: {
                    heapbeforeStr = matcher.group();
                    heapbeforeStr = heapbeforeStr.substring(0, heapbeforeStr.length() - 1);
                    break;
                }
                case 2: {
                    heapafterStr = matcher.group();
                    heapafterStr = heapafterStr.substring(0, heapafterStr.length() - 1);
                    break;
                }
                case 3: {
                    totalheap = matcher.group();
                    totalheap = totalheap.substring(0, totalheap.length() - 1);
                    break;
                }
                case 4: {
                    processingtimeStr = matcher.group();
                    processingtimeStr = matcher.group();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++index;
        }
        return new GCSample(Double.parseDouble(timeinstant), Integer.parseInt(heapbeforeStr), Integer.parseInt(heapafterStr), Integer.parseInt(totalheap), Double.parseDouble(processingtimeStr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertToGCXml(File file, File output) throws SAXException, IOException, XMLStreamException {
        this.log.debug((CharSequence)("Parsing " + file.getName()));
        GCSamples samples = this.readGCSampleFile(file);
        this.log.debug((CharSequence)("Writing GC document to " + output.getName()));
        File directory = IOUtil.ensureDir((File)output.getParentFile());
        IOUtil.copyDTDToDir((String)CHRONOS_GC_DTD, (File)directory);
        XMLStreamWriter xmlStreamWriter = null;
        try {
            xmlStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(new BufferedOutputStream(new FileOutputStream(output)), "UTF-8");
            xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            xmlStreamWriter.writeDTD("<!DOCTYPE gcsamples PUBLIC \"SYSTEM\" \"chronos-gc.dtd\">");
            samples.writeTo(xmlStreamWriter);
        }
        finally {
            if (xmlStreamWriter != null) {
                xmlStreamWriter.close();
            }
        }
    }
}

