/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr.plan;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.codehaus.mojo.antlr.Environment;
import org.codehaus.mojo.antlr.metadata.Grammar;
import org.codehaus.mojo.antlr.metadata.GrammarFile;
import org.codehaus.mojo.antlr.metadata.XRef;
import org.codehaus.mojo.antlr.plan.GenerationPlan;
import org.codehaus.plexus.util.StringUtils;

public class GenerationPlanBuilder {
    private final Environment environment;
    private final LinkedHashMap generationPlans = new LinkedHashMap();
    private XRef metadataXRef;

    public GenerationPlanBuilder(Environment environment) {
        this.environment = environment;
    }

    public synchronized List buildGenerationPlans(XRef metadataXRef) {
        this.metadataXRef = metadataXRef;
        Iterator grammarFiles = metadataXRef.iterateGrammarFiles();
        while (grammarFiles.hasNext()) {
            GrammarFile grammarFile = (GrammarFile)grammarFiles.next();
            this.loacteOrBuildGenerationPlan(grammarFile);
        }
        metadataXRef = null;
        return new ArrayList(this.generationPlans.values());
    }

    private GenerationPlan loacteOrBuildGenerationPlan(GrammarFile grammarFile) {
        GenerationPlan generationPlan = (GenerationPlan)this.generationPlans.get(grammarFile.getId());
        if (generationPlan == null) {
            generationPlan = this.buildGenerationPlan(grammarFile);
        }
        return generationPlan;
    }

    private GenerationPlan buildGenerationPlan(GrammarFile grammarFile) {
        File generationDirectory = StringUtils.isEmpty((String)grammarFile.getPackageName()) ? this.environment.getOutputDirectory() : new File(this.environment.getOutputDirectory(), grammarFile.getPackageName().replace('.', File.separatorChar));
        GenerationPlan generationPlan = new GenerationPlan(grammarFile.getId(), new File(grammarFile.getFileName()), generationDirectory, grammarFile.getGlibs());
        File leastRecentGrammarOutput = GenerationPlanBuilder.locateLeastRecentlyModifiedOutputFile(generationDirectory);
        for (int i = 0; i < grammarFile.getGlibs().length; ++i) {
            GrammarFile superGrammarGrammarFile = this.metadataXRef.getGrammarFileById(grammarFile.getGlibs()[i]);
            GenerationPlan superGrammarGenerationPlan = this.loacteOrBuildGenerationPlan(superGrammarGrammarFile);
            if (superGrammarGenerationPlan.isOutOfDate()) {
                generationPlan.markOutOfDate();
                continue;
            }
            if (superGrammarGenerationPlan.getSource().lastModified() <= leastRecentGrammarOutput.lastModified()) continue;
            generationPlan.markOutOfDate();
        }
        Iterator grammars = grammarFile.getGrammars().iterator();
        while (grammars.hasNext()) {
            GrammarFile superGrammarGrammarFile;
            Grammar grammar = (Grammar)grammars.next();
            File generatedParserFile = new File(this.environment.getOutputDirectory(), grammar.determineGeneratedParserPath());
            if (!generatedParserFile.exists()) {
                generationPlan.markOutOfDate();
            } else if (generatedParserFile.lastModified() < generationPlan.getSource().lastModified()) {
                generationPlan.markOutOfDate();
            }
            if (StringUtils.isNotEmpty((String)grammar.getSuperGrammarName()) && (superGrammarGrammarFile = this.metadataXRef.getGrammarFileByClassName(grammar.getSuperGrammarName())) != null) {
                GenerationPlan superGrammarGenerationPlan = this.loacteOrBuildGenerationPlan(superGrammarGrammarFile);
                generationPlan.addSuperGrammarId(superGrammarGenerationPlan.getId());
                if (superGrammarGenerationPlan.isOutOfDate()) {
                    generationPlan.markOutOfDate();
                } else if (superGrammarGenerationPlan.getSource().lastModified() > generatedParserFile.lastModified()) {
                    generationPlan.markOutOfDate();
                }
            }
            if (!StringUtils.isNotEmpty((String)grammar.getImportVocab())) continue;
            GrammarFile importVocabGrammarFile = this.metadataXRef.getGrammarFileByExportVocab(grammar.getImportVocab());
            if (importVocabGrammarFile == null) {
                this.environment.getLog().warn((CharSequence)("unable to locate grammar exporting specifcied import vocab [" + grammar.getImportVocab() + "]"));
                continue;
            }
            if (importVocabGrammarFile.getId().equals(grammarFile.getId())) continue;
            GenerationPlan importVocabGrammarGenerationPlan = this.loacteOrBuildGenerationPlan(importVocabGrammarFile);
            generationPlan.setImportVocabTokenTypesDirectory(importVocabGrammarGenerationPlan.getGenerationDirectory());
            if (importVocabGrammarGenerationPlan.isOutOfDate()) {
                generationPlan.markOutOfDate();
                continue;
            }
            if (importVocabGrammarGenerationPlan.getSource().lastModified() <= generatedParserFile.lastModified()) continue;
            generationPlan.markOutOfDate();
        }
        this.generationPlans.put(generationPlan.getId(), generationPlan);
        return generationPlan;
    }

    private static File locateLeastRecentlyModifiedOutputFile(File directory) {
        if (!directory.exists()) {
            return null;
        }
        File[] contents = directory.listFiles();
        if (contents.length == 0) {
            return null;
        }
        File oldest = contents[0];
        for (int i = 1; i < contents.length; ++i) {
            if (contents[i].lastModified() >= oldest.lastModified()) continue;
            oldest = contents[i];
        }
        return oldest;
    }
}

