/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.modello.plugin.java.javasource.Header;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JComment;
import org.codehaus.modello.plugin.java.javasource.JInterface;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.plexus.util.WriterFactory;

public class JCompUnit {
    private static final String DEFAULT_HEADER = "$Id$";
    private JComment header = null;
    private String packageName = null;
    private String fileName = null;
    private List<JClass> classes = null;
    private List<JInterface> interfaces = null;

    public JCompUnit(String packageName, String fileName) {
        this.packageName = packageName;
        this.fileName = fileName;
        this.init();
    }

    public JCompUnit(JClass jClass) {
        this.packageName = jClass.getPackageName();
        String filePrefix = jClass.getLocalName();
        this.fileName = filePrefix + ".java";
        this.init();
        this.classes.add(jClass);
    }

    public JCompUnit(JInterface jInterface) {
        this.packageName = jInterface.getPackageName();
        this.fileName = jInterface.getLocalName() + ".java";
        this.init();
        this.interfaces.add(jInterface);
    }

    private void init() {
        this.classes = new ArrayList<JClass>();
        this.interfaces = new ArrayList<JInterface>();
    }

    public void addStructure(JStructure jStructure) throws IllegalArgumentException {
        if (jStructure instanceof JInterface) {
            this.addInterface((JInterface)jStructure);
        } else if (jStructure instanceof JClass) {
            this.addClass((JClass)jStructure);
        } else {
            String err = "Unknown JStructure subclass '" + jStructure.getClass().getName() + "'.";
            throw new IllegalArgumentException(err);
        }
    }

    public void addClass(JClass jClass) {
        this.classes.add(jClass);
    }

    public void addInterface(JInterface jInterface) {
        this.interfaces.add(jInterface);
    }

    public SortedSet<String> getImports() {
        Enumeration<String> e;
        TreeSet<String> allImports = new TreeSet<String>();
        for (JClass jClass : this.classes) {
            e = jClass.getImports();
            while (e.hasMoreElements()) {
                allImports.add(e.nextElement());
            }
        }
        for (JInterface jInterface : this.interfaces) {
            e = jInterface.getImports();
            while (e.hasMoreElements()) {
                allImports.add(e.nextElement());
            }
        }
        return allImports;
    }

    public String getFilename(String destDir) {
        File pathFile;
        String filename = new String(this.fileName);
        String javaPackagePath = "";
        if (this.packageName != null && this.packageName.length() > 0) {
            javaPackagePath = this.packageName.replace('.', File.separatorChar);
        }
        if (!(pathFile = destDir == null ? new File(javaPackagePath) : new File(destDir, javaPackagePath)).exists()) {
            pathFile.mkdirs();
        }
        if (pathFile.toString().length() > 0) {
            filename = pathFile.toString() + File.separator + filename;
        }
        return filename;
    }

    public String getPackageName() {
        return this.packageName;
    }

    protected static String getPackageFromClassName(String className) {
        int idx = -1;
        idx = className.lastIndexOf(46);
        if (idx > 0) {
            return className.substring(0, idx);
        }
        return null;
    }

    public void print() {
        this.print(null, null);
    }

    public void print(String destDir) {
        this.print(destDir, null);
    }

    public void print(String destDir, String lineSeparator) {
        String filename = this.getFilename(destDir);
        File file = new File(filename);
        JSourceWriter jsw = null;
        try {
            jsw = new JSourceWriter(WriterFactory.newPlatformWriter((File)file));
        }
        catch (IOException ioe) {
            System.out.println("unable to create compilation unit file: " + filename);
            return;
        }
        if (lineSeparator == null) {
            lineSeparator = System.getProperty("line.separator");
        }
        jsw.setLineSeparator(lineSeparator);
        this.print(jsw);
        jsw.flush();
        jsw.close();
    }

    public void print(JSourceWriter jsw) {
        this.resolveNames();
        StringBuilder buffer = new StringBuilder();
        if (this.header != null) {
            this.header.print(jsw);
        } else {
            jsw.writeln("/*");
            jsw.writeln(" * $Id$");
            jsw.writeln("*/");
        }
        jsw.writeln();
        jsw.flush();
        if (this.packageName != null && this.packageName.length() > 0) {
            buffer.setLength(0);
            buffer.append("package ");
            buffer.append(this.packageName);
            buffer.append(';');
            jsw.writeln(buffer.toString());
            jsw.writeln();
        }
        jsw.writeln("  //---------------------------------------------/");
        jsw.writeln(" //- Imported classes, interfaces and packages -/");
        jsw.writeln("//---------------------------------------------/");
        jsw.writeln();
        SortedSet<String> allImports = this.getImports();
        String compUnitPackage = this.getPackageName();
        for (String importName : allImports) {
            String importsPackage = JStructure.getPackageFromClassName(importName);
            if (importsPackage == null || importsPackage.equals(compUnitPackage)) continue;
            jsw.write("import ");
            jsw.write(importName);
            jsw.writeln(';');
        }
        jsw.writeln();
        this.printStructures(jsw, true);
        this.printStructures(jsw, false);
        jsw.flush();
    }

    public final void printStructures(JSourceWriter jsw, boolean printPublic) {
        boolean isFirst = true;
        for (JInterface jInterface : this.interfaces) {
            if (jInterface.getModifiers().isPublic() != printPublic) continue;
            if (isFirst) {
                Header.print(jsw, printPublic);
                isFirst = false;
            }
            jInterface.print(jsw, true);
            jsw.writeln();
        }
        for (JClass jClass : this.classes) {
            if (jClass.getModifiers().isPublic() != printPublic) continue;
            if (isFirst) {
                Header.print(jsw, printPublic);
                isFirst = false;
            }
            jClass.print(jsw, true);
            jsw.writeln();
        }
    }

    public void setHeader(JComment comment) {
        this.header = comment;
    }

    private void resolveNames() {
    }
}

