/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.dom4j;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.java.JavaFieldMetadata;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugins.xml.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;

public class Dom4jWriterGenerator
extends AbstractModelloGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateDom4jWriter();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating Dom4j Writer.", (Throwable)ex);
        }
    }

    private void generateDom4jWriter() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = this.isPackageWithVersion() ? objectModel.getDefaultPackageName(true, this.getGeneratedVersion()) : objectModel.getDefaultPackageName(false, null);
        packageName = packageName + ".io.dom4j";
        String marshallerName = this.getFileName("Dom4jWriter");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, marshallerName);
        JClass jClass = new JClass(marshallerName);
        jClass.setPackageName(packageName);
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.util.Arrays");
        jClass.addImport("java.util.Iterator");
        jClass.addImport("java.util.Locale");
        jClass.addImport("java.text.DateFormat");
        jClass.addImport("org.codehaus.plexus.util.xml.Xpp3Dom");
        jClass.addImport("org.dom4j.Document");
        jClass.addImport("org.dom4j.DocumentException");
        jClass.addImport("org.dom4j.DocumentFactory");
        jClass.addImport("org.dom4j.Element");
        jClass.addImport("org.dom4j.io.OutputFormat");
        jClass.addImport("org.dom4j.io.XMLWriter");
        this.addModelImports(jClass, null);
        String root = objectModel.getRoot(this.getGeneratedVersion());
        ModelClass rootClass = objectModel.getClass(root, this.getGeneratedVersion());
        ModelClassMetadata metadata = (ModelClassMetadata)rootClass.getMetadata(ModelClassMetadata.ID);
        String rootElement = metadata == null || metadata.getTagName() == null ? Dom4jWriterGenerator.uncapitalise((String)root) : metadata.getTagName();
        JMethod marshall = new JMethod(null, "write");
        marshall.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElement));
        marshall.addException(new JClass("java.io.IOException"));
        JSourceCode sc = marshall.getSourceCode();
        sc.add("Document document = new DocumentFactory().createDocument();");
        sc.add("write" + root + "( " + rootElement + ", \"" + rootElement + "\", document );");
        sc.add("OutputFormat format = OutputFormat.createPrettyPrint();");
        sc.add("format.setLineSeparator( System.getProperty( \"line.separator\" ) );");
        sc.add("XMLWriter serializer = new XMLWriter( writer, format );");
        sc.add("serializer.write( document );");
        jClass.addMethod(marshall);
        this.writeAllClasses(objectModel, jClass);
        this.writeHelpers(jClass);
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClasses(Model objectModel, JClass jClass) {
        Iterator i = objectModel.getClasses(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelClass clazz = (ModelClass)i.next();
            this.writeClass(clazz, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) {
        XmlFieldMetadata fieldMetadata;
        ModelField field;
        String className = modelClass.getName();
        String uncapClassName = Dom4jWriterGenerator.uncapitalise((String)className);
        JMethod marshall = new JMethod(null, "write" + className);
        marshall.addParameter(new JParameter((JType)new JClass(className), uncapClassName));
        marshall.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        ModelClassMetadata metadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        if (metadata.isRootElement()) {
            marshall.addParameter(new JParameter((JType)new JClass("Document"), "parentElement"));
        } else {
            marshall.addParameter(new JParameter((JType)new JClass("Element"), "parentElement"));
        }
        marshall.addException(new JClass("java.io.IOException"));
        marshall.getModifiers().makePrivate();
        JSourceCode sc = marshall.getSourceCode();
        sc.add("if ( " + uncapClassName + " != null )");
        sc.add("{");
        sc.indent();
        sc.add("Element element = parentElement.addElement( tagName );");
        Iterator i = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (i.hasNext()) {
            field = (ModelField)i.next();
            fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            String fieldTagName = fieldMetadata.getTagName();
            if (fieldTagName == null) {
                fieldTagName = field.getName();
            }
            String type = field.getType();
            String value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (!fieldMetadata.isAttribute()) continue;
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.indent();
            sc.add("element.addAttribute( \"" + fieldTagName + "\", " + this.getValue(field.getType(), value, fieldMetadata) + " );");
            sc.unindent();
            sc.add("}");
        }
        Iterator fieldIterator = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (fieldIterator.hasNext()) {
            field = (ModelField)fieldIterator.next();
            fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (fieldMetadata.isAttribute()) continue;
            this.processField(field, fieldMetadata, uncapClassName, sc, modelClass, jClass);
        }
        sc.unindent();
        sc.add("}");
        jClass.addMethod(marshall);
    }

    private void processField(ModelField field, XmlFieldMetadata fieldMetadata, String uncapClassName, JSourceCode sc, ModelClass modelClass, JClass jClass) {
        String singularTagName;
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
        String fieldTagName = fieldMetadata.getTagName();
        if (fieldTagName == null) {
            fieldTagName = field.getName();
        }
        if ((singularTagName = fieldMetadata.getAssociationTagName()) == null) {
            singularTagName = this.singular(fieldTagName);
        }
        boolean wrappedList = "wrapped".equals(fieldMetadata.getListStyle());
        String type = field.getType();
        String value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
        if (field instanceof ModelAssociation) {
            ModelAssociation association = (ModelAssociation)field;
            String associationName = association.getName();
            if ("1".equals(association.getMultiplicity())) {
                sc.add(this.getValueChecker(type, value, (ModelField)association));
                sc.add("{");
                sc.indent();
                sc.add("write" + association.getTo() + "( " + value + ", \"" + fieldTagName + "\", element );");
                sc.unindent();
                sc.add("}");
            } else {
                type = association.getType();
                String toType = association.getTo();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    sc.add("Element listElement = element;");
                    if (wrappedList) {
                        sc.add("listElement = element.addElement( \"" + fieldTagName + "\" );");
                    }
                    sc.add("for ( Iterator iter = " + value + ".iterator(); iter.hasNext(); )");
                    sc.add("{");
                    sc.indent();
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add(toType + " o = (" + toType + ") iter.next();");
                        sc.add("write" + toType + "( o, \"" + singularTagName + "\", listElement );");
                    } else {
                        sc.add(toType + " " + this.singular(Dom4jWriterGenerator.uncapitalise((String)field.getName())) + " = (" + toType + ") iter.next();");
                        sc.add("listElement.addElement( \"" + singularTagName + "\" ).setText( " + this.singular(Dom4jWriterGenerator.uncapitalise((String)field.getName())) + " );");
                    }
                    sc.unindent();
                    sc.add("}");
                    sc.unindent();
                    sc.add("}");
                } else {
                    XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                    sc.add(this.getValueChecker(type, value, field));
                    sc.add("{");
                    sc.indent();
                    sc.add("Element listElement = element;");
                    if (wrappedList) {
                        sc.add("listElement = element.addElement( \"" + fieldTagName + "\" );");
                    }
                    sc.add("for ( Iterator iter = " + value + ".keySet().iterator(); iter.hasNext(); )");
                    sc.add("{");
                    sc.indent();
                    sc.add("String key = (String) iter.next();");
                    sc.add("String value = (String) " + value + ".get( key );");
                    if ("explode".equals(xmlAssociationMetadata.getMapStyle())) {
                        sc.add("Element assocElement = listElement.addElement( \"" + this.singular(associationName) + "\" );");
                        sc.add("assocElement.addElement( \"key\" ).setText( key );");
                        sc.add("assocElement.addElement( \"value\" ).setText( value );");
                    } else {
                        sc.add("listElement.addElement( key ).setText( value );");
                    }
                    sc.unindent();
                    sc.add("}");
                    sc.unindent();
                    sc.add("}");
                }
            }
        } else {
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.indent();
            if ("DOM".equals(field.getType())) {
                sc.add("writeXpp3DomToElement( (Xpp3Dom) " + value + ", element );");
            } else {
                sc.add("element.addElement( \"" + fieldTagName + "\" ).setText( " + this.getValue(field.getType(), value, fieldMetadata) + " );");
            }
            sc.unindent();
            sc.add("}");
        }
    }

    protected String getFileName(String suffix) throws ModelloException {
        String name = this.getModel().getName();
        return name + suffix;
    }

    private String getValue(String type, String initialValue, XmlFieldMetadata fieldMetadata) {
        String textValue = initialValue;
        if ("Date".equals(type)) {
            textValue = fieldMetadata.getFormat() == null ? "DateFormat.getDateTimeInstance( DateFormat.FULL, DateFormat.FULL , Locale.US ).format( " + textValue + " )" : "new java.text.SimpleDateFormat( \"" + fieldMetadata.getFormat() + "\", Locale.US ).format( " + textValue + " )";
        } else if (!"String".equals(type)) {
            textValue = "String.valueOf( " + textValue + " )";
        }
        return textValue;
    }

    private String getValueChecker(String type, String value, ModelField field) {
        String retVal = "boolean".equals(type) || "double".equals(type) || "float".equals(type) || "int".equals(type) || "long".equals(type) || "short".equals(type) || "byte".equals(type) ? "if ( " + value + " != " + field.getDefaultValue() + " )" : ("char".equals(type) ? "if ( " + value + " != '" + field.getDefaultValue() + "' )" : ("java.util.List".equals(type) || "java.util.Set".equals(type) || "java.util.Map".equals(type) || "java.util.Properties".equals(type) ? "if ( " + value + " != null && " + value + ".size() > 0 )" : ("String".equals(type) && field.getDefaultValue() != null ? "if ( " + value + " != null && !" + value + ".equals( \"" + field.getDefaultValue() + "\" ) )" : ("Date".equals(type) && field.getDefaultValue() != null ? "if ( " + value + " != null && !" + value + ".equals( \"" + field.getDefaultValue() + "\" ) )" : "if ( " + value + " != null )"))));
        return retVal;
    }

    private void writeHelpers(JClass jClass) {
        JMethod method = new JMethod(null, "writeXpp3DomToElement");
        method.addParameter(new JParameter((JType)new JClass("Xpp3Dom"), "xpp3Dom"));
        method.addParameter(new JParameter((JType)new JClass("Element"), "parentElement"));
        JSourceCode sc = method.getSourceCode();
        sc.add("Element element = parentElement.addElement( xpp3Dom.getName() );");
        sc.add("if ( xpp3Dom.getValue() != null )");
        sc.add("{");
        sc.indent();
        sc.add("element.setText( xpp3Dom.getValue() );");
        sc.unindent();
        sc.add("}");
        sc.add("for ( Iterator i = Arrays.asList( xpp3Dom.getAttributeNames() ).iterator(); i.hasNext(); )");
        sc.add("{");
        sc.indent();
        sc.add("String name = (String) i.next();");
        sc.add("element.addAttribute( name, xpp3Dom.getAttribute( name ) );");
        sc.unindent();
        sc.add("}");
        sc.add("for ( Iterator i = Arrays.asList( xpp3Dom.getChildren() ).iterator(); i.hasNext(); )");
        sc.add("{");
        sc.indent();
        sc.add("Xpp3Dom child = (Xpp3Dom) i.next();");
        sc.add("writeXpp3DomToElement( child, element );");
        sc.unindent();
        sc.add("}");
        jClass.addMethod(method);
    }
}

