/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.requirement;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.installer.RequirementChecker;
import java.util.Date;

public class ExpiredChecker
implements RequirementChecker {
    private final InstallData installData;
    private final Prompt prompt;

    public ExpiredChecker(InstallData installData, Prompt prompt) {
        this.installData = installData;
        this.prompt = prompt;
    }

    public boolean check() {
        if (!this.expires()) {
            return true;
        }
        try {
            if (this.expired()) {
                this.showExpired();
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.prompt.error(String.format("Could not check expiration date because: %s.  Please correct the installer.", ex.toString()));
            return true;
        }
    }

    private boolean expired() {
        Date expiresDate = this.installData.getInfo().getExpiresDate();
        return new Date().after(expiresDate);
    }

    private boolean expires() {
        return this.installData.getInfo().getExpiresDate() != null;
    }

    protected void showExpired() {
        String message = "This installer has expired.";
        if (this.installData.getInfo().getAppURL() != null) {
            String urlText = this.installData.getInfo().getAppURL();
            message = message + "\n\nPlease download a new one from " + urlText;
        }
        this.prompt.error(message);
    }
}

